<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="UTF-8" />
      <link rel="preload" src="{{url('/accets/new-landing/images/banner.webp')}}"/>
      <link rel="preload" src="{{url('/accets/new-landing/images/togglebytes-logo.webp')}}" />
      <link rel="preconnect" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/" />
      <meta name="description" content="ToggleBytes is an iOS & Android App development company developing apps on Hybrid platforms like Flutter and React Native. Togglebytes also develops Apps on Android Native and Swift Platforms. We have best mobile app developers in our team at togglebytes and serve clients globally">
      <meta http-equiv="X-UA-Compatible" content="IE=edge" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0" />
      <!-- Google Tag Manager -->
         <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
         new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
         j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
         'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
         })(window,document,'script','dataLayer','GTM-MLVZ9D2');</script>
      <!-- End Google Tag Manager -->
      <link
         href="{{url('/accets/new-landing/assets/bootstrap/bootstrap.min.css')}}"
         rel="stylesheet"
         />
      <link rel="stylesheet" href="{{url('/accets/new-landing/assets/owlcarousel/dist/assets/owl.carousel.min.css')}}">
      <link href="{{url('/accets/new-landing/assets/aos/aos.css')}}" rel="stylesheet">
      <link rel="stylesheet" href="{{url('/accets/new-landing/style-min.css')}}">
      <link rel="stylesheet" href="{{url('/accets/new-landing/loader.css')}}" />
      <title>iOS & Android App Development Company</title>
      
      <style>
         .logo-tog{
         width: 222px;
         }
         @media screen and (max-width: 480px) {
         .logo-tog{
         width: 222px;
         }
         }
      </style>
   <body>
      <!-- Google Tag Manager (noscript) -->
      <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MLVZ9D2"
      height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
      <!-- End Google Tag Manager (noscript) -->

      <div class="preloader">
         <div class="preloader-content">
            <div class="preloader-icon-container">
               <svg
                  version="1.1"
                  xmlns="http://www.w3.org/2000/svg"
                  width="32"
                  height="32"
                  viewBox="0 0 32 32"
                  class="preloader-icon"
                  >
                  <title>smile</title>
                  <path
                     d="M28.541 17.722c-0.040-0.488-0.055-0.871-0.107-1.247-0.107-0.772-0.223-1.542-0.358-2.31-0.056-0.321-0.135-0.65-0.27-0.945-0.216-0.469-0.485-0.912-0.736-1.366-0.169-0.308-0.336-0.619-0.521-0.918-0.069-0.112-0.205-0.18-0.284-0.289-0.317-0.438-0.58-0.922-0.943-1.32-0.538-0.591-1.12-1.148-1.722-1.674-0.645-0.562-1.324-1.086-2.008-1.601-0.67-0.506-1.361-0.982-2.049-1.464-0.283-0.198-0.573-0.389-0.873-0.561-0.199-0.116-0.424-0.275-0.633-0.27-0.529 0.013-0.977-0.126-1.451-0.363-0.548-0.275-1.152-0.431-1.807-0.302-0.873 0.175-1.759 0.28-2.639 0.424-0.195 0.032-0.385 0.096-0.575 0.158-0.457 0.148-0.918 0.286-1.365 0.462-0.304 0.121-0.58 0.315-0.881 0.447-0.239 0.105-0.544 0.109-0.737 0.262-0.507 0.403-0.976 0.854-1.443 1.303-0.214 0.208-0.385 0.461-0.583 0.687-0.437 0.498-0.877 0.993-1.314 1.49-0.039 0.045-0.060 0.107-0.090 0.159-0.218 0.381-0.443 0.759-0.655 1.144-0.232 0.426-0.475 0.849-0.674 1.292-0.128 0.284-0.187 0.6-0.267 0.903-0.062 0.232-0.135 0.467-0.154 0.706-0.041 0.487-0.054 0.976-0.071 1.466-0.017 0.447-0.021 0.895-0.036 1.343-0.027 0.777-0.107 1.555-0.077 2.329 0.026 0.637 0.152 1.275 0.285 1.901 0.094 0.444 0.254 0.877 0.424 1.3 0.128 0.313 0.316 0.601 0.479 0.899 0.137 0.249 0.25 0.516 0.424 0.737 0.298 0.378 0.632 0.726 0.954 1.082 0.122 0.135 0.262 0.253 0.381 0.389 0.389 0.443 0.8 0.869 1.152 1.341 0.356 0.48 0.968 0.642 1.305 1.13 0.010 0.013 0.027 0.022 0.042 0.030 0.525 0.283 1.048 0.565 1.574 0.844 0.248 0.131 0.488 0.298 0.751 0.375 0.529 0.154 1.068 0.283 1.612 0.372 0.578 0.096 1.162 0.145 1.746 0.2 0.565 0.054 1.134 0.104 1.703 0.13 1.181 0.053 2.368 0.14 3.531-0.185 0.040-0.010 0.086-0.004 0.128-0.006 0.731-0.041 1.409-0.279 2.064-0.578 0.397-0.18 0.77-0.413 1.151-0.628 0.46-0.259 0.918-0.521 1.371-0.788 0.096-0.056 0.171-0.146 0.261-0.214 0.272-0.205 0.559-0.393 0.819-0.611 0.582-0.485 0.881-1.223 1.484-1.691 0.031-0.026 0.046-0.072 0.064-0.11 0.073-0.154 0.14-0.313 0.218-0.465 0.227-0.434 0.479-0.855 0.683-1.3 0.113-0.245 0.154-0.525 0.222-0.791 0.090-0.345 0.191-0.69 0.254-1.040 0.041-0.227 0.006-0.467 0.033-0.699 0.064-0.556 0.145-1.112 0.205-1.567zM0.003 18.721c0-1.073-0.009-1.993 0.005-2.912 0.005-0.362 0.139-0.74 0.071-1.082-0.096-0.488 0.134-0.93 0.074-1.4-0.010-0.081 0.014-0.171 0.039-0.253 0.172-0.591 0.336-1.185 0.526-1.771 0.119-0.369 0.243-0.742 0.425-1.081 0.393-0.723 0.858-1.409 1.23-2.142 0.289-0.57 0.651-1.079 1.053-1.562 0.543-0.652 1.080-1.319 1.691-1.906 0.365-0.351 0.675-0.773 1.169-1.009 0.347-0.166 0.618-0.482 0.935-0.714 0.128-0.092 0.303-0.119 0.43-0.212 0.392-0.288 0.859-0.399 1.3-0.565 0.399-0.15 0.826-0.231 1.235-0.354 0.457-0.139 0.908-0.297 1.365-0.434 0.128-0.039 0.274-0.017 0.408-0.042 0.475-0.089 0.95-0.193 1.427-0.276 0.289-0.050 0.582-0.072 0.873-0.108 0.478-0.058 0.954-0.135 1.434-0.167 0.238-0.017 0.485 0.032 0.722 0.082 0.225 0.046 0.424 0.085 0.632-0.077 0.232-0.18 0.514-0.085 0.767-0.042 0.511 0.085 1.040 0.146 1.518 0.334 0.56 0.216 1.075 0.547 1.603 0.844 0.375 0.211 0.738 0.442 1.104 0.668 0.189 0.118 0.38 0.234 0.555 0.37 0.489 0.381 0.963 0.783 1.457 1.157 0.36 0.27 0.751 0.5 1.117 0.761 0.118 0.085 0.198 0.223 0.304 0.327 0.203 0.196 0.408 0.39 0.623 0.574 0.231 0.2 0.475 0.387 0.714 0.579 0.033 0.027 0.076 0.046 0.103 0.078 0.417 0.48 0.835 0.959 1.246 1.445 0.285 0.335 0.569 0.672 0.833 1.022 0.222 0.295 0.416 0.613 0.619 0.925 0.354 0.543 0.803 1.052 1.034 1.644 0.257 0.66 0.66 1.267 0.737 2.008 0.060 0.578 0.257 1.142 0.365 1.717 0.066 0.347 0.083 0.701 0.117 1.053 0.045 0.478 0.083 0.955 0.123 1.433 0.009 0.104 0.022 0.209 0.010 0.312-0.056 0.506-0.128 1.012-0.177 1.519-0.032 0.334-0.060 0.672-0.045 1.005 0.019 0.403-0.212 0.727-0.288 1.099-0.072 0.353-0.193 0.699-0.324 1.036-0.064 0.168-0.208 0.304-0.295 0.466-0.146 0.27-0.262 0.556-0.415 0.822-0.254 0.439-0.51 0.88-0.797 1.297-0.258 0.375-0.555 0.724-0.848 1.075-0.18 0.216-0.381 0.412-0.578 0.616-0.191 0.2-0.371 0.415-0.583 0.592-0.351 0.294-0.718 0.57-1.088 0.839-0.439 0.317-0.887 0.622-1.335 0.925-0.173 0.116-0.353 0.226-0.541 0.312-0.311 0.141-0.632 0.257-0.945 0.39-0.271 0.116-0.533 0.254-0.809 0.356-0.329 0.123-0.693 0.162-0.955 0.439-0.026 0.028-0.098 0.008-0.148 0.015-0.46 0.075-0.936 0.103-1.37 0.252-0.169 0.058-0.308 0.049-0.464 0.064-0.44 0.042-0.878 0.118-1.319 0.152-0.854 0.064-1.708 0.141-2.564 0.154-0.61 0.008-1.223-0.069-1.832-0.13-0.854-0.085-1.708-0.18-2.558-0.291-0.532-0.071-1.068-0.149-1.586-0.286-0.6-0.158-1.142-0.467-1.665-0.8-0.443-0.283-0.905-0.537-1.343-0.827-0.313-0.208-0.601-0.455-0.899-0.686-0.127-0.096-0.259-0.189-0.376-0.295-0.267-0.244-0.53-0.494-0.787-0.749-0.145-0.144-0.262-0.317-0.413-0.452-0.155-0.14-0.34-0.247-0.507-0.375-0.039-0.028-0.054-0.083-0.083-0.123-0.226-0.3-0.448-0.605-0.681-0.899-0.27-0.34-0.548-0.67-0.822-1.005-0.141-0.175-0.297-0.342-0.415-0.532-0.367-0.593-0.745-1.181-1.068-1.798-0.261-0.497-0.471-1.026-0.663-1.555-0.114-0.315-0.146-0.659-0.218-0.989-0.071-0.334-0.145-0.668-0.187-0.858z"
                     ></path>
                  <path
                     d="M25.201 18.4c0.032 0.205 0.042 0.367 0.086 0.519 0.108 0.372-0.108 0.647-0.291 0.904-0.565 0.794-1.361 1.402-1.89 2.218-0.306 0.467-0.792 0.71-1.12 1.13-0.040 0.051-0.116 0.075-0.172 0.116-0.169 0.122-0.339 0.248-0.507 0.372-0.028 0.021-0.051 0.049-0.081 0.062-0.787 0.304-1.559 0.663-2.368 0.89-0.485 0.136-0.993 0.315-1.526 0.238-0.076-0.010-0.158 0.006-0.232 0.026-0.514 0.134-1.035 0.103-1.555 0.104-0.189 0-0.379 0.054-0.565 0.045-0.29-0.014-0.578-0.067-0.867-0.094-0.154-0.015-0.309-0.013-0.465-0.015-0.528-0.009-1.025-0.182-1.517-0.338-0.506-0.16-1.002-0.366-1.479-0.595-0.494-0.236-0.986-0.491-1.434-0.803-0.365-0.256-0.641-0.637-0.996-0.909-0.44-0.335-0.613-0.873-1.002-1.229-0.338-0.308-0.456-0.737-0.729-1.073-0.177-0.216-0.247-0.439-0.085-0.706 0.177-0.295 0.312-0.614 0.497-0.903 0.272-0.425 0.783-0.547 1.267-0.483 0.446 0.058 0.715 0.309 1 0.591 0.085 0.083 0.193 0.144 0.29 0.216 0.062 0.046 0.146 0.082 0.177 0.145 0.121 0.236 0.223 0.48 0.334 0.723 0.017 0.039 0.021 0.092 0.049 0.119 0.39 0.349 0.553 0.899 1.067 1.149 0.449 0.22 0.841 0.565 1.301 0.746 0.629 0.25 1.297 0.401 1.952 0.589 0.116 0.033 0.239 0.055 0.36 0.058 0.385 0.009 0.773 0.008 1.158 0.006 0.334-0.003 0.675 0.033 0.999-0.026 0.679-0.121 1.359-0.258 2.016-0.458 0.345-0.105 0.675-0.318 0.959-0.55 0.457-0.375 0.883-0.792 1.3-1.213 0.308-0.312 0.571-0.668 0.873-0.989 0.213-0.223 0.381-0.485 0.711-0.609 0.257-0.095 0.461-0.333 0.687-0.509 0.383-0.295 0.773-0.321 1.197-0.073 0.207 0.119 0.41 0.214 0.457 0.485 0.013 0.064 0.125 0.108 0.144 0.123zM21.098 12.679c0.063-0.411 0.127-0.8 0.18-1.192 0.035-0.263 0.086-0.53 0.071-0.792-0.032-0.514 0.371-0.783 0.622-1.115 0.321-0.422 0.883-0.379 1.298 0.013 0.268 0.252 0.561 0.488 0.777 0.781 0.259 0.349 0.239 0.77 0.146 1.189-0.054 0.247-0.072 0.501-0.107 0.752-0.054 0.375-0.042 0.778-0.184 1.117-0.11 0.266-0.223 0.659-0.684 0.622-0.095-0.008-0.208 0.109-0.302 0.182-0.187 0.145-0.365 0.27-0.634 0.231-0.18-0.027-0.371 0.042-0.559 0.059-0.199 0.018-0.312-0.099-0.353-0.276-0.059-0.252-0.1-0.508-0.144-0.764-0.046-0.272-0.086-0.544-0.127-0.809zM8.655 11.471c0.090-0.119 0.205-0.229 0.262-0.363 0.241-0.589 0.683-0.83 1.274-0.642 0.244 0.077 0.491 0.184 0.696 0.333 0.137 0.1 0.213 0.294 0.304 0.452 0.158 0.276 0.343 0.543 0.452 0.837 0.153 0.417 0.275 0.85 0.354 1.287 0.049 0.261-0.159 0.466-0.376 0.575-0.313 0.159-0.65 0.274-0.984 0.389-0.218 0.077-0.447 0.128-0.673 0.18-0.227 0.050-0.629-0.222-0.69-0.446-0.175-0.647-0.362-1.291-0.526-1.939-0.059-0.226-0.067-0.466-0.092-0.663z"
                     ></path>
               </svg>
            </div>
            <div class="preloader-text"></div>
         </div>
      </div>
      <header>
         <nav class="navbar navbar-expand-lg bg-light">
            <div class="container">
               <a aria-label="logo-img" data-aos="fade-right" class="navbar-brand" href="#">
               <img class="logo-tog" src="{{url('/accets/new-landing/images/togglebytes-logo.webp')}}" alt=""></a>
               <button class="navbar-toggler collapsed pull-left" type="button" data-bs-toggle="collapse"
                  data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                  aria-expanded="false" aria-label="Toggle navigation">
               <span class="navbar-toggler-icon"></span>
               </button>
               <div class="collapse navbar-collapse" id="navbarSupportedContent">
                  <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                     <li data-aos="flip-down"  class="nav-item"><a class="nav-link home" href="#">Home</a></li>
                     <li data-aos="flip-down"  class="nav-item"><a class="nav-link" href="#services">Services</a></li>
                     <li data-aos="flip-down"  class="nav-item"><a class="nav-link" href="#associations">Associations</a></li>
                     <li data-aos="flip-down"  class="nav-item"><a class="nav-link" href="#work">Work</a></li>
                     <li data-aos="flip-down"  class="nav-item"><a class="nav-link" href="#client">Client</a></li>
                     <li data-aos="flip-down"  class="nav-item"><a class="nav-link" href="#review">Review</a></li>
                     <li data-aos="flip-down"  class="nav-item"><a class="nav-link" href="#contact">Contact</a></li>
                  </ul>
               </div>
            </div>
         </nav>
      </header>
      <!-- banner section started -->
      <section class="banner-section">
         <div class="container ">
            <div class="row justify-content-between align-items-center" >
               <!-- left side row -->
               <div class="col-12 col-lg-5 col-lg-offset-1">
                  <div class="banner-left-wrapper" data-aos="fade-right">
                     <h1 class="banner-heading">
                        Develop Mobile Apps for your business
                     </h1>
                     <h2 class="banner-para">
                        On iOS & Android using Cross platform & Native frameworks
                     </h2>
                  </div>
               </div>
               <!-- right side row -->
               <div data-aos="flip-left" class="col-12 col-lg-5 col-lg-offset-1">
                  <div class="banner-input-group">
                     <div class="contact-form-banner">
                        <form  class="mb-2 mx-auto" action="" data-toggle="modal" id="bannerForm" method='POST'>
                            {{csrf_field()}}
                            <input type="hidden" name="url" id="token" value="{{URL::current()}}">
                           <div class="contact-company">
                              <p class="contact">
                                 <a href="tel:+919029560949" class="telephone-link">Call Us: +91-9029-560-949</a>
                              </p>
                           </div>
                           <div class="name-input">
                              <input type="name" id="username" class="custom-input mb-3" name="name" placeholder="Full Name*" required >
                           </div>
                           <div class="phone-number mb-3">
                              <input id="phone" name="phone" type="tel" class="custom-input mb-3" placeholder="8240-974-561" required>
                           </div>
                           <div class="mb-1">
                              <input type="email" id="useremail" class="custom-input mb-3" name="email" placeholder="Email Id*" required>
                           </div>
                           <button class="enquire-now"  id="my-btn1" type="button" onclick="checkData('bannerForm')">
                           Enquire Now
                           </button>
                        </form>
                     </div>
                  </div>
                  <!-- Modal -->
                  <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="false">
                     <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                           <div class="modal-header">
                              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                           </div>
                           <div class="modal-body text-center">
                              <div class="thank-you-pop">
                                 <img alt="svgImg" src="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHg9IjBweCIgeT0iMHB4Igp3aWR0aD0iNDgiIGhlaWdodD0iNDgiCnZpZXdCb3g9IjAgMCA0OCA0OCIKc3R5bGU9IiBmaWxsOiMwMDAwMDA7Ij48cGF0aCBmaWxsPSIjYzhlNmM5IiBkPSJNMzYsNDJIMTJjLTMuMzE0LDAtNi0yLjY4Ni02LTZWMTJjMC0zLjMxNCwyLjY4Ni02LDYtNmgyNGMzLjMxNCwwLDYsMi42ODYsNiw2djI0QzQyLDM5LjMxNCwzOS4zMTQsNDIsMzYsNDJ6Ij48L3BhdGg+PHBhdGggZmlsbD0iIzRjYWY1MCIgZD0iTTM0LjU4NSAxNC41ODZMMjEuMDE0IDI4LjE3MiAxNS40MTMgMjIuNTg0IDEyLjU4NyAyNS40MTYgMjEuMDE5IDMzLjgyOCAzNy40MTUgMTcuNDE0eiI+PC9wYXRoPjwvc3ZnPg=="/>
                                 <h1>Thank You!</h1>
                                 <p>Your submission is received and we will contact you soon</p>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- iframe block started -->
      <section class="container section">
         
         <div class="col-12 text-center"><h1 class="heading">Top App Development Company</h1></div>
         <div class="col-12 text-center"><h2 class="sub-heading">We have best app developers in house to create the app for your business</h2></div>
         <div data-aos="zoom-in-down" class="d-flex align-items-center justify-content-center">
            <div class="desk-iframe">
               <iframe loading="lazy" class="lazzy-iframe iframe-res" width="560" height="315" data-src="https://www.youtube.com/embed/ts8cznnGdGs?playlist=ts8cznnGdGs&autoplay=1&mute=1&controls=0&loop=1" title="Togglebytes is Best App Development Company in India" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" ></iframe>
            </div>
            <div class="mobile-iframe">
               <img id="youtube-embed" alt="thumbnail" src="{{url('/accets/new-landing/images/thumbnail.webp')}}" />
               <!-- <iframe class="iframe-res" width="560" height="315" src="https://www.youtube.com/embed/ts8cznnGdGs?&controls=0&loop=1"  ></iframe> -->
            </div>
            </div>
      </section>
      <!-- Services block started -->
      <section class="container section services-section" id="services">
         <div class="container services">
            <div class="row mt-5">
               <div class="col-12">
                  <div data-aos="zoom-in-down" class="">
                     <h1 class="heading text-center">
                        Mobile App Development Services
                     </h1>
                  </div>
               </div>
            </div>
            <div class="row">
               <div class="col-12">
                  <div class="d-flex developmentblock align-items-center justify-content-center flex-wrap flex-xl-nowrap mt-5">
                     <div class=" text-center services-blocks">
                        <img  loading="lazy"  data-aos="flip-right" src="{{url('/accets/new-landing/images/enterprise.svg')}}" class="block-image" alt="enterprise">
                        <h1 data-aos="zoom-out" class="text-center para-1">
                           Enterprise Mobile App development
            </h1>
                     </div>
                     <div class="text-center services-blocks-2">
                        <img  loading="lazy" data-aos="flip-right" src="{{url('/accets/new-landing/images/b2b.svg')}}" class="block-image" alt="b2b">
                        <h1 data-aos="zoom-out" class="text-center para-2">
                           Business to Business App development
            </h1>
                     </div>
                     <div class="text-center services-blocks-2">
                        <img  loading="lazy" data-aos="flip-right" src="{{url('/accets/new-landing/images/b2c.svg')}}" class="block-image" alt="b2c">
                        <h1 data-aos="zoom-out" class="text-center para-3">
                           Business to Customer App development
            </h1>
                     </div>
                     <div class="text-center services-blocks-2">
                        <img  loading="lazy" data-aos="flip-right" src="{{url('/accets/new-landing/images/internal.svg')}}" class="block-image"alt="internal">
                        <h1 data-aos="zoom-out" class="text-center para-3">
                           Internal Process App development
            </h1>
                     </div>
                  </div>
               </div>
               <div class="devices text-center">
                  <img  loading="lazy" data-aos="fade-up" src="{{url('/accets/new-landing/images/devices.svg')}}" alt="devices" class="block-image-device">
               </div>
            </div>
         </div>
      </section>


      <!-- Startups-
      <section class="container section">
         
         <div class="col-12 text-center"><h1 class="heading">Go to Market Live with an App</h1></div>
         <div class="col-12 text-center"><h2 class="sub-heading">We help your startup to go live in 15 days</h2></div>
         <div class="col-md-12">
            <div class="col-md-8 col-lg-8">
                  <h1>MVP</h1><br />
                  <h6>Minimum Viable Product</h6>
            </div>
            <div class="col-md-4 col-lg-4">Learn from your Customers</div>
         </div>
         
      </section> -->
      <!--Our Associations  -->
      <section class="container section association-section" id="associations">
         <div class="container association">
            <div class="row">
               <div data-aos="fade-down" class="col-12">
                  <h1 class="heading text-center">Our Associations</h1>
                  <p class="association-para text-center">We are recognised by top reviewers globally</p>
               </div>
            </div>
            <div class="row">
               <div class="col-12">
                  <div class="associations-flex d-flex align-items-center justify-content-center flex-wrap flex-xl-nowrap mt-4">
                     <div class="block-1">
                        <img loading="lazy" data-aos="flip-right" src="{{url('/accets/new-landing/images/clutch.webp')}}" alt="clutch" class="block-images">
                     </div>
                     <div class="block-1">
                        <img loading="lazy" data-aos="flip-right" src="{{url('/accets/new-landing/images/futura.webp')}}" alt="futura" class="block-images">
                     </div>
                     <div class="block-1">
                        <img loading="lazy" data-aos="flip-right" src="{{url('/accets/new-landing/images/nasscom.webp')}}" alt="nasscom" class="block-images">
                     </div>
                     <div class="block-1">
                        <img loading="lazy" data-aos="flip-right" src="{{url('/accets/new-landing/images/goodfirm.webp')}}" alt="Goodfirms" class="block-images">
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- Our Work Section started -->
      <section class="container section works" id="work">
         <div class="container">
            <div class="row">
               <div data-aos="fade-down" class="col-12">
                  <h1 class="heading text-center">
                     Featured App Development Portfolio
                  </h1>
               </div>
            </div>
            <div class="row applications-details mt-3" rel="one" id="slide1">
               <div class="col-12 col-lg-6">
                  <div data-aos="fade-right" class="phone-image ">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/fassos-phone.webp')}}" alt="phone" class="phone-img">
                  </div>
               </div>
               <div class="col-12 col-lg-6">
                  <div data-aos="fade-left" class="work-details">
                     <div class="d-flex flex-column logo">
                        <div class="app-logo">
                           <img loading="lazy" src="{{url('/accets/new-landing/images/fassos-logo.webp')}}" alt="Faasos" class="faasos">
                        </div>
                     </div>
                     <div class="apphead mt-3">
                        <h3 class="head-faasos">
                           Faasos
                        </h3>
                     </div>
                     <div class="app-title">
                        <p class="app-title-para">
                           Food Delivery App
                        </p>
                     </div>
                     <div class="app-details">
                        <p class="app-details-para">
                           Love to order food online? If these three words, food online order excite you then
                           chuck
                           all those traditional food delivery apps and get Faasos. Not just the best food
                           ordering
                           app, it is a full-fledged food court on your phone.
                        </p>
                     </div>
                     <div class="app-button">
                        <button class="faasos-button" onclick="slideNext(1)">
                        Next 
                        </button>
                     </div>
                  </div>
               </div>
            </div>
            <div class="row applications-details mt-3" style="display: none;" id="slide2" rel="two">
               <div class="col-12 col-lg-6">
                  <div data-aos="fade-right" class="phone-image ">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/fintify-phone.webp')}}" alt="phone" class="phone-img">
                  </div>
               </div>
               <div class="col-12 col-lg-6">
                  <div data-aos="fade-left" class="work-details">
                     <div class="d-flex flex-column logo">
                        <div class="app-logo">
                           <img loading="lazy" src="{{url('/accets/new-landing/images/fintify-logo.webp')}}" alt="Faasos" class="faasos">
                        </div>
                     </div>
                     <div class="apphead mt-3">
                        <h3 class="head-faasos">
                           Fintify
                        </h3>
                     </div>
                     <div class="app-title">
                        <p class="app-title-para">
                           Financial Services
                        </p>
                     </div>
                     <div class="app-details">
                        <p class="app-details-para">
                           Fintify is an integrated hyper- personal 
                           finance mobile application which is designed 
                           to give a single view of all your finances. 
                           We are a cross-border, multi-currency account aggregation platform
                           that makes tracking all global investments and money easy.
                        </p>
                     </div>
                     <div class="app-button">
                        <button class="faasos-button" onclick="slideNext(2)">
                        Next 
                        </button>
                     </div>
                  </div>
               </div>
            </div>
            <div class="row applications-details mt-3" style="display: none;" id="slide3" rel="three">
               <div class="col-12 col-lg-6">
                  <div data-aos="fade-right" class="phone-image ">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/super-selector-phone.webp')}}" alt="phone" class="phone-img">
                  </div>
               </div>
               <div class="col-12 col-lg-6">
                  <div data-aos="fade-left" class="work-details">
                     <div class="d-flex flex-column logo">
                        <div class="app-logo">
                           <img loading="lazy" src="{{url('/accets/new-landing/images/super-selector-logo.webp')}}" alt="Faasos" class="faasos">
                        </div>
                     </div>
                     <div class="apphead mt-3">
                        <h3 class="head-faasos">
                           Super Selector Kenya
                        </h3>
                     </div>
                     <div class="app-title">
                        <p class="app-title-para">
                           Online Betting
                        </p>
                     </div>
                     <div class="app-details">
                        <p class="app-details-para">
                           SSK is a Soccer betting application used in Kenya.
                           It is an upcoming application and hosts Contests for UEFA Champions League 
                           & English Premiere League.You can create upto 3 teams in each Contest Gamweek-wise
                           and bet on each player depending on their performance and expectations.
                        </p>
                     </div>
                     <div class="app-button">
                        <button class="faasos-button" onclick="slideNext(3)">
                        Next 
                        </button>
                     </div>
                  </div>
               </div>
            </div>
            <div class="row applications-details mt-3" style="display: none;" id="slide4" rel="four">
               <div class="col-12 col-lg-6">
                  <div data-aos="fade-right" class="phone-image ">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/pet-connect-phone.webp')}}" alt="phone" class="phone-img">
                  </div>
               </div>
               <div class="col-12 col-lg-6">
                  <div data-aos="fade-left" class="work-details">
                     <div class="d-flex flex-column logo">
                        <div class="app-logo">
                           <img loading="lazy" src="{{url('/accets/new-landing/images/pet-connect-logo.webp')}}" alt="Faasos" class="faasos">
                        </div>
                     </div>
                     <div class="apphead mt-3">
                        <h3 class="head-faasos">
                           PetKonnect
                        </h3>
                     </div>
                     <div class="app-title">
                        <p class="app-title-para">
                           Social Network
                        </p>
                     </div>
                     <div class="app-details">
                        <p class="app-details-para">
                           PetKonnect is a comprehensive online pet-services'
                           community for pets as well as stray animals.
                           Built on a philosophy of love for animals, PetKonnect champions 
                           equal rights and social inclusion for all animals.
                        </p>
                     </div>
                     <div class="app-button">
                        <button class="faasos-button" onclick="slideNext(4)">
                        Next 
                        </button>
                     </div>
                  </div>
               </div>
            </div>
            <div class="row applications-details mt-3" style="display: none;" id="slide5" rel="five">
               <div class="col-12 col-lg-6">
                  <div data-aos="fade-right" class="phone-image ">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/none-phone.webp')}}" alt="phone" class="phone-img">
                  </div>
               </div>
               <div class="col-12 col-lg-6">
                  <div data-aos="fade-left" class="work-details">
                     <div class="d-flex flex-column logo">
                        <div class="app-logo">
                           <img loading="lazy" src="{{url('/accets/new-landing/images/none.webp')}}" alt="Faasos" class="faasos">
                        </div>
                     </div>
                     <div class="apphead mt-3">
                        <h3 class="head-faasos">
                           Niine
                        </h3>
                     </div>
                     <div class="app-title">
                        <p class="app-title-para">
                           Health & Wellness
                        </p>
                     </div>
                     <div class="app-details">
                        <p class="app-details-para">
                           Niine period tracker is an app that helps
                           women track their period cycle on a monthly basis.
                           This app has a special feature of an open-forum which
                           allows a person to ask period related questions and get
                           live answers for it. The application also educates users on 
                           menstrual hygiene and related issues.
                        </p>
                     </div>
                     <div class="app-button">
                        <button class="faasos-button" onclick="slideNext(5)">
                        Next 
                        </button>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- mobile-version-our works -->
      <section class="container section works-mobile" id="work">
         <div class="container">
            <div class="row">
               <div data-aos="fade-down" class="col-12">
                  <h1 class="heading heading-work text-center">
                     Featured App Development Portfolio
                  </h1>
               </div>
            </div>
            <div data-aos="flip-left" class="row applications-details mt-3">
               <div class="col-12 col-lg-6">
                  <div class="phone-image ">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/fassos-phone.webp')}}" alt="phone" class="phone-img">
                  </div>
               </div>
               <div class="col-12 col-lg-6">
                  <div class="work-details">
                     <div class="d-flex flex-column logo">
                        <div class="app-logo">
                           <img loading="lazy" src="{{url('/accets/new-landing/images/fassos-logo.webp')}}" alt="Faasos" class="faasos">
                        </div>
                     </div>
                     <div class="apphead mt-3">
                        <h3 class="head-faasos">
                           Faasos
                        </h3>
                     </div>
                     <div class="app-title">
                        <p class="app-title-para">
                           Food Delivery App
                        </p>
                     </div>
                     <div class="app-details">
                        <p class="app-details-para">
                           Love to order food online? If these three words, food online order excite you then
                           chuck
                           all those traditional food delivery apps and get Faasos. Not just the best food
                           ordering
                           app, it is a full-fledged food court on your phone.
                        </p>
                     </div>
                  </div>
               </div>
            </div>
            <div data-aos="flip-left" class="row applications-details mt-3">
               <div class="col-12 col-xl-6">
                  <div class="phone-image ">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/fintify-phone.webp')}}" alt="phone" class="phone-img">
                  </div>
               </div>
               <div class="col-12 col-xl-6">
                  <div class="work-details">
                     <div class="d-flex flex-column logo">
                        <div class="app-logo">
                           <img loading="lazy" src="{{url('/accets/new-landing/images/fintify-logo.webp')}}" alt="Faasos" class="faasos">
                        </div>
                     </div>
                     <div class="apphead mt-3">
                        <h3 class="head-faasos">
                           Fintify
                        </h3>
                     </div>
                     <div class="app-title">
                        <p class="app-title-para">
                           Financial Services
                        </p>
                     </div>
                     <div class="app-details">
                        <p class="app-details-para">
                           Fintify is an integrated hyper- personal 
                           finance mobile application which is designed 
                           to give a single view of all your finances. 
                           We are a cross-border, multi-currency account aggregation platform
                           that makes tracking all global investments and money easy.
                        </p>
                     </div>
                  </div>
               </div>
            </div>
            <div data-aos="flip-left" class="row applications-details mt-3">
               <div class="col-12 col-xl-6">
                  <div class="phone-image ">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/super-selector-phone.webp')}}" alt="phone" class="phone-img">
                  </div>
               </div>
               <div class="col-12 col-xl-6">
                  <div class="work-details">
                     <div class="d-flex flex-column logo">
                        <div class="app-logo">
                           <img loading="lazy" src="{{url('/accets/new-landing/images/super-selector-logo.webp')}}" alt="Faasos" class="faasos">
                        </div>
                     </div>
                     <div class="apphead mt-3">
                        <h3 class="head-faasos">
                           Super Selector Kenya
                        </h3>
                     </div>
                     <div class="app-title">
                        <p class="app-title-para">
                           Online Betting
                        </p>
                     </div>
                     <div class="app-details">
                        <p class="app-details-para">
                           SSK is a Soccer betting application used in Kenya.
                           It is an upcoming application and hosts Contests for UEFA Champions League 
                           & English Premiere League.You can create upto 3 teams in each Contest Gamweek-wise
                           and bet on each player depending on their performance and expectations.
                        </p>
                     </div>
                  </div>
               </div>
            </div>
            <div data-aos="flip-left" class="row applications-details mt-3">
               <div class="col-12 col-xl-6">
                  <div class="phone-image ">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/pet-connect-phone.webp')}}" alt="phone" class="phone-img">
                  </div>
               </div>
               <div class="col-12 col-xl-6">
                  <div class="work-details">
                     <div class="d-flex flex-column logo">
                        <div class="app-logo">
                           <img loading="lazy" src="{{url('/accets/new-landing/images/pet-connect-logo.webp')}}" alt="Faasos" class="faasos">
                        </div>
                     </div>
                     <div class="apphead mt-3">
                        <h3 class="head-faasos">
                           PetKonnect
                        </h3>
                     </div>
                     <div class="app-title">
                        <p class="app-title-para">
                           Social Network
                        </p>
                     </div>
                     <div class="app-details">
                        <p class="app-details-para">
                           PetKonnect is a comprehensive online pet-services'
                           community for pets as well as stray animals.
                           Built on a philosophy of love for animals, PetKonnect champions 
                           equal rights and social inclusion for all animals.
                        </p>
                     </div>
                  </div>
               </div>
            </div>
            <div data-aos="flip-left" class="row applications-details mt-3">
               <div class="col-12 col-xl-6">
                  <div class="phone-image ">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/none-phone.webp')}}" alt="phone" class="phone-img">
                  </div>
               </div>
               <div class="col-12 col-xl-6">
                  <div class="work-details">
                     <div class="d-flex flex-column logo">
                        <div class="app-logo">
                           <img loading="lazy" src="{{url('/accets/new-landing/images/none.webp')}}" alt="Faasos" class="faasos">
                        </div>
                     </div>
                     <div class="apphead mt-3">
                        <h3 class="head-faasos">
                           Niine
                        </h3>
                     </div>
                     <div class="app-title">
                        <p class="app-title-para">
                           Health & Wellness
                        </p>
                     </div>
                     <div class="app-details">
                        <p class="app-details-para">
                           Niine period tracker is an app that helps
                           women track their period cycle on a monthly basis.
                           This app has a special feature of an open-forum which
                           allows a person to ask period related questions and get
                           live answers for it. The application also educates users on 
                           menstrual hygiene and related issues.
                        </p>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <section class="container section customers" id="client">
         <div class="container customers">
            <div class="row">
               <div data-aos="zoom-in-down" class="col-12">
                  <h1 class="heading text-center">
                     We Build Relationships
                  </h1>
               </div>
            </div>
            <div class="row relation-block">
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/indian-oil.webp')}}" alt="indian oil" class="customer-1-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/blenders.webp')}}" alt="indian oil" class="customer-2-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/jn.webp')}}" alt="indian oil" class="customer-3-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/lalco.webp')}}" alt="indian oil" class="customer-3-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/ml.webp')}}" alt="indian oil" class="customer-5-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/mum.webp')}}" alt="indian oil" class="customer-6-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/abbot.webp')}}" alt="indian oil" class="customer-7-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/ktm.webp')}}" alt="indian oil" class="customer-1-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/trujet.webp')}}" alt="indian oil" class="customer-2-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/dell.webp')}}" alt="indian oil" class="customer-3-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/bjp.webp')}}" alt="indian oil" class="customer-4-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/lodha.webp')}}" alt="indian oil" class="customer-5-image">
                  </div>
               </div>
            </div>
            <div class="row justify-content-center">
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/meyer.webp')}}" alt="indian oil" class="customer-6-image">
                  </div>
               </div>
               <div class="col-6 col-sm-4 col-lg-2">
                  <div data-aos="flip-down" class="customer-images">
                     <img loading="lazy" src="{{url('/accets/new-landing/images/lotus.webp')}}" alt="indian oil" class="customer-7-image">
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- Reviews -->
      <section data-aos="zoom-in" class="container section testimonial-section" id="review">
         <div class="container">
            <div class="text-center testimonials-para-wrapper">
               <h1 class="heading">Our Testimonials</h1>
            </div>
            <div class="owl-carousel-one owl-carousel owl-theme">
               <div class="item">
                  <p class="rev-stars">
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                  </p>
                  <span class="reviews-para">
                  In collaboration with Togglebytes, we streamlined our RPA environment with App interface that transitioned a number of new bots into production within the last eighteen months resulting in cost savings and improved efficiencies. This has helped us gain confidence in our RPA journey, resulting in buy-in and a healthy pipeline of opportunities</span><span class="dots">...</span><span class="moretext"> for further automation across the board.              
                  </span>
                  <i class="myBtnx">Read more</i>
                  <div class="pt-3  d-flex align-items-center">
                     <p class="first-letter-testimonials">
                        j
                        <!--First Letter of the testimonials-->
                     </p>
                     <p>
                        Jay A, <small> Bruhat- Singapore</small>
                     </p>
                  </div>
               </div>

               <div class="item">
                  <p class="rev-stars">
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                  </p>
                  <span class="reviews-para">
                  Togglebytes has been the Outsourced Platform Development partner on this journey for us. We have engaged deeply with Togglebytes team from the first meeting where I shared our vision for the platform and a basic working prototype. They took on the challenge and have helped us launch it on time and on budget. </span><span class="dots">...</span><span class="moretext"> I They have strong development capabilities and a highly flexible and adaptable approach. We foresee Togglebytes continuing to play a key role as we scale and enhance the platform to cater to growing needs in this space. I can categorically state that platform would not have been successful without Togglebytes' deep involvement throughout this journey.
                  </span>
                  <i class="myBtnx">Read more</i>
                  <div class="pt-3  d-flex align-items-center">
                     <p class="first-letter-testimonials">
                        j
                        <!--First Letter of the testimonials-->
                     </p>
                     <p>
                     John M., <small>Heritage Automotive- UK</small>
                     </p>
                  </div>
               </div>



               <div class="item">
                  <p class="rev-stars">
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                  </p>
                  <span class="reviews-para">
                  Choosing a digital partner for us was about more than capabilities — it’s about collaboration and business evolution. Whether our goal of building the world’s first AI-enabled App &amp; Software application or be it a transformation of our core business processes –  The team Togglebytes is always there to </span><span class="dots">...</span><span class="moretext">partner with us to help us gain— and maintain—competitive advantage with efficient, sustainable models and tailored made solutions at scale. Over the last 4 years, their commitment to quality solution delivery and proactive approach in problem-solving, hands-on talent, agility is a key strength that built trust, not just with me but with my business partners too.
                  </span>
                  <i class="myBtnx">Read more</i>
                  <div class="pt-3  d-flex align-items-center">
                     <p class="first-letter-testimonials">
                        k
                        <!--First Letter of the testimonials-->
                     </p>
                     <p>
                        Kristen Gerzin, <small>Pregakem - India</small>
                     </p>
                  </div>
               </div>
               <div class="item">
                  <p class="rev-stars">
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                  </p>
                  <span class="reviews-para">
                  My team at IOL searched around looking for Software & App development companies and found Togglebytes who within no time got us live with a Creative design for Website and subsequently for App as well. I really love the service they provide even after the Android and iOS Apps as well as Website is delivered.</span><span class="dots">...</span>
                  <span class="moretext"> Thank God I met such an amazing team that not only has great taste in Design but they can guide you through the process. I highly recommend their App development, Web design and Development and their AMC services to all.
                  </span>
                  <i class="myBtnx">Read more</i>
                  <div class="pt-3  d-flex align-items-center">
                     <p class="first-letter-testimonials">
                        A
                        <!--First Letter of the testimonials-->
                     </p>
                     <p>
                        Arundhati Roy, 
                        <small>Indian Oil - India</small>
                     </p>
                  </div>
               </div>

               <div class="item">
                  <p class="rev-stars">
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                  </p>
                  <span class="reviews-para">
                  Togglebytes One Technologies is an amazing company for Designing highly interactive websites. They have a well-qualified staff and professional team with a process-oriented approach. I like the creativity they bring on the table.
                  I'd highly recommend Togglebytes for their great website development skills.
                  </span>
                  <i class="myBtnx">Read more</i>
                  <div class="pt-3  d-flex align-items-center">
                     <p class="first-letter-testimonials">
                        S
                        <!--First Letter of the testimonials-->
                     </p>
                     <p>
                        Subhransu M, <small>ZeusNJove- India</small>
                     </p>
                  </div>
               </div>


               <div class="item">
                  <p class="rev-stars">
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                     <i class="fa fa-star">
                        <svg fill="#ff0000" height="15px" width="15px" class='fontawesomesvg' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512">
                           <!--! Font Awesome Free 6.2.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License) Copyright 2022 Fonticons, Inc. -->
                           <path d="M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"/>
                        </svg>
                     </i>
                  </p>
                  <span class="reviews-para">
                  Needed to develop an application for my Fintech company. Togglebytes not only created my application way before deadline but also help me improve the concept and the designs for the app. Moreover they also set up a perfect backend which allowed me to maintain/update my app from time to time. The company is</span><span class="dots">...</span><span class="moretext"> highly professional and excellent in communicating and understanding the client needs. One word to sum it all up "best". Looking forward to recommending to others as well as keeping in touch for future prospects.
                  </span>
                  <i class="myBtnx">Read more</i>
                  <div class="pt-3  d-flex align-items-center">
                     <p class="first-letter-testimonials">
                        P
                        <!--First Letter of the testimonials-->
                     </p>
                     <p>
                        Javed, <small>Fintify- UK</small>
                     </p>
                  </div>
               </div>
            </div>
         </div>
         </div>
      </section>
      <!-- Reach Us Out started  -->
      <section class=" section reach-us-out-section " id="contact">
         <div class="container reach-us-out">
         <div class="row justify-content-between align-items-center">
            <!-- left-side-row -->
            <div class="col-12 col-lg-5 col-lg-offset-1">
               <div data-aos="fade-right" class="reach-left-wrapper">
                  <h1 class="heading">
                     Reach Us now for a Quote
                  </h1>
                  <p class="reach-details">
                     We help you eliminate barriers between Ideas & Business Outcomes
                  </p>
               </div>
            </div>
            <!-- right-side-row -->
            <div data-aos="flip-left" class="col-12 col-lg-5 col-lg-offset-1">
               <div class="reach-input-group">
                  <div class="contact-form-reach">
                     <form class="mb-2 mx-auto" action="" data-toggle="modal" id="reachForm" method="POST" >
                         {{csrf_field()}}
                         <input type="hidden" name="url" id="token" value="{{URL::current()}}">
                        <div class="enquiry">
                           <p class="contact-enquiry">
                              Enquiry
                           </p>
                        </div>
                        <div class="name-input">
                           <input id="name-input" type="text" class="custom-input mb-3" name="name" placeholder="Full Name*" required>
                        </div>
                        <div class="phone-number mb-3">
                           <input id="mobile" name="phone" type="tel" class="custom-input mb-3" placeholder="8240-974-561" required>
                        </div>
                        <div class="mb-1">
                           <input  id="email-input" type="email" class="custom-input mb-3" name="email" placeholder="Email Id*" required>
                        </div>
                        <button class="enquire-now"  id="my-btn2" type="button" onclick="checkData('reachForm')">
                        Submit
                        </button>
                     </form>
                  </div>
               </div>
               <!-- Modal -->
               <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="false">
                  <div class="modal-dialog modal-dialog-centered">
                     <div class="modal-content">
                        <div class="modal-header">
                           <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body text-center">
                           <div class="thank-you-pop">
                              <img alt="svgImg" src="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHg9IjBweCIgeT0iMHB4Igp3aWR0aD0iNDgiIGhlaWdodD0iNDgiCnZpZXdCb3g9IjAgMCA0OCA0OCIKc3R5bGU9IiBmaWxsOiMwMDAwMDA7Ij48cGF0aCBmaWxsPSIjYzhlNmM5IiBkPSJNMzYsNDJIMTJjLTMuMzE0LDAtNi0yLjY4Ni02LTZWMTJjMC0zLjMxNCwyLjY4Ni02LDYtNmgyNGMzLjMxNCwwLDYsMi42ODYsNiw2djI0QzQyLDM5LjMxNCwzOS4zMTQsNDIsMzYsNDJ6Ij48L3BhdGg+PHBhdGggZmlsbD0iIzRjYWY1MCIgZD0iTTM0LjU4NSAxNC41ODZMMjEuMDE0IDI4LjE3MiAxNS40MTMgMjIuNTg0IDEyLjU4NyAyNS40MTYgMjEuMDE5IDMzLjgyOCAzNy40MTUgMTcuNDE0eiI+PC9wYXRoPjwvc3ZnPg=="/>
                              <h1>Thank You!</h1>
                              <p>Your submission is received and we will contact you soon</p>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- Togglebytes Links Content -->
      <section data-aos="zoom-in" class="container togglebytes-links">
         <div class="container">
            <div class="row">
               <div class="col-xl-4 col-md-6 col-12">
                  <div class="link-heading">
                     <h2 class="links-title">Quick Excerpts</h2>
                  </div>
                  <div class="list-group">
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">App Development Company in India</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">App Development in India</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Android App Development Company in India</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">iOS App Development Company in India</h1>
                     </a>
                     <a href="#" class="list-item android-link">
                     <h1 class="list-group-h1">Android App Developers in India</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">iOS App Developers in India</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Hybrid App Development</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">React Native App Development</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Flutter App Development Companies</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Mobile App Developers in India</h1>
                     </a>
                  </div>
               </div>
               <div class="col-xl-4 col-md-6 col-12">
                  <div class="link-heading">
                     <h2 class="links-title">Quick Excerpts</h2>
                  </div>
                  <div class="list-group">
                     
                     
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">eCommerce App Development</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Fantasy Game App Development</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Pharmacy App Development</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Grocery App Development</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Real Estate App Development</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Airline Ticket Booking App Development</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Used Car Marketplace App Development</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Automobile Dealer App Development</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">Enterprise App Development in India</h1>
                     </a>
                     <a href="#" class="list-item">
                     <h1 class="list-group-h1">eCommerce App Development in Mumbai</h1>
                     </a>
                  </div>
               </div>
               <div class="col-xl-4 col-md-6 col-12">
                  <div class="link-heading">
                     <h2 class="links-title">Our Presence</h2>
                  </div>
                  <div class="list-group">
                     <p class="list-item presence-para">
                        Togglebytes One Technologies is an App Development company with presence in more than 6 Countries
                     </p>
                     <a href="#" class="list-item">
                     Miami, Florida
                     </a>
                     <a href="#" class="list-item">
                     London, United Kingdom
                     </a>
                     <a href="#" class="list-item">
                     Nairobi, Kenya
                     </a>
                     <a href="#" class="list-item">
                     Dubai, UAE
                     </a>
                     <a href="#" class="list-item">
                     Sydney, Australia
                     </a>
                     <a href="#" class="list-item">
                     Mumbai, India
                     </a>   
                  </div>
               </div>
            </div>
            <div class="row">
               <div class="col-xl-4 col-md-6 col-12">
                  <div class="contact-us">
                     <a class="contact-link" href="tel:+919029560949">
                     Call Us: 
                     <span class="contact-us-number">
                     +91-9029-560-949
                     </span> 
                     </a>
                  </div>
               </div>
            </div>
         </div>
      </section>
      <!-- footer -->
      <footer>
         <div class="container footer mt-3">
            <div class="row justify-content-between">
               <div class=" col-md-6 col-12 text-center">
                  <div class="footer-left-content">
                     <p class="copyright-tags">Copyright © 2022 Togglebytes Technologies</p>
                  </div>
               </div>
               <div class=" col-md-6 col-12 text-center">
                  <div  class="footer-socialmedia">
                     <span>
                     <a href=" https://www.linkedin.com/company/togglebytes-technologies/"><img src="{{url('/accets/new-landing/images/linkedin.svg')}}" alt="linkedin"></a>
                     <a href=" https://www.facebook.com/togglebytes"><img src="{{url('/accets/new-landing/images/fb-logo.svg')}}" alt="facebook"></a>
                     <a href="https://www.instagram.com/togglebytes/"><img src="{{url('/accets/new-landing/images/insta.svg')}}" alt="instagram"></a>
                     <a href="https://www.youtube.com/@togglebytes"><img src="{{url('/accets/new-landing/images/youtube.svg')}}" alt="twitter"></a>
                     </span>
                  </div>
               </div>
            </div>
         </div>
      </footer>
      <div class="modal fade" id="ere_msg-form" data-keyboard="false" data-backdrop="static" role="dialog" aria-labelledby="exampleModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog modalerror" role="document">
          <div class="modal-content">
            <div class="modal-body erooe_msg_modal">
              <button type="button" class="close" data-dismiss="modal">X</button>
              <span id="err_msg" class="TradeGothicLTStd-BdCn20">Please fill all fields</span>
            </div>
          </div>
        </div>
      </div>
      <div class="modal fade" id="ere_msg-form1" data-keyboard="false" data-backdrop="static" role="dialog" aria-labelledby="exampleModalLabel" style="display: none;" aria-hidden="true">
        <div class="modal-dialog modalerror" role="document">
          <div class="modal-content">
            <div class="modal-body erooe_msg_modal">
              <button type="button" class="close" data-dismiss="modal">X</button>
              <span id="err_msg1" class="TradeGothicLTStd-BdCn20">Please fill all fields</span>
            </div>
          </div>
        </div>
      </div>
      <!-- css here due to render blocking-->
      <!-- Bootstrap js -->
      <!-- <script defer src="./assets/bootstrap/bootstrap.bundle.min.js"></script> -->
      <script src="{{url('/accets/new-landing/assets/jquery/jquery.min.js')}}"> </script>
      <!-- owl carousel js -->
      <script src="{{url('/accets/new-landing/assets/owlcarousel/dist/owl.carousel.min.js')}}"></script>
      <script src="{{url('/accets/new-landing/main-min.js')}}"></script>
      <!-- country code javascript -->
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/css/intlTelInput.css" integrity="sha512-gxWow8Mo6q6pLa1XH/CcH8JyiSDEtiwJV78E+D+QP0EVasFs8wKXq16G8CLD4CJ2SnonHr4Lm/yY2fSI2+cbmw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
      <script defer src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/utils.min.js" integrity="sha512-jEc69+XeOdfDwLui+HpPWl8/8+cxkHcwcznwbVGrmVlECJD+L1yN0PljgF2MPs6+1bTX+gNvo/9C3YJ7n4i9qw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
      <script defer src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/utils.js" integrity="sha512-XGZwM3U4PM6aH04G+9uL3qma2xu2feLpy5qX7WRlFu2Ti3tiRPoY9vuD9bz7wiTVJ139hdogEYBFZtevPPR1Yw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
      <script defer src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput-jquery.min.js" integrity="sha512-9WaaZVHSw7oRWH7igzXvUExj6lHGuw6GzMKW7Ix7E+ELt/V14dxz0Pfwfe6eZlWOF5R6yhrSSezaVR7dys6vMg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
      <script defer src="{{url('/accets/new-landing/build/js/intlTelInput-jquery.js')}}"></script>
      <script defer src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/js/intlTelInput.min.js" integrity="sha512-+gShyB8GWoOiXNwOlBaYXdLTiZt10Iy6xjACGadpqMs20aJOoh+PJt3bwUVA6Cefe7yF7vblX6QwyXZiVwTWGg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
      <script src="{{url('/accets/new-landing/build/js/intlTelInput.js')}}"></script>
      <script>
         var input = document.querySelector("#phone");
         window.intlTelInput(input, {
         // allowDropdown: false,
         // autoHideDialCode: false,
         // autoPlaceholder: "off",
         // dropdownContainer: document.body,
         // excludeCountries: ["us"],
         // formatOnDisplay: false,
         // geoIpLookup: function(callback) {
         //   $.get("http://ipinfo.io", function() {}, "jsonp").always(function(resp) {
         //     var countryCode = (resp && resp.country) ? resp.country : "";
         //     callback(countryCode);
         //   });
         // },
         // hiddenInput: "full_number",
         // initialCountry: "IN",
         // localizedCountries: { 'de': 'Deutschland' },
         // nationalMode: false,
         // onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
         // placeholderNumberType: "MOBILE",
         // preferredCountries: ['cn', 'jp'],
         // separateDialCode: true,
         utilsScript: "{{url('/accets/new-landing/intl-tel-input-17.0.18/build/js/utils.js')}}",
         });
         var input = document.querySelector("#mobile");
         window.intlTelInput(input, {
         // allowDropdown: false,
         // autoHideDialCode: false,
         // autoPlaceholder: "off",
         // dropdownContainer: document.body,
         // excludeCountries: ["us"],
         // formatOnDisplay: false,
         // geoIpLookup: function(callback) {
         //   $.get("http://ipinfo.io", function() {}, "jsonp").always(function(resp) {
         //     var countryCode = (resp && resp.country) ? resp.country : "";
         //     callback(countryCode);
         //   });
         // },
         // hiddenInput: "full_number",
         // initialCountry: "IN",
         // localizedCountries: { 'de': 'Deutschland' },
         // nationalMode: false,
         // onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
         // placeholderNumberType: "MOBILE",
         // preferredCountries: ['cn', 'jp'],
         // separateDialCode: true,
         utilsScript: "{{url('/accets/new-landing/intl-tel-input-17.0.18/build/js/utils.js')}}",
         });
      </script>
      <script>
         var loader = document.querySelector(".preloader");
         window.onload = function () {
             ready()
             setTimeout(function(){
                 loader.style.display = "none";
                 AOS.init({
                     duration: 1000,
                     once: true
                 });
             }, 1000);
         };
         $(function () {
           var $header = $(".preloader-text");
           var header = [
             "mobile apps",
             "software",
             "websites",
             "web apps",   
             "design",
             "ui/ux",
             "motion",
             "graphics",
           ];
           var position = -1;
         
           !(function loop() {
             position = (position + 1) % header.length;
             $header
               .html(header[position])
               .fadeIn(100)
               .delay(100)
               .fadeOut(100, loop);
           })();
         });
         
         $(document).ready(function(){
         $(".myBtnx").click(function(){
           $(this).prev().toggle();
           $(this).siblings('.dots').toggle();
           if($(this).text()=='Read more'){
         $(this).text('Read less');
           }
           else{
         $(this).text('Read more');
           }
         });
         // window.addEventListener("load", function(){
         //    setTimeout(() => {
         //                      $(".mobile-iframe").html('<iframe class="iframe-res" width="560" height="315" src="https://www.youtube.com/embed/ts8cznnGdGs?autoplay=1&controls=0&loop=1"  ></iframe>')
         //    },2000);
         // });
         $("#youtube-embed").click(function(){
              $("#youtube-embed").css("display", "none");
              "use strict";
              $(".mobile-iframe").html('<iframe class="iframe-res" width="560" height="315" src="https://www.youtube.com/embed/ts8cznnGdGs?autoplay=1&controls=0&loop=1"  ></iframe>')
            //   $(".iframe-res").css("display","block");
         })
         });
         function ready(){
            var target = document.getElementsByClassName('lazzy-iframe');
            for(var i = 0; i < target.length; i++){
               var src = target[i].getAttribute('data-src');
               target[i].setAttribute('src',src);
            }
         } 
         $(document).ready(function(){
          $(".navbar-toggler").click(function(){
            $(".navbar-collapse").toggleClass("show");
          });
          
        });
        
        // For Lead Form Submission
        function checkData(formId)
      {
        // alert('d');
        if($('#'+formId+' input[name="name"]').val()=='')
        {
          alert('Please Enter Name')
          return false;
        }

        if($('#'+formId+' input[name="phone"]').val()=='')
        {
          alert('Please enter mobile number!');
          
          return false;
        }

         if($('#'+formId+' .iti__active').attr('data-dial-code')=='')
        {
          alert('Please enter country!');
          return false;
        }

        if($('#'+formId+' input[name="email"]').val()=='')
        {
          alert('Please enter email!');
          return false;
        }
        var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
        var email = $('#'+formId+' input[name="email"]').val();
        if(reg.test(email) == false)
        {
          alert('Please provide a valid email!');
            return false;
        }

        var mobile = $($('#'+formId+' input[name="phone"]')).val();
        if(mobile.length < 10)
        {
          alert('Mobile should be 10 digits!');
            return false;   
        }
        
        var conversion_code= "<script>gtag('event', 'conversion', {'send_to': 'AW-748983915/zJJWCKrmmLgBEOuskuUC'})<\/script> <script> function gtag_report_conversion(url) {   var callback = function () {     if (typeof(url) != 'undefined') {       window.location = url;     }   };   gtag('event', 'conversion', {       'send_to': 'AW-748983915/zJJWCKrmmLgBEOuskuUC',       'event_callback': callback   });   return false; } <\/script>";
        var myform = document.getElementById(formId);
        var fd = new FormData(myform );
        var string=$('#'+formId+' .iti__selected-flag').attr('title');
        
              // console.log(string);
        fd.append('country_code',parseInt(string.replace(/\D/g, ""), 10));
        // fd.append('country_code',$('.iti__active').attr('data-dial-code'));
        $.ajax({
          type:'post',
          url:'{{url("/")}}/sendNewEnquiryMumbai',
          data:fd,
          dataType:'json',
          processData: false,
          contentType: false,
          success:function(res)
          {
            var msg='';
            // $('.loader').show();
            
              if(res==true){
                alert('Thank You for Contacting Us');
                window.location.href = "https://togglebytes.com/thank-you";
                  msg='Thank You for Contacting Us';
              }else{
                  alert('Something Went Wrong Please Try Again!');
                  msg='Something Went Wrong Please Try Again!';
              }
            
            setTimeout(function(){
                
                window.location.reload();
            },4000);
            return false;
          }
        });
      }
        
         
      </script>
      <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
   </body>
</html>