<?php
Route::get('/', function () { return redirect('/admin/dashboard'); });


// Authentication Routes...
$this->get('login', 'Auth\LoginController@showLoginForm')->name('auth.login');
$this->post('login', 'Auth\LoginController@login')->name('auth.login');
$this->post('logout', 'Auth\LoginController@logout')->name('auth.logout');

// Change Password Routes...
$this->get('change_password', 'Auth\ChangePasswordController@showChangePasswordForm')->name('auth.change_password');
$this->patch('change_password', 'Auth\ChangePasswordController@changePassword')->name('auth.change_password');

// Password Reset Routes...
$this->get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('auth.password.reset');
$this->post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('auth.password.reset');
$this->get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
$this->post('password/reset', 'Auth\ResetPasswordController@reset')->name('auth.password.reset');

Route::group(['middleware' => ['auth']], function () {

    Route::get('/home', 'HomeController@index');
    Route::get('/admin/home', 'HomeController@index');
    Route::get('/admin/dashboard', 'HomeController@index');
    Route::get('/admin/getCourse/{id}', 'admin\Can_educationController@getCourses');
    Route::get('/admin/getSpecialization/{id}', 'admin\Can_educationController@getSpecialization');
    Route::get('/admin/getLoginInfo/{table}/{id}', 'admin\ConsultantsController@getLoginInfo');
    Route::post('/admin/saveLoginInfo', 'admin\ConsultantsController@saveLoginInfo');
    Route::post('/admin/assignCandidates', 'admin\Cvs_assignController@postCv');
    Route::post('/admin/assignJobs', 'admin\Cvs_assignController@postJobs');
    Route::post('/admin/activationStatus','admin\JobsController@statusActivation');
    Route::get('admin/getStatusdata/{id}','admin\JobsController@getStatusInfo');
    
    Route::resource('/admin/permissions', 'Admin\PermissionsController');
    Route::post('permissions_mass_destroy', ['uses' => 'admin\PermissionsController@massDestroy', 'as' => 'permissions.mass_destroy']);
    Route::resource('roles', 'Admin\RolesController');
    Route::post('roles_mass_destroy', ['uses' => 'admin\RolesController@massDestroy', 'as' => 'roles.mass_destroy']);
    Route::resource('users', 'Admin\UsersController');
    Route::post('users_mass_destroy', ['uses' => 'admin\UsersController@massDestroy', 'as' => 'users.mass_destroy']);

   
// BO : Buyers
    Route::post("/admin/buyers/deleteAll", [ 'as'=>'admin.buyers.deleteAll','uses'=>'admin\BuyersController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/buyers", [ 'as'=>'admin.buyers.index','uses'=>'admin\BuyersController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/buyers/add", [ 'as'=>'admin.buyers.add','uses'=>'admin\BuyersController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/buyers/add", [ 'as'=>'admin.buyers.add','uses'=>'admin\BuyersController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/buyers/edit/{id}", [ 'as'=>'admin.buyers.edit','uses'=>'admin\BuyersController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/buyers/status/{field}/{id}", [ 'as'=>'admin.buyers.edit','uses'=>'admin\BuyersController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/buyers/export/{type}", [ 'as'=>'admin.buyers.edit','uses'=>'admin\BuyersController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/buyers/edit", [ 'as'=>'admin.buyers.edit','uses'=>'admin\BuyersController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/buyers/delete", [ 'as'=>'admin.buyers.delete','uses'=>'admin\BuyersController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/buyers/view/{id}", [ 'as'=>'admin.buyers.edit','uses'=>'admin\BuyersController@view','middleware' => ['permission:item-list']]);
    // EO : Buyers

   

    // BO : Crop_transactions
    Route::post("/admin/crop_transactions/deleteAll", [ 'as'=>'admin.crop_transactions.deleteAll','uses'=>'admin\Crop_transactionsController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/crop_transactions", [ 'as'=>'admin.crop_transactions.index','uses'=>'admin\Crop_transactionsController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/crop_transactions/add", [ 'as'=>'admin.crop_transactions.add','uses'=>'admin\Crop_transactionsController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/crop_transactions/add", [ 'as'=>'admin.crop_transactions.add','uses'=>'admin\Crop_transactionsController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/crop_transactions/edit/{id}", [ 'as'=>'admin.crop_transactions.edit','uses'=>'admin\Crop_transactionsController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/crop_transactions/status/{field}/{id}", [ 'as'=>'admin.crop_transactions.edit','uses'=>'admin\Crop_transactionsController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/crop_transactions/export/{type}", [ 'as'=>'admin.crop_transactions.edit','uses'=>'admin\Crop_transactionsController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/crop_transactions/edit", [ 'as'=>'admin.crop_transactions.edit','uses'=>'admin\Crop_transactionsController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/crop_transactions/delete", [ 'as'=>'admin.crop_transactions.delete','uses'=>'admin\Crop_transactionsController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/crop_transactions/view/{id}", [ 'as'=>'admin.crop_transactions.edit','uses'=>'admin\Crop_transactionsController@view','middleware' => ['permission:item-list']]);
    // EO : Crop_transactions

   

    // BO : Crops
    Route::post("/admin/crops/deleteAll", [ 'as'=>'admin.crops.deleteAll','uses'=>'admin\CropsController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/crops", [ 'as'=>'admin.crops.index','uses'=>'admin\CropsController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/crops/add", [ 'as'=>'admin.crops.add','uses'=>'admin\CropsController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/crops/add", [ 'as'=>'admin.crops.add','uses'=>'admin\CropsController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/crops/edit/{id}", [ 'as'=>'admin.crops.edit','uses'=>'admin\CropsController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/crops/status/{field}/{id}", [ 'as'=>'admin.crops.edit','uses'=>'admin\CropsController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/crops/export/{type}", [ 'as'=>'admin.crops.edit','uses'=>'admin\CropsController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/crops/edit", [ 'as'=>'admin.crops.edit','uses'=>'admin\CropsController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/crops/delete", [ 'as'=>'admin.crops.delete','uses'=>'admin\CropsController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/crops/view/{id}", [ 'as'=>'admin.crops.edit','uses'=>'admin\CropsController@view','middleware' => ['permission:item-list']]);
    // EO : Crops

   

    // BO : Farmers
    Route::get("/admin/farmers/export/{type}", [ 'as'=>'admin.farmers.edit','uses'=>'admin\FarmersController@postEdit','middleware' => ['permission:item-list']]);

   Route::get("/admin/farmers/view/{id}", [ 'as'=>'admin.farmers.view','uses'=>'admin\FarmersController@view','middleware' => ['permission:item-list']]);

    Route::post("/admin/farmers/deleteAll", [ 'as'=>'admin.farmers.deleteAll','uses'=>'admin\FarmersController@deleteAll','middleware' => ['permission:item-delete']]);

    Route::get("/admin/farmers", [ 'as'=>'admin.farmers.index','uses'=>'admin\FarmersController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);

    Route::get("/admin/farmers/{field}/{id}/", [ 'as'=>'admin.farmers.index','uses'=>'admin\FarmersController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);

    Route::post("/admin/farmers/{field}/{id}/", [ 'as'=>'admin.farmers.index','uses'=>'admin\FarmersController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);

    Route::get("/admin/farmers/add/{field}/{id}", [ 'as'=>'admin.farmers.add','uses'=>'admin\FarmersController@getAdd','middleware' => ['permission:item-create']]);

    Route::get("/admin/farmers/add", [ 'as'=>'admin.farmers.add','uses'=>'admin\FarmersController@getAdd','middleware' => ['permission:item-create']]);

    Route::post("/admin/farmers/add/{field}/{id}", [ 'as'=>'admin.farmers.add','uses'=>'admin\FarmersController@postAdd','middleware' => ['permission:item-create']]);

    Route::post("/admin/farmers/add", [ 'as'=>'admin.farmers.add','uses'=>'admin\FarmersController@postAdd','middleware' => ['permission:item-create']]);

    Route::get("/admin/farmers/edit/{id}", [ 'as'=>'admin.farmers.edit','uses'=>'admin\FarmersController@getEdit','middleware' => ['permission:item-edit']]);

    Route::get("/admin/farmers/edit/{edit_id}/{field}/{id}", [ 'as'=>'admin.farmers.edit','uses'=>'admin\FarmersController@getEdit','middleware' => ['permission:item-edit']]);

    Route::get("/admin/farmers/status/{field}/{id}", [ 'as'=>'admin.farmers.edit','uses'=>'admin\FarmersController@status','middleware' => ['permission:item-edit']]);

    Route::post("/admin/farmers/edit", [ 'as'=>'admin.farmers.edit','uses'=>'admin\FarmersController@postEdit','middleware' => ['permission:item-edit']]);

    Route::post("/admin/farmers/delete", [ 'as'=>'admin.farmers.delete','uses'=>'admin\FarmersController@delete','middleware' => ['permission:item-delete']]);

    Route::post("/admin/farmers/delete/{field}/{id}", [ 'as'=>'admin.farmers.delete','uses'=>'admin\FarmersController@delete','middleware' => ['permission:item-delete']]);
    // EO : Farmers

   

    // BO : Marqua
    Route::post("/admin/marqua/deleteAll", [ 'as'=>'admin.marqua.deleteAll','uses'=>'admin\MarquaController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/marqua", [ 'as'=>'admin.marqua.index','uses'=>'admin\MarquaController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/marqua/add", [ 'as'=>'admin.marqua.add','uses'=>'admin\MarquaController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/marqua/add", [ 'as'=>'admin.marqua.add','uses'=>'admin\MarquaController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/marqua/edit/{id}", [ 'as'=>'admin.marqua.edit','uses'=>'admin\MarquaController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/marqua/status/{field}/{id}", [ 'as'=>'admin.marqua.edit','uses'=>'admin\MarquaController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/marqua/export/{type}", [ 'as'=>'admin.marqua.edit','uses'=>'admin\MarquaController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/marqua/edit", [ 'as'=>'admin.marqua.edit','uses'=>'admin\MarquaController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/marqua/delete", [ 'as'=>'admin.marqua.delete','uses'=>'admin\MarquaController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/marqua/view/{id}", [ 'as'=>'admin.marqua.edit','uses'=>'admin\MarquaController@view','middleware' => ['permission:item-list']]);
    // EO : Marqua

   

    // BO : Purchase
    Route::post("/admin/purchase/deleteAll", [ 'as'=>'admin.purchase.deleteAll','uses'=>'admin\PurchaseController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/purchase", [ 'as'=>'admin.purchase.index','uses'=>'admin\PurchaseController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/purchase/add", [ 'as'=>'admin.purchase.add','uses'=>'admin\PurchaseController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/purchase/add", [ 'as'=>'admin.purchase.add','uses'=>'admin\PurchaseController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/purchase/edit/{id}", [ 'as'=>'admin.purchase.edit','uses'=>'admin\PurchaseController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/purchase/status/{field}/{id}", [ 'as'=>'admin.purchase.edit','uses'=>'admin\PurchaseController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/purchase/export/{type}", [ 'as'=>'admin.purchase.edit','uses'=>'admin\PurchaseController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/purchase/edit", [ 'as'=>'admin.purchase.edit','uses'=>'admin\PurchaseController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/purchase/delete", [ 'as'=>'admin.purchase.delete','uses'=>'admin\PurchaseController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/purchase/view/{id}", [ 'as'=>'admin.purchase.edit','uses'=>'admin\PurchaseController@view','middleware' => ['permission:item-list']]);
    // EO : Purchase

   

    // BO : Sells
    Route::post("/admin/sells/deleteAll", [ 'as'=>'admin.sells.deleteAll','uses'=>'admin\SellsController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/sells", [ 'as'=>'admin.sells.index','uses'=>'admin\SellsController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/sells/add", [ 'as'=>'admin.sells.add','uses'=>'admin\SellsController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/sells/add", [ 'as'=>'admin.sells.add','uses'=>'admin\SellsController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/sells/edit/{id}", [ 'as'=>'admin.sells.edit','uses'=>'admin\SellsController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/sells/status/{field}/{id}", [ 'as'=>'admin.sells.edit','uses'=>'admin\SellsController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/sells/export/{type}", [ 'as'=>'admin.sells.edit','uses'=>'admin\SellsController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/sells/edit", [ 'as'=>'admin.sells.edit','uses'=>'admin\SellsController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/sells/delete", [ 'as'=>'admin.sells.delete','uses'=>'admin\SellsController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/sells/view/{id}", [ 'as'=>'admin.sells.edit','uses'=>'admin\SellsController@view','middleware' => ['permission:item-list']]);
    // EO : Sells

   

    // BO : Subscription_packages
    Route::post("/admin/subscription_packages/deleteAll", [ 'as'=>'admin.subscription_packages.deleteAll','uses'=>'admin\Subscription_packagesController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/subscription_packages", [ 'as'=>'admin.subscription_packages.index','uses'=>'admin\Subscription_packagesController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/subscription_packages/add", [ 'as'=>'admin.subscription_packages.add','uses'=>'admin\Subscription_packagesController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/subscription_packages/add", [ 'as'=>'admin.subscription_packages.add','uses'=>'admin\Subscription_packagesController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/subscription_packages/edit/{id}", [ 'as'=>'admin.subscription_packages.edit','uses'=>'admin\Subscription_packagesController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/subscription_packages/status/{field}/{id}", [ 'as'=>'admin.subscription_packages.edit','uses'=>'admin\Subscription_packagesController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/subscription_packages/export/{type}", [ 'as'=>'admin.subscription_packages.edit','uses'=>'admin\Subscription_packagesController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/subscription_packages/edit", [ 'as'=>'admin.subscription_packages.edit','uses'=>'admin\Subscription_packagesController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/subscription_packages/delete", [ 'as'=>'admin.subscription_packages.delete','uses'=>'admin\Subscription_packagesController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/subscription_packages/view/{id}", [ 'as'=>'admin.subscription_packages.edit','uses'=>'admin\Subscription_packagesController@view','middleware' => ['permission:item-list']]);
    // EO : Subscription_packages

   

    // BO : Trader_company
    Route::post("/admin/trader_company/deleteAll", [ 'as'=>'admin.trader_company.deleteAll','uses'=>'admin\Trader_companyController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/trader_company", [ 'as'=>'admin.trader_company.index','uses'=>'admin\Trader_companyController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/trader_company/add", [ 'as'=>'admin.trader_company.add','uses'=>'admin\Trader_companyController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/trader_company/add", [ 'as'=>'admin.trader_company.add','uses'=>'admin\Trader_companyController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/trader_company/edit/{id}", [ 'as'=>'admin.trader_company.edit','uses'=>'admin\Trader_companyController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/trader_company/status/{field}/{id}", [ 'as'=>'admin.trader_company.edit','uses'=>'admin\Trader_companyController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/trader_company/export/{type}", [ 'as'=>'admin.trader_company.edit','uses'=>'admin\Trader_companyController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/trader_company/edit", [ 'as'=>'admin.trader_company.edit','uses'=>'admin\Trader_companyController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/trader_company/delete", [ 'as'=>'admin.trader_company.delete','uses'=>'admin\Trader_companyController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/trader_company/view/{id}", [ 'as'=>'admin.trader_company.edit','uses'=>'admin\Trader_companyController@view','middleware' => ['permission:item-list']]);
    // EO : Trader_company

   

    // BO : Traders
    Route::get("/admin/traders/export/{type}", [ 'as'=>'admin.traders.edit','uses'=>'admin\TradersController@postEdit','middleware' => ['permission:item-list']]);

   Route::get("/admin/traders/view/{id}", [ 'as'=>'admin.traders.view','uses'=>'admin\TradersController@view','middleware' => ['permission:item-list']]);

    Route::post("/admin/traders/deleteAll", [ 'as'=>'admin.traders.deleteAll','uses'=>'admin\TradersController@deleteAll','middleware' => ['permission:item-delete']]);

    Route::get("/admin/traders", [ 'as'=>'admin.traders.index','uses'=>'admin\TradersController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);

    Route::get("/admin/traders/{field}/{id}/", [ 'as'=>'admin.traders.index','uses'=>'admin\TradersController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);

    Route::post("/admin/traders/{field}/{id}/", [ 'as'=>'admin.traders.index','uses'=>'admin\TradersController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);

    Route::get("/admin/traders/add/{field}/{id}", [ 'as'=>'admin.traders.add','uses'=>'admin\TradersController@getAdd','middleware' => ['permission:item-create']]);

    Route::get("/admin/traders/add", [ 'as'=>'admin.traders.add','uses'=>'admin\TradersController@getAdd','middleware' => ['permission:item-create']]);

    Route::post("/admin/traders/add/{field}/{id}", [ 'as'=>'admin.traders.add','uses'=>'admin\TradersController@postAdd','middleware' => ['permission:item-create']]);

    Route::post("/admin/traders/add", [ 'as'=>'admin.traders.add','uses'=>'admin\TradersController@postAdd','middleware' => ['permission:item-create']]);

    Route::get("/admin/traders/edit/{id}", [ 'as'=>'admin.traders.edit','uses'=>'admin\TradersController@getEdit','middleware' => ['permission:item-edit']]);

    Route::get("/admin/traders/edit/{edit_id}/{field}/{id}", [ 'as'=>'admin.traders.edit','uses'=>'admin\TradersController@getEdit','middleware' => ['permission:item-edit']]);

    Route::get("/admin/traders/status/{field}/{id}", [ 'as'=>'admin.traders.edit','uses'=>'admin\TradersController@status','middleware' => ['permission:item-edit']]);

    Route::post("/admin/traders/edit", [ 'as'=>'admin.traders.edit','uses'=>'admin\TradersController@postEdit','middleware' => ['permission:item-edit']]);

    Route::post("/admin/traders/delete", [ 'as'=>'admin.traders.delete','uses'=>'admin\TradersController@delete','middleware' => ['permission:item-delete']]);

    Route::post("/admin/traders/delete/{field}/{id}", [ 'as'=>'admin.traders.delete','uses'=>'admin\TradersController@delete','middleware' => ['permission:item-delete']]);
    // EO : Traders

   

    // BO : Transactions
    Route::post("/admin/transactions/deleteAll", [ 'as'=>'admin.transactions.deleteAll','uses'=>'admin\TransactionsController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/transactions", [ 'as'=>'admin.transactions.index','uses'=>'admin\TransactionsController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/transactions/add", [ 'as'=>'admin.transactions.add','uses'=>'admin\TransactionsController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/transactions/add", [ 'as'=>'admin.transactions.add','uses'=>'admin\TransactionsController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/transactions/edit/{id}", [ 'as'=>'admin.transactions.edit','uses'=>'admin\TransactionsController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/transactions/status/{field}/{id}", [ 'as'=>'admin.transactions.edit','uses'=>'admin\TransactionsController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/transactions/export/{type}", [ 'as'=>'admin.transactions.edit','uses'=>'admin\TransactionsController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/transactions/edit", [ 'as'=>'admin.transactions.edit','uses'=>'admin\TransactionsController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/transactions/delete", [ 'as'=>'admin.transactions.delete','uses'=>'admin\TransactionsController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/transactions/view/{id}", [ 'as'=>'admin.transactions.edit','uses'=>'admin\TransactionsController@view','middleware' => ['permission:item-list']]);
    // EO : Transactions

   

    //BO :permissions
     Route::post("/admin/permissions/mass_destroy", [ 'as'=>'admin.permissions.deleteAll','uses'=>'admin\PermissionsController@massDestroy','middleware' => ['permission:item-delete']]);

    Route::get("/admin/permissions", [ 'as'=>'admin.permissions.index','uses'=>'admin\PermissionsController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);

    Route::get("/admin/permissions/create", [ 'as'=>'admin.permissions.create','uses'=>'admin\PermissionsController@create','middleware' => ['permission:item-create']]);

    Route::post("/admin/permissions/store", [ 'as'=>'admin.permissions.store','uses'=>'admin\PermissionsController@store','middleware' => ['permission:item-create']]);

    Route::get("/admin/permissions/edit/{id}", [ 'as'=>'admin.permissions.edit','uses'=>'admin\PermissionsController@edit','middleware' => ['permission:item-edit']]);

    Route::post("/admin/permissions/update/{id}", [ 'as'=>'admin.permissions.update','uses'=>'admin\PermissionsController@update','middleware' => ['permission:item-edit']]);

    Route::delete("/admin/permissions/destroy/{id}", [ 'as'=>'admin.permissions.delete','uses'=>'admin\PermissionsController@destroy','middleware' => ['permission:item-delete']]);
// EO:permissions

  //BO :users

     Route::post("/admin/users/mass_destroy", [ 'as'=>'admin.users.deleteAll','uses'=>'admin\UsersController@massDestroy','middleware' => ['permission:item-delete']]);

    Route::get("/admin/users", [ 'as'=>'admin.users.index','uses'=>'admin\UsersController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);

    Route::get("/admin/users/create", [ 'as'=>'admin.users.create','uses'=>'admin\UsersController@create','middleware' => ['permission:item-create']]);

    Route::post("/admin/users/store", [ 'as'=>'admin.users.store','uses'=>'admin\UsersController@store','middleware' => ['permission:item-create']]);

    Route::get("/admin/users/edit/{id}", [ 'as'=>'admin.users.edit','uses'=>'admin\UsersController@edit','middleware' => ['permission:item-edit']]);

    Route::post("/admin/users/update/{id}", [ 'as'=>'admin.users.update','uses'=>'admin\UsersController@update','middleware' => ['permission:item-edit']]);
    Route::delete("/admin/users/destroy/{id}", [ 'as'=>'admin.users.delete','uses'=>'admin\UsersController@destroy','middleware' => ['permission:item-delete']]);

// EO:users

//BO :roles
    Route::post("/admin/roles/mass_destroy", [ 'as'=>'admin.roles.deleteAll','uses'=>'admin\RolesController@massDestroy','middleware' => ['permission:item-delete']]);

    Route::get("/admin/roles", [ 'as'=>'admin.roles.index','uses'=>'admin\RolesController@index','middleware' => ['permission:users_master|item-list|item-create|item-edit|item-delete']]);

    Route::get("/admin/roles/create", [ 'as'=>'admin.roles.create','uses'=>'admin\RolesController@create','middleware' => ['permission:item-create']]);

    Route::post("/admin/roles/store", [ 'as'=>'admin.roles.store','uses'=>'admin\RolesController@store','middleware' => ['permission:item-create']]);

    Route::get("/admin/roles/edit/{id}", [ 'as'=>'admin.roles.edit','uses'=>'admin\RolesController@edit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/roles/update/{id}", [ 'as'=>'admin.roles.update','uses'=>'admin\RolesController@update','middleware' => ['permission:item-edit']]);
    Route::delete("/admin/roles/destroy/{id}", [ 'as'=>'admin.roles.delete','uses'=>'admin\RolesController@destroy','middleware' => ['permission:item-delete']]);
    Route::get('/admin/roles/{id}',['as'=>'admin.roles.show','uses'=>'admin\RolesController@show']);
// EO:roles

});
