<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Traders extends Model
{
    protected $table = 'traders';
    protected $primaryKey = 'tl_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getTraders($id){
      $data =  Traders::where('tl_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getTradersView($id){
      $traders = Traders::select(array('traders.*'));
      $traders->where('traders.tl_id', $id);
      
      return $traders->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $select_field, $where_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("tl_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $traders = $this->getTraders($id);
      if($traders!=null){
        
                    if($field=="status"){
                        $status = $traders->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $traders->status=$status;
                        $traders->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $traders = $this->getTraders($id);
      if($traders!=null){
        $img = public_path().'/uploads/'.$traders->featured_img;
            if($traders->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $traders->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getTradersData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $traders = Traders::select(array('traders.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $traders->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $traders->orderBy($sortBy, $order);
        } else{
          $traders->orderBy('traders.tl_id', 'desc');
        }        

        return $traders->paginate($per_page);
    }

    public function getTradersExport($searchBy, $searchValue, $sortBy, $order){
      $traders = Traders::select(array('traders.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $traders->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $traders->orderBy($sortBy, $order);
        } else{
          $traders->orderBy('traders.tl_id', 'desc');
        }
        return $traders->get();
    }

    public function updateTraders($request){
      $id = $request->input('tl_id');
      $traders = Traders::getTraders($id);
      if($traders!=null){

          $traders->name = $request->input('name')!="" ? $request->input('name') : "";
          $traders->email = $request->input('email')!="" ? $request->input('email') : "";
          $traders->mobile = $request->input('mobile')!="" ? $request->input('mobile') : "";
          // $traders->password = $request->input('password')!="" ? $request->input('password') : "";
          $traders->permissions = $request->input('permissions')!="" ? implode(',', $request->input('permissions')) : "";
          $traders->status = $request->input('status')!="" ? $request->input('status') : "";

          $traders->save();
          return true;
      } else{
        return false;
      }
    }

    public function addTraders($request){
      $traders = new Traders;

        $traders->name = $request->input('name')!="" ? $request->input('name') : "";
        $traders->email = $request->input('email')!="" ? $request->input('email') : "";
        $traders->mobile = $request->input('mobile')!="" ? $request->input('mobile') : "";
        // $traders->password = $request->input('password')!="" ? $request->input('password') : "";
        $traders->permissions = $request->input('permissions')!="" ? implode(',', $request->input('permissions')) : "";
        $traders->status = $request->input('status')!="" ? $request->input('status') : "";

        $traders->save();
        return true;
    }
}
