<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Subscription_packages extends Model
{
    protected $table = 'subscription_packages';
    protected $primaryKey = 'sub_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getSubscription_packages($id){
      $data =  Subscription_packages::where('sub_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getSubscription_packagesView($id){
      $subscription_packages = Subscription_packages::select(array('subscription_packages.*'));
      $subscription_packages->where('subscription_packages.sub_id', $id);
      
      return $subscription_packages->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("sub_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $subscription_packages = $this->getSubscription_packages($id);
      if($subscription_packages != null){
        
                    if($field=="status"){
                        $status = $subscription_packages->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $subscription_packages->status=$status;
                        $subscription_packages->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $subscription_packages = $this->getSubscription_packages($id);
      if($subscription_packages !=null){
        $img = public_path().'/uploads/'.$subscription_packages->featured_img;
            if($subscription_packages->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $subscription_packages->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getSubscription_packagesData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $subscription_packages = Subscription_packages::select(array('subscription_packages.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $subscription_packages->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $subscription_packages->orderBy($sortBy, $order);
        } else{
          $subscription_packages->orderBy('subscription_packages.sub_id', 'desc');
        }        

        return $subscription_packages->paginate($per_page);
    }

    public function getSubscription_packagesExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $subscription_packages = Subscription_packages::select(array('subscription_packages.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $subscription_packages->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $subscription_packages->orderBy($sortBy, $order);
        } else{
          $subscription_packages->orderBy('subscription_packages.sub_id', 'desc');
        }
        return $subscription_packages->get();
    }

    public function updateSubscription_packages($request){
      $id = $request->input('sub_id');
      $subscription_packages = Subscription_packages::getSubscription_packages($id);
      if($subscription_packages !=null){

          $subscription_packages->name = $request->input('name')!="" ? $request->input('name') : "";
	$subscription_packages->description = $request->input('description')!="" ? $request->input('description') : "";
	$subscription_packages->no_of_logins = $request->input('no_of_logins')!="" ? $request->input('no_of_logins') : "";
	$subscription_packages->cost = $request->input('cost')!="" ? $request->input('cost') : "";
	$subscription_packages->tax = $request->input('tax')!="" ? $request->input('tax') : "";
	$subscription_packages->status = $request->input('status')!="" ? $request->input('status') : "";

          $subscription_packages->save();
          return true;
      } else{
        return false;
      }
    }

    public function addSubscription_packages($request){
      $subscription_packages = new Subscription_packages;

        $subscription_packages->name = $request->input('name')!="" ? $request->input('name') : "";
	$subscription_packages->description = $request->input('description')!="" ? $request->input('description') : "";
	$subscription_packages->no_of_logins = $request->input('no_of_logins')!="" ? $request->input('no_of_logins') : "";
	$subscription_packages->cost = $request->input('cost')!="" ? $request->input('cost') : "";
	$subscription_packages->tax = $request->input('tax')!="" ? $request->input('tax') : "";
	$subscription_packages->status = $request->input('status')!="" ? $request->input('status') : "";

        $subscription_packages->save();
        return $subscription_packages->sub_id;
    }
}
