<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Sells extends Model
{
    protected $table = 'sells';
    protected $primaryKey = 'sell_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getSells($id){
      $data =  Sells::where('sell_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getSellsView($id){
      $sells = Sells::select(array('sells.*' , 'trader_company.tc_id' , 'traders.name' , 'buyers.name'));
      $sells->where('sells.sell_id', $id);
      $sells->leftJoin('trader_company', 'sells.tc_id', '=','trader_company.tc_id');$sells->leftJoin('traders', 'sells.trader', '=','traders.tl_id');$sells->leftJoin('buyers', 'sells.buyer', '=','buyers.b_id');
      return $sells->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("sell_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $sells = $this->getSells($id);
      if($sells != null){
        
                    if($field=="status"){
                        $status = $sells->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $sells->status=$status;
                        $sells->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $sells = $this->getSells($id);
      if($sells !=null){
        $img = public_path().'/uploads/'.$sells->featured_img;
            if($sells->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $sells->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getSellsData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $sells = Sells::select(array('sells.*' , 'trader_company.tc_id' , 'traders.name' , 'buyers.name'));
      
      //join
        $sells->leftJoin('trader_company', 'sells.tc_id', '=','trader_company.tc_id');$sells->leftJoin('traders', 'sells.trader', '=','traders.tl_id');$sells->leftJoin('buyers', 'sells.buyer', '=','buyers.b_id');

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $sells->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $sells->orderBy($sortBy, $order);
        } else{
          $sells->orderBy('sells.sell_id', 'desc');
        }        

        return $sells->paginate($per_page);
    }

    public function getSellsExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $sells = Sells::select(array('sells.*' , 'trader_company.tc_id' , 'traders.name' , 'buyers.name'));

      //join
        $sells->leftJoin('trader_company', 'sells.tc_id', '=','trader_company.tc_id');$sells->leftJoin('traders', 'sells.trader', '=','traders.tl_id');$sells->leftJoin('buyers', 'sells.buyer', '=','buyers.b_id');

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $sells->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $sells->orderBy($sortBy, $order);
        } else{
          $sells->orderBy('sells.sell_id', 'desc');
        }
        return $sells->get();
    }

    public function updateSells($request){
      $id = $request->input('sell_id');
      $sells = Sells::getSells($id);
      if($sells !=null){

          $sells->tc_id = $request->input('tc_id')!="" ? $request->input('tc_id') : "";
	$sells->trader = $request->input('trader')!="" ? $request->input('trader') : "";
	$sells->buyer = $request->input('buyer')!="" ? $request->input('buyer') : "";
	$sells->transporter_name = $request->input('transporter_name')!="" ? $request->input('transporter_name') : "";
	$sells->truck_no = $request->input('truck_no')!="" ? $request->input('truck_no') : "";
	$sells->status = $request->input('status')!="" ? $request->input('status') : "";

          $sells->save();
          return true;
      } else{
        return false;
      }
    }

    public function addSells($request){
      $sells = new Sells;

        $sells->tc_id = $request->input('tc_id')!="" ? $request->input('tc_id') : "";
	$sells->trader = $request->input('trader')!="" ? $request->input('trader') : "";
	$sells->buyer = $request->input('buyer')!="" ? $request->input('buyer') : "";
	$sells->transporter_name = $request->input('transporter_name')!="" ? $request->input('transporter_name') : "";
	$sells->truck_no = $request->input('truck_no')!="" ? $request->input('truck_no') : "";
	$sells->status = $request->input('status')!="" ? $request->input('status') : "";

        $sells->save();
        return $sells->sell_id;
    }
}
