<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Purchase extends Model
{
    protected $table = 'purchase';
    protected $primaryKey = 'p_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getPurchase($id){
      $data =  Purchase::where('p_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getPurchaseView($id){
      $purchase = Purchase::select(array('purchase.*' , 'trader_company.company_name' , 'traders.name'));
      $purchase->where('purchase.p_id', $id);
      $purchase->leftJoin('trader_company', 'purchase.tc_id', '=','trader_company.tc_id');$purchase->leftJoin('traders', 'purchase.trader', '=','traders.tl_id');
      return $purchase->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("p_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $purchase = $this->getPurchase($id);
      if($purchase != null){
        
                    if($field=="status"){
                        $status = $purchase->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $purchase->status=$status;
                        $purchase->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $purchase = $this->getPurchase($id);
      if($purchase !=null){
        $img = public_path().'/uploads/'.$purchase->featured_img;
            if($purchase->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $purchase->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getPurchaseData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $purchase = Purchase::select(array('purchase.*' , 'trader_company.company_name' , 'traders.name'));
      
      //join
        $purchase->leftJoin('trader_company', 'purchase.tc_id', '=','trader_company.tc_id');$purchase->leftJoin('traders', 'purchase.trader', '=','traders.tl_id');

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $purchase->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $purchase->orderBy($sortBy, $order);
        } else{
          $purchase->orderBy('purchase.p_id', 'desc');
        }        

        return $purchase->paginate($per_page);
    }

    public function getPurchaseExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $purchase = Purchase::select(array('purchase.*' , 'trader_company.company_name' , 'traders.name'));

      //join
        $purchase->leftJoin('trader_company', 'purchase.tc_id', '=','trader_company.tc_id');$purchase->leftJoin('traders', 'purchase.trader', '=','traders.tl_id');

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $purchase->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $purchase->orderBy($sortBy, $order);
        } else{
          $purchase->orderBy('purchase.p_id', 'desc');
        }
        return $purchase->get();
    }

    public function updatePurchase($request){
      $id = $request->input('p_id');
      $purchase = Purchase::getPurchase($id);
      if($purchase !=null){

          $purchase->patti_no = $request->input('patti_no')!="" ? $request->input('patti_no') : "";
	$purchase->tc_id = $request->input('tc_id')!="" ? $request->input('tc_id') : "";
	$purchase->trader = $request->input('trader')!="" ? $request->input('trader') : "";
	$purchase->farmer = $request->input('farmer')!="" ? $request->input('farmer') : "";
	$purchase->transporter_name = $request->input('transporter_name')!="" ? $request->input('transporter_name') : "";
	$purchase->truck_no = $request->input('truck_no')!="" ? $request->input('truck_no') : "";
	$purchase->freight_charge = $request->input('freight_charge')!="" ? $request->input('freight_charge') : "";
	$purchase->status = $request->input('status')!="" ? $request->input('status') : "";

          $purchase->save();
          return true;
      } else{
        return false;
      }
    }

    public function addPurchase($request){
      $purchase = new Purchase;

        $purchase->patti_no = $request->input('patti_no')!="" ? $request->input('patti_no') : "";
	$purchase->tc_id = $request->input('tc_id')!="" ? $request->input('tc_id') : "";
	$purchase->trader = $request->input('trader')!="" ? $request->input('trader') : "";
	$purchase->farmer = $request->input('farmer')!="" ? $request->input('farmer') : "";
	$purchase->transporter_name = $request->input('transporter_name')!="" ? $request->input('transporter_name') : "";
	$purchase->truck_no = $request->input('truck_no')!="" ? $request->input('truck_no') : "";
	$purchase->freight_charge = $request->input('freight_charge')!="" ? $request->input('freight_charge') : "";
	$purchase->status = $request->input('status')!="" ? $request->input('status') : "";

        $purchase->save();
        return $purchase->p_id;
    }
}
