<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Crops extends Model
{
    protected $table = 'crops';
    protected $primaryKey = 'crp_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getCrops($id){
      $data =  Crops::where('crp_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getCropsView($id){
      $crops = Crops::select(array('crops.*'));
      $crops->where('crops.crp_id', $id);
      
      return $crops->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("crp_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $crops = $this->getCrops($id);
      if($crops != null){
        
                    if($field=="status"){
                        $status = $crops->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $crops->status=$status;
                        $crops->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $crops = $this->getCrops($id);
      if($crops !=null){
        $img = public_path().'/uploads/'.$crops->featured_img;
            if($crops->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $crops->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getCropsData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $crops = Crops::select(array('crops.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $crops->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $crops->orderBy($sortBy, $order);
        } else{
          $crops->orderBy('crops.crp_id', 'desc');
        }        

        return $crops->paginate($per_page);
    }

    public function getCropsExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $crops = Crops::select(array('crops.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $crops->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $crops->orderBy($sortBy, $order);
        } else{
          $crops->orderBy('crops.crp_id', 'desc');
        }
        return $crops->get();
    }

    public function updateCrops($request){
      $id = $request->input('crp_id');
      $crops = Crops::getCrops($id);
      if($crops !=null){

          $crops->crop = $request->input('crop')!="" ? $request->input('crop') : "";
	$crops->status = $request->input('status')!="" ? $request->input('status') : "";

          $crops->save();
          return true;
      } else{
        return false;
      }
    }

    public function addCrops($request){
      $crops = new Crops;

        $crops->crop = $request->input('crop')!="" ? $request->input('crop') : "";
	$crops->status = $request->input('status')!="" ? $request->input('status') : "";

        $crops->save();
        return $crops->crp_id;
    }
}
