<?php
namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Trader_company;
use DB;
use Illuminate\Support\Facades\Input;

class Trader_companyController extends Controller
{
    public function __construct(){
        $this->trader_company = new \App\admin\Trader_company;
    }

    public $v_fields=array('trader_company.company_name', 'trader_company.email', 'trader_company.mobile', 'trader_company.password', 'trader_company.status');
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function index(Request $request){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';
        $_GET['searchValue']=$_GET['searchValue']??"";
        // order
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
            if(isset($_GET['order']) && $_GET['order']!=''){
                $_GET['order']=$_GET['order']=='asc'?'desc':'asc';
            } else{
                $_GET['order']='desc';
            }
        }

        // create links for field
        $get_q = $_GET;
        foreach ($this->v_fields as $key => $value) {
          $get_q['sortBy'] = $value;
          $get_q['page']=1;
          $query_result = http_build_query($get_q);
          $links[$value.'_link'] =url('/').'/admin/trader_company?'.$query_result;
        }
        $links['csvlink'] = url('/').'/admin/trader_company/export/csv?'.$_SERVER['QUERY_STRING'];
        $links['pdflink'] = url('/').'/admin/trader_company/export/pdf?'.$_SERVER['QUERY_STRING'];

        // pagination per page
        $per_page = isset($_GET['per_page'])?$_GET['per_page']:10;

        // search value
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy=$_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // get by modal
        /*$trader_company = new \App\admin\Trader_company;*/
        $data = $this->trader_company->getTrader_companyData($per_page, $searchBy, $searchValue, $sortBy, $order);

        return view('admin/trader_company/index', ['data'=>$data->appends(Input::except('page')), 'per_page'=>$per_page, 'links'=>$links]);
    }



    public function getAdd(Request $request){
        /*$trader_company = new \App\admin\Trader_company;*/
        $data = array();
        
    	return view('admin/trader_company/add', $data);
    }

    public function postEdit(Request $request){

        $this->validate($request, [
            
        ]);

        /*$trader_company = new \App\admin\Trader_company;*/
        if($this->trader_company->updateTrader_company($request)){
            
            $request->session()->flash('message', 'Trader_company Updated successfully!');
            return redirect()->action('admin\Trader_companyController@index');
        } else{
            $request->session()->flash('message', 'Error: Invalid record!');
            return redirect()->action('admin\Trader_companyController@index');
        }
    }

    public function postAdd(Request $request){

        $this->validate($request, [
            
        ]);

        /*$trader_company = new \App\admin\Trader_company;*/

        $insert_id = $this->trader_company->addTrader_company($request);

        
             
       

        $request->session()->flash('message', 'Trader_company added successfully!');
        return redirect()->action('admin\Trader_companyController@index');
    }

    public function getEdit($id=''){
        
        /*$trader_company = new \App\admin\Trader_company;*/
        $data = array();

        
        
        $data['data'] = $this->trader_company->getTrader_company($id);
        if(count($data)){
            return view('admin/trader_company/edit', $data);
        } else{
            return view('admin/trader_company/edit');
        }
    }

    public function view($id){
        /*$trader_company = new \App\admin\Trader_company;*/
        $data['data'] = $this->trader_company->getTrader_companyView($id);
        
        
        if(count($data)){
            return view('admin/trader_company/view', $data);
        } else{
            return view('admin/trader_company/view');
        }
    }

    public function status(Request $request, $field, $id){
        /*$trader_company = new \App\admin\Trader_company;*/
        $flag = $this->trader_company->changeStatus($field, $id);
        // $redirect = $_GET["redirect"];
        if($flag){
            $request->session()->flash('message', 'Status changed successfully!');
            // return redirect($redirect);
            return redirect()->action('admin\Trader_companyController@index');
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\Trader_companyController@index');
        }
    }

    public function delete(Request $request){
    	$id = $request->input('tc_id');
        /*$trader_company = new \App\admin\Trader_company;*/
        $flag = $this->trader_company->deleteOne($id);
        if($flag){
            $request->session()->flash('message', 'Trader_company deleted successfully!');
            if($request->input('redirect')!=''){
                return redirect(urldecode($request->input('redirect')));
            } else{
                return redirect()->action('admin\Trader_companyController@index');
            }
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\Trader_companyController@index');
        }
    }

    public function deleteAll(Request $request)
    {
        $allIds = $request->input('allIds');
        $flag = false;
        /*$trader_company = new \App\admin\Trader_company;*/
        for($i=0; $i<count($allIds); $i++)
        {
            if($allIds[$i]!="")
            {
                $id = $allIds[$i];
                $flag = $this->trader_company->deleteOne($id);                
            }
        }

        if($flag){
            $request->session()->flash('message', 'Demo deleted successfully!');
        }
    }

    public function getExport($type){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';

        // search query
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy = $_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // sort by
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
        }

        /*$trader_company = new \App\admin\Trader_company;*/
        $data = $this->trader_company->getTrader_companyExport($searchBy, $searchValue, $sortBy, $order);

        if($type=='csv'){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=trader_company.csv');
            header('Pragma: no-cache');
            $csv='Sr. No,'.implode(',', $this->v_fields)."\n";
            foreach ($data as $key => $value) {
                $line=($key+1).',';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $line.='"'.$value->$field.'"'.',';
                }
                $csv.=ltrim($line,',')."\n";
            }
            echo $csv; exit;
        } elseif($type=='pdf'){
            require_once(app_path().'/libraries/mpdf/mpdf.php');
            $table='
            <html>
            <head><title></title>
            <style>
            table{
                border:1px solid;
            }
            tr:nth-child(even)
            {
                background-color: rgba(158, 158, 158, 0.82);
            }
            </style>
            </head>
            <body>
            <h1 align="center">trader_company</h1>
            <table><tr>';
            $table.='<th>Sr. No</th>';
            foreach ($this->v_fields as $value) {
                $table.='<th>'.$value.'</th>';
            }
            $table.='</tr>';
            foreach ($data as $key => $value) {
                $table.='<tr><td>'.($key+1).'</td>';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $table.='<td>'.$value->$field.'</td>';
                }
                $table.='</tr>';
            }
            $table.='</table></body></html>';
            $pdf = new \mPDF();
            $pdf->WriteHTML($table);
            $pdf->Output('trader_company.pdf', "D");
            exit;
        } else{
            echo 'Invalid option!';
        }
    }
}
