<?php
namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Purchase;
use DB;
use Illuminate\Support\Facades\Input;

class PurchaseController extends Controller
{
    public function __construct(){
         parent::__construct($this->masterModel);
        $this->purchase = new \App\admin\Purchase;
    }

    public $v_fields=array('purchase.patti_no', 'trader_company.company_name', 'traders.name', 'purchase.farmer', 'purchase.transporter_name', 'purchase.truck_no', 'purchase.freight_charge', 'purchase.status');
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function index(Request $request){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';
        $_GET['searchValue']=$_GET['searchValue']??"";
        // order
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
            if(isset($_GET['order']) && $_GET['order']!=''){
                $_GET['order']=$_GET['order']=='asc'?'desc':'asc';
            } else{
                $_GET['order']='desc';
            }
        }

        // create links for field
        $get_q = $_GET;
        foreach ($this->v_fields as $key => $value) {
          $get_q['sortBy'] = $value;
          $get_q['page']=1;
          $query_result = http_build_query($get_q);
          $links[$value.'_link'] =url('/').'/admin/purchase?'.$query_result;
        }
        $links['csvlink'] = url('/').'/admin/purchase/export/csv?'.$_SERVER['QUERY_STRING'];
        $links['pdflink'] = url('/').'/admin/purchase/export/pdf?'.$_SERVER['QUERY_STRING'];

        // pagination per page
        $per_page = isset($_GET['per_page'])?$_GET['per_page']:10;

        // search value
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy=$_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // get by modal
        /*$purchase = new \App\admin\Purchase;*/
        $data = $this->purchase->getPurchaseData($per_page, $searchBy, $searchValue, $sortBy, $order);

        return view('admin/purchase/index', ['data'=>$data->appends(Input::except('page')), 'per_page'=>$per_page, 'links'=>$links]);
    }



    public function getAdd(Request $request){
        /*$purchase = new \App\admin\Purchase;*/
        $data = array('trader_company'=>$this->purchase->getAll('trader_company'),'traders'=>$this->purchase->getAll('traders'));
        
    	return view('admin/purchase/add', $data);
    }

    public function postEdit(Request $request){

        $this->validate($request, [
            
        ]);

        /*$purchase = new \App\admin\Purchase;*/
        if($this->purchase->updatePurchase($request)){
            
            $request->session()->flash('message', 'Purchase Updated successfully!');
            return redirect()->action('admin\PurchaseController@index');
        } else{
            $request->session()->flash('message', 'Error: Invalid record!');
            return redirect()->action('admin\PurchaseController@index');
        }
    }

    public function postAdd(Request $request){

        $this->validate($request, [
            
        ]);

        /*$purchase = new \App\admin\Purchase;*/

        $insert_id = $this->purchase->addPurchase($request);

        
             
       

        $request->session()->flash('message', 'Purchase added successfully!');
        return redirect()->action('admin\PurchaseController@index');
    }

    public function getEdit($id=''){
        
        /*$purchase = new \App\admin\Purchase;*/
        $data = array('trader_company'=>$this->purchase->getAll('trader_company'),'traders'=>$this->purchase->getAll('traders'));

        
        
        $data['data'] = $this->purchase->getPurchase($id);
        if(count($data)){
            return view('admin/purchase/edit', $data);
        } else{
            return view('admin/purchase/edit');
        }
    }

    public function view($id){
        /*$purchase = new \App\admin\Purchase;*/
        $data['data'] = $this->purchase->getPurchaseView($id);
        
        $data['crop']=$this->masterModel->customequery('select crop_transactions.*,crops.crop as crop_name,marqua.quality as crop_quality from crop_transactions left join crops on crop_transactions.crop=crops.crp_id left join marqua on marqua.mq_id=crop_transactions.marqua where pr_id='.$id);
        if(count($data)){
            return view('admin/purchase/view', $data);
        } else{
            return view('admin/purchase/view');
        }
    }

    public function status(Request $request, $field, $id){
        /*$purchase = new \App\admin\Purchase;*/
        $flag = $this->purchase->changeStatus($field, $id);
        // $redirect = $_GET["redirect"];
        if($flag){
            $request->session()->flash('message', 'Status changed successfully!');
            // return redirect($redirect);
            return redirect()->action('admin\PurchaseController@index');
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\PurchaseController@index');
        }
    }

    public function delete(Request $request){
    	$id = $request->input('p_id');
        /*$purchase = new \App\admin\Purchase;*/
        $flag = $this->purchase->deleteOne($id);
        if($flag){
            $request->session()->flash('message', 'Purchase deleted successfully!');
            if($request->input('redirect')!=''){
                return redirect(urldecode($request->input('redirect')));
            } else{
                return redirect()->action('admin\PurchaseController@index');
            }
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\PurchaseController@index');
        }
    }

    public function deleteAll(Request $request)
    {
        $allIds = $request->input('allIds');
        $flag = false;
        /*$purchase = new \App\admin\Purchase;*/
        for($i=0; $i<count($allIds); $i++)
        {
            if($allIds[$i]!="")
            {
                $id = $allIds[$i];
                $flag = $this->purchase->deleteOne($id);                
            }
        }

        if($flag){
            $request->session()->flash('message', 'Demo deleted successfully!');
        }
    }

    public function getExport($type){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';

        // search query
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy = $_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // sort by
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
        }

        /*$purchase = new \App\admin\Purchase;*/
        $data = $this->purchase->getPurchaseExport($searchBy, $searchValue, $sortBy, $order);

        if($type=='csv'){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=purchase.csv');
            header('Pragma: no-cache');
            $csv='Sr. No,'.implode(',', $this->v_fields)."\n";
            foreach ($data as $key => $value) {
                $line=($key+1).',';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $line.='"'.$value->$field.'"'.',';
                }
                $csv.=ltrim($line,',')."\n";
            }
            echo $csv; exit;
        } elseif($type=='pdf'){
            require_once(app_path().'/libraries/mpdf/mpdf.php');
            $table='
            <html>
            <head><title></title>
            <style>
            table{
                border:1px solid;
            }
            tr:nth-child(even)
            {
                background-color: rgba(158, 158, 158, 0.82);
            }
            </style>
            </head>
            <body>
            <h1 align="center">purchase</h1>
            <table><tr>';
            $table.='<th>Sr. No</th>';
            foreach ($this->v_fields as $value) {
                $table.='<th>'.$value.'</th>';
            }
            $table.='</tr>';
            foreach ($data as $key => $value) {
                $table.='<tr><td>'.($key+1).'</td>';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $table.='<td>'.$value->$field.'</td>';
                }
                $table.='</tr>';
            }
            $table.='</table></body></html>';
            $pdf = new \mPDF();
            $pdf->WriteHTML($table);
            $pdf->Output('purchase.pdf', "D");
            exit;
        } else{
            echo 'Invalid option!';
        }
    }
}
