<?php
namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Crop_transactions;
use DB;
use Illuminate\Support\Facades\Input;

class Crop_transactionsController extends Controller
{
    public function __construct(){
        $this->crop_transactions = new \App\admin\Crop_transactions;
    }

    public $v_fields=array('crops.crop', 'marqua.quality', 'crop_transactions.quantity', 'crop_transactions.bangdi', 'crop_transactions.weight', 'crop_transactions.cost', 'crop_transactions.status');
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function index(Request $request){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';
        $_GET['searchValue']=$_GET['searchValue']??"";
        // order
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
            if(isset($_GET['order']) && $_GET['order']!=''){
                $_GET['order']=$_GET['order']=='asc'?'desc':'asc';
            } else{
                $_GET['order']='desc';
            }
        }

        // create links for field
        $get_q = $_GET;
        foreach ($this->v_fields as $key => $value) {
          $get_q['sortBy'] = $value;
          $get_q['page']=1;
          $query_result = http_build_query($get_q);
          $links[$value.'_link'] =url('/').'/admin/crop_transactions?'.$query_result;
        }
        $links['csvlink'] = url('/').'/admin/crop_transactions/export/csv?'.$_SERVER['QUERY_STRING'];
        $links['pdflink'] = url('/').'/admin/crop_transactions/export/pdf?'.$_SERVER['QUERY_STRING'];

        // pagination per page
        $per_page = isset($_GET['per_page'])?$_GET['per_page']:10;

        // search value
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy=$_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // get by modal
        /*$crop_transactions = new \App\admin\Crop_transactions;*/
        $data = $this->crop_transactions->getCrop_transactionsData($per_page, $searchBy, $searchValue, $sortBy, $order);

        return view('admin/crop_transactions/index', ['data'=>$data->appends(Input::except('page')), 'per_page'=>$per_page, 'links'=>$links]);
    }



    public function getAdd(Request $request){
        /*$crop_transactions = new \App\admin\Crop_transactions;*/
        $data = array('crops'=>$this->crop_transactions->getAll('crops'),'marqua'=>$this->crop_transactions->getAll('marqua'));
        
    	return view('admin/crop_transactions/add', $data);
    }

    public function postEdit(Request $request){

        $this->validate($request, [
            
        ]);

        /*$crop_transactions = new \App\admin\Crop_transactions;*/
        if($this->crop_transactions->updateCrop_transactions($request)){
            
            $request->session()->flash('message', 'Crop_transactions Updated successfully!');
            return redirect()->action('admin\Crop_transactionsController@index');
        } else{
            $request->session()->flash('message', 'Error: Invalid record!');
            return redirect()->action('admin\Crop_transactionsController@index');
        }
    }

    public function postAdd(Request $request){

        $this->validate($request, [
            
        ]);

        /*$crop_transactions = new \App\admin\Crop_transactions;*/

        $insert_id = $this->crop_transactions->addCrop_transactions($request);

        
             
       

        $request->session()->flash('message', 'Crop_transactions added successfully!');
        return redirect()->action('admin\Crop_transactionsController@index');
    }

    public function getEdit($id=''){
        
        /*$crop_transactions = new \App\admin\Crop_transactions;*/
        $data = array('crops'=>$this->crop_transactions->getAll('crops'),'marqua'=>$this->crop_transactions->getAll('marqua'));

        
        
        $data['data'] = $this->crop_transactions->getCrop_transactions($id);
        if(count($data)){
            return view('admin/crop_transactions/edit', $data);
        } else{
            return view('admin/crop_transactions/edit');
        }
    }

    public function view($id){
        /*$crop_transactions = new \App\admin\Crop_transactions;*/
        $data['data'] = $this->crop_transactions->getCrop_transactionsView($id);
        
        
        if(count($data)){
            return view('admin/crop_transactions/view', $data);
        } else{
            return view('admin/crop_transactions/view');
        }
    }

    public function status(Request $request, $field, $id){
        /*$crop_transactions = new \App\admin\Crop_transactions;*/
        $flag = $this->crop_transactions->changeStatus($field, $id);
        // $redirect = $_GET["redirect"];
        if($flag){
            $request->session()->flash('message', 'Status changed successfully!');
            // return redirect($redirect);
            return redirect()->action('admin\Crop_transactionsController@index');
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\Crop_transactionsController@index');
        }
    }

    public function delete(Request $request){
    	$id = $request->input('cp_id');
        /*$crop_transactions = new \App\admin\Crop_transactions;*/
        $flag = $this->crop_transactions->deleteOne($id);
        if($flag){
            $request->session()->flash('message', 'Crop_transactions deleted successfully!');
            if($request->input('redirect')!=''){
                return redirect(urldecode($request->input('redirect')));
            } else{
                return redirect()->action('admin\Crop_transactionsController@index');
            }
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\Crop_transactionsController@index');
        }
    }

    public function deleteAll(Request $request)
    {
        $allIds = $request->input('allIds');
        $flag = false;
        /*$crop_transactions = new \App\admin\Crop_transactions;*/
        for($i=0; $i<count($allIds); $i++)
        {
            if($allIds[$i]!="")
            {
                $id = $allIds[$i];
                $flag = $this->crop_transactions->deleteOne($id);                
            }
        }

        if($flag){
            $request->session()->flash('message', 'Demo deleted successfully!');
        }
    }

    public function getExport($type){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';

        // search query
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy = $_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // sort by
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
        }

        /*$crop_transactions = new \App\admin\Crop_transactions;*/
        $data = $this->crop_transactions->getCrop_transactionsExport($searchBy, $searchValue, $sortBy, $order);

        if($type=='csv'){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=crop_transactions.csv');
            header('Pragma: no-cache');
            $csv='Sr. No,'.implode(',', $this->v_fields)."\n";
            foreach ($data as $key => $value) {
                $line=($key+1).',';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $line.='"'.$value->$field.'"'.',';
                }
                $csv.=ltrim($line,',')."\n";
            }
            echo $csv; exit;
        } elseif($type=='pdf'){
            require_once(app_path().'/libraries/mpdf/mpdf.php');
            $table='
            <html>
            <head><title></title>
            <style>
            table{
                border:1px solid;
            }
            tr:nth-child(even)
            {
                background-color: rgba(158, 158, 158, 0.82);
            }
            </style>
            </head>
            <body>
            <h1 align="center">crop_transactions</h1>
            <table><tr>';
            $table.='<th>Sr. No</th>';
            foreach ($this->v_fields as $value) {
                $table.='<th>'.$value.'</th>';
            }
            $table.='</tr>';
            foreach ($data as $key => $value) {
                $table.='<tr><td>'.($key+1).'</td>';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $table.='<td>'.$value->$field.'</td>';
                }
                $table.='</tr>';
            }
            $table.='</table></body></html>';
            $pdf = new \mPDF();
            $pdf->WriteHTML($table);
            $pdf->Output('crop_transactions.pdf', "D");
            exit;
        } else{
            echo 'Invalid option!';
        }
    }
}
