<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use App\Jobs\ProcessEmail;
use App\Jobs\ProcessTime;
use DB;
use Carbon\Carbon;
use DateTime;
use DateInterval;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('dashboard');
    }

    public function getCandidates($id="")
    { 
      $candidate = DB::table('con_added_cv')->leftjoin('candidates','con_added_cv.addcv_can_id','=','candidates.can_id')->where('con_cv_id',$id)->get(['candidates.can_id','con_added_cv.addcv_created'])->first();
      if($candidate!=null)
      {
            // $d = date('Y-m-d',strtotime($value->addcv_created));
            // dd(date('Y-m-d H:i:s', strtotime($d. ' + 15 days')));
        $date = date('Y-m-d H:i:s', strtotime($value->addcv_created. ' + 15 days'));            
            // dd(Carbon::parse($date),Carbon::now()->addDay('15'));
        $emailJob = (new ProcessEmail($value->can_id))->delay(Carbon::parse($date));
            // $emailJob = (new ProcessEmail($value->can_id))->delay(Carbon::now()->addSeconds(5));
        dispatch($emailJob);
       
      }
        echo 'email sent';
    }

    public function sendEmail($id)
    {
       $data = DB::table('candidates')->leftjoin('consultants','candidates.con_id','=','consultants.con_id')->where('candidates.can_id',$id)->where('candidates.can_is_active',0)->get(['candidates.*','consultants.con_name'])->first();
       if($data!=null)
       {
         $this->to=$data->can_email;

            $message = "<h4><b>Dear ".$data->can_name." , </b></h4><br>
                       Your CV has been uploaded by ".$data->con_name.".";
            
            $msg1['msg'] = $message;

          \Mail::send('mail', $msg1, function($message) {
             $message->to($this->to)->subject('Login Credentials');
             $message->from('devs.togglebytes@gmail.com','Smalt Consultancy : Signup');
          });
       } 
        
    }

    public function getJobs($con_id)
    {
        $data = DB::table('con_added_jobs')->where('addcv_con_id',$con_id)->get();
        if(count($data)>0)
        {
            foreach ($data as $key => $value) 
            { 
                $date = date('Y-m-d',strtotime($value->addcv_created));
                $date = new DateTime($date);

                $time = date('H:i:s',strtotime($value->addcv_created));
                if($time > '15:00:00')
                {
                    $date->add(new DateInterval('P1DT13H'));
                }else
                {
                    $date->add(new DateInterval('PT3H'));
                }

                $setTime = (new ProcessTime($value->con_cv_id))->delay(Carbon::parse($date->format('Y-m-d H:i:s')));
                dispatch($setTime);
            }
        }
    }

    public function deleteJobs($id)
    {
        DB::table('con_added_jobs')->where('con_cv_id',$id)->update(['addcv_status'=>0]);
    }
}
