<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Hash;
use Request as Req;
use Auth;

class BuyerController extends Controller
{
	public function __construct()
    {
        parent::__construct($this->masterModel);

        $email=Req::header('email');
        $pass=Req::header('password');
        
        if(!Auth::attempt(['email' => $email, 'password' => $pass]))
        {
            echo response()->json(['error'=>'Unauthorised'], 401);
            die();
        }
    }

    public function addBuyer(Request $request)
    {
    	// dd($request['name'],$request->input('name'));
        $validator = \Validator::make($request->all(),[
                        'name'=>'required',
                        'mobile'=>'required|min:10|unique:buyers,mobile',    
                    ]);

        if ($validator->fails()) {
            return $this->masterModel->failureResponse($validator->messages());
        }
    	$data = [
            'tc_id'=>$request->input('traderCId'),
            't_id'=>$request->input('traderId') ?? '',
            'name'=>$request->input('name'),
            'email'=>$request->input('email') ?? '',
            'mobile'=>$request->input('mobile'),
            'status'=>1,
            'created'=>date('Y-m-d H:i:s')
        ];

        $exist = $this->masterModel->checkDataExist('buyers',['tc_id'=>$request->input('traderCId'),'mobile'=>$request->input('mobile')]);
        if(!$exist)
        {
           $buyerId = $this->masterModel->addDataGetID('buyers',$data);

           $sell = [
                'tc_id'=>$request->input('traderCId'),
                'trader'=>$request->input('traderId') ?? '',
                'buyer'=>$buyerId,
                'transporter_name'=>$request->input('transporter_name') ?? '',
                'truck_no'=>$request->input('truck_number') ?? '',
                'status'=>1,
                'created'=>date('Y-m-d H:i:s')
            ];

           $sellId = $this->masterModel->addDataGetID('sells',$sell);

           $controller = new \App\Http\Controllers\FarmerController;
           $request['sell'] = $sellId;
           $request['ctType'] = 2; 
           $controller->addCropTransaction($request);
           
           return $this->masterModel->successResponse('Buyer added successfully');
        }else
        {
           return $this->masterModel->failureResponse('Buyer already exist!');
        }
    }

    public function getSells(Request $request)
    {
        $tcId=$request->input('traderCId');
        $tId=$request->input('traderId');
        $s=[];
        $q=DB::table('sells');
        if($request->input('flag')==2)
        {
            $q->where('sells.trader',$tId);
        }
            $q->where('sells.tc_id',$tcId);
            $q->join('buyers','buyers.b_id','=','sells.buyer');
        $data=$q->get();
        foreach ($data as $key => $value) {
            $s[$key]['sells']=$value;
            $s[$key]['crops']=$this->masterModel->customequery('select crop_transactions.*,crops.crop as crop_name,marqua.quality as crop_quality from crop_transactions left join crops on crop_transactions.crop=crops.crp_id left join marqua on marqua.mq_id=crop_transactions.marqua where sell_id='.$value->sell_id);
        }
        // dd($data,$s);
        if(count($s))
        {
            return $this->masterModel->successResponse($s); 
        }else
        {
            return $this->masterModel->failureResponse('No purchase data found!');
        }
    }
}