<!DOCTYPE html>
<html lang="en">
<head>
    <title>Fix Your Credit Yourself</title>
    <meta charset="utf-8">

    <meta name="base-url" content="<?php echo e(url('/')); ?>">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <meta name="viewport" content="width=device-width, initial-scale=1"> 

    <link rel="shortcut icon" href="<?php echo e(url('/')); ?>/accets/frontend/img/favicon.ico"> 

    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/accets/frontend/css/style.css">

    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/accets/frontend/css/font-awesome.min.css"> 

    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/accets/frontend/css/bootstrap.min.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">

    <!-- <link href="<?php echo url('/'); ?>/accets/vendors/bootstrap-datepicker/
        css/bootstrap-datepicker.css" rel="stylesheet"> -->

    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">

    <script src="<?php echo e(url('/')); ?>/accets/frontend/js/jquery.min.js"></script>

    <style type="text/css">
    .select2.select2-container{
      width: 100% !important;
    }
  </style>


</head>
<style type="text/css"> #loading { position: fixed; top:0; left: 0; width: 100%; height: 100%; background:#eeeeee4d; text-align:center; z-index: 9999999999999999;} #loading img { margin-top:25%; width:250px; } </style> 
 <div id="loading">
   <div class="container">
    <img src="<?php echo e(url('/')); ?>/accets/frontend/img/loader.gif" class="loader_img">
  </div>
</div>
<body> 

    <header>

        <section class="desktop-menu">

            <div class="fixed-top" id="divFixedTop">

                <div class="container">

                    <div class="row justify-content-between align-items-center">

                        <div class="col-3">

                            <a class="d-md-none header__action open-nav" href="javascript:;" onclick="openNav()">

                                <img src="<?php echo e(url('/')); ?>/accets/frontend/img/hamburger.svg" width="30">

                            </a>

                            <a class="logo d-none d-md-block" href="<?php echo e(url('/')); ?>">

                                <img src="<?php echo e(url('/')); ?>/accets/frontend/img/logo.png">

                            </a>

                        </div>

                        <div class="col-6 col-sm-5 text-center">

                            <span class="d-md-none header__name">

                                <a class="logo " href="<?php echo e(url('/')); ?>">

                                    <img src="<?php echo e(url('/')); ?>/accets/frontend/img/logo.png">

                                </a>

                            </span>

                        </div>

                        <div class="col-3 col-sm-4 text-right">
                        <?php if(Session::has('userLoginInfo')): ?>
                            <div class="dropdown d-inline-flex">

                                <a class="header_action" id="userDropdown" data-toggle="dropdown" href="javascript:;" aria-expanded="false" aria-haspopup="true"><i class="fa fa-user-circle"></i></a>

                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="userDropdown">

                                    <a class="dropdown-item disabled ">Hi,<span class="text-capitalize"><?php echo Session::get('userLoginInfo')['first_name'];?></span></a>

                                    <?php if(request()->segment(count(request()->segments()))!='membership'): ?>
                                    <a class="dropdown-item" href="<?php echo e(url('/')); ?>/myaccount">My Account</a>

                                    <a class="dropdown-item" href="<?php echo e(url('/')); ?>/faq">FAQ</a> 
                                    <?php endif; ?>
                                    <a href="<?php echo e(url('/')); ?>/logOut" class="dropdown-item dropdown-item-signout">Sign Out</a>
                                    
                                </div>

                            </div>
                        <?php else: ?>
                            <?php if(request()->segment(count(request()->segments()))=='signIn'): ?>
                                <a href="<?php echo e(url('/')); ?>/signUp">Don't have an account? Sign Up!</a>
                            <?php elseif(request()->segment(count(request()->segments()))=='signUp'): ?>
                                <a href="<?php echo e(url('/')); ?>/signIn">Already a member? Log In</a>
                            <?php else: ?>
                                <a href="<?php echo e(url('/')); ?>/signIn">Sign In</a>
                            <?php endif; ?>
                        <?php endif; ?>
                        </div>

                    </div>

                </div>

            </div>
            <?php if(Session::has('userLoginInfo') && request()->segment(count(request()->segments()))!='membership' && request()->segment(count(request()->segments()))!='create_dispute'): ?>
           
            <nav class="navbar  navbar-expand-md navbar-new-bottom MT75 pt-4">

                <div class="container">

                    <div class="navbar-collapse collapse pt-2 pt-md-0" >

                        <ul class="navbar-nav w-100 justify-content-center menu_center">

                            <li class="nav-item ">

                                <a class="nav-link <?php if(Request::segment(1)==null): ?> active <?php endif; ?>" href="<?php echo e(url('/')); ?>"><i class="fa fa-home"></i><span>Home</span></a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link <?php if(Request::segment(1)=='account_summary'): ?> active <?php endif; ?>" href="<?php echo e(url('/')); ?>/account_summary"><i class="fa fa-credit-card"></i><span>Credit Items</span></a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link <?php if(Request::segment(1)=='dispute_summary'): ?> active <?php endif; ?>" href="<?php echo e(url('/')); ?>/dispute_summary"><i class="fa fa-envelope"></i><span>Dispute Letters</span></a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link <?php if(Request::segment(1)=='score_summary'): ?> active <?php endif; ?>" href="<?php echo e(url('/')); ?>/score_summary"><i class="fa fa-history"></i><span>My History</span></a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link <?php if(Request::segment(1)=='resources'): ?> active <?php endif; ?>" href="<?php echo e(url('/')); ?>/resources"><i class="fa fa-lightbulb-o"></i><span>Resources</span></a>

                            </li>  

                        </ul>  

                    </div>

                </div>

            </nav>
            <?php endif; ?>
        </section>

        <section class="mobile-menu ">

            <div class="mob_nav_rgt">

                <div id="mySidenav" class="sidenav ">

                    <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">×</a>

                    <ul class="navbar-nav w-100 justify-content-center pt-5">

                        <li class="nav-item">

                            <a class="nav-link  active" href="<?php echo e(url('/')); ?>"><i class="fa fa-home"></i><span>Home</span></a>

                        </li>

                        <li class="nav-item">

                            <a class="nav-link " href="<?php echo e(url('/')); ?>/credit"><i class="fa fa-credit-card"></i><span>Credit Items</span></a>

                        </li>

                        <li class="nav-item">

                            <a class="nav-link " href="<?php echo e(url('/')); ?>/dispute"><i class="fa fa-envelope"></i><span>Dispute Letters</span></a>

                        </li>

                        <li class="nav-item">

                            <a class="nav-link " href="<?php echo e(url('/')); ?>/summary"><i class="fa fa-history"></i><span>My History</span></a>

                        </li>

                        <li class="nav-item">

                            <a class="nav-link " href="<?php echo e(url('/')); ?>/resources"><i class="fa fa-lightbulb-o"></i><span>Resources</span></a>

                        </li>

                    </ul>

                </div>

            </div>

        </section>

    </header>

    <?php echo $__env->yieldContent('content'); ?>

    <footer>

    <div class="container">

        <div class="row">

            <div class="col-lg-4 col-md-4 col-sm-12 col-12">

                <a class="logo " href="<?php echo e(url('/')); ?>">

                    <img src="<?php echo e(url('/')); ?>/accets/frontend/img/logo.png">

                </a>

            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-6">

                <div class="footer-title">

                    <h5>SUPPORT</h5>

                </div>

                <ul class="ul-reset footer-links">

                    <li><a href="<?php echo e(url('/')); ?>/faq">FAQs</a></li>

                    <li><a href="<?php echo e(url('/')); ?>/resources#nav-profile">Educational</a></li>

                    <li><a href="<?php echo e(url('/')); ?>/resources#nav-home">Tutorial</a></li>

                </ul>



            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-6">

                 <div class="footer-title">

                    <h5>COMPANY</h5>

                </div>

                <ul class="ul-reset footer-links">

                    <li>Mon-Fri 9am to 5pm PST</li>

                    <li><a href="mailto:support@fixyourcredityourself.com">support@fixyourcredityourself.com</a></li>

                    <li><a href="tel:(022) 111-111-11">(022) 111-111-11</a></li>

                </ul>               

            </div>

        </div>

    </div>

    <section class="footer_bottom">

        <div class="container">

            <div class="row">

                <div class="col-md-12">

                    <ul class="ul-reset footer-social">

                        <li><a href="#" target="_blank"><i class="fa fa-facebook"></i></a></li>                        

                    </ul>

                    <ul class="ul-reset footer-copy">

                        <li><a href="<?php echo e(url('/')); ?>/terms_condition">Terms Of Use</a></li>

                        <li><a href="<?php echo e(url('/')); ?>/privacy">Privacy Policy</a></li>

                        <li>© <?php echo e(date('Y')); ?> FixYourCreditYourself.com , All rights reserved.</li>

                    </ul>

                </div>

            </div>

        </div>

    </section>

</footer>

</div>  



    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>

    <script src="<?php echo e(url('/')); ?>/accets/frontend/js/bootstrap.min.js"></script>   

    <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.6.0/slick.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.3/jquery.easing.min.js" type="text/javascript"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js" type="text/javascript"></script>

    <script src="<?php echo e(url('/')); ?>/accets/frontend/js/custom_js.js"></script>

    <script type="text/javascript" src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>

    <!-- <script src="<?php echo e(url('/')); ?>/accets/vendors/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script> -->
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        
    <script type="text/javascript">

$(document).ready(function(){
      $('ul li a').click(function(){
        $('li a').removeClass("active");
        $(this).addClass("active");
    });
  });


        $(document).ready(function(){
            $("#loading").hide();
            setTimeout(function(){$('.alert').fadeOut(500);},3000);
            $(".select2").select2({placeholder: "Select",});
        });

        $(".date").datepicker({
            format: 'dd-mm-yyyy',
            maxDate: 0,
        });

        function errMessage(id,msg)
        {
          $('#'+id).fadeIn(); 
          $('#'+id).text(msg);
          setTimeout(function(){$('#'+id).fadeOut(500);},3000); 
          return false;
        }

         $(function(){
          var hash= window.location.hash;
          if(hash.length > 0 ) {
              // $('a[role="tab"]').removeClass('active');//remove the default active tab
              // $('a[href="'+hash+'"]').addClass('active');
              // $('.nav-item').removeClass('active');
              // $(hash).addClass('active');
           }
        });
    </script>

    </body>

</html>

       

