<!DOCTYPE html>

<html lang="en">

<head>

    <title>Fix Your Credit Yourself</title>

    <meta charset="utf-8">

    <meta name="base-url" content="<?php echo e(url('/')); ?>">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <meta name="viewport" content="width=device-width, initial-scale=1"> 

    <link rel="shortcut icon" href="<?php echo e(url('/')); ?>/accets/frontend/img/favicon.ico"> 

    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/accets/frontend/css/style.css">

    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/accets/frontend/css/font-awesome.min.css"> 

    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/accets/frontend/css/bootstrap.min.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <script src="<?php echo e(url('/')); ?>/accets/frontend/js/jquery.min.js"></script>

</head>

<body> 

    <header>

        <section class="desktop-menu">

            <div class="fixed-top" id="divFixedTop">

                <div class="container">

                    <div class="row justify-content-between align-items-center">

                        <div class="col-3">

                            <a class="d-md-none header__action open-nav" href="javascript:;" onclick="openNav()">

                                <img src="<?php echo e(url('/')); ?>/accets/frontend/img/hamburger.svg" width="30">

                            </a>

                            <a class="logo d-none d-md-block" href="<?php echo e(url('/')); ?>">

                                <img src="<?php echo e(url('/')); ?>/accets/frontend/img/logo.png">

                            </a>

                        </div>

                        <div class="col-6 col-sm-5 text-center">

                            <span class="d-md-none header__name">

                                <a class="logo " href="<?php echo e(url('/')); ?>">

                                    <img src="<?php echo e(url('/')); ?>/accets/frontend/img/logo.png">

                                </a>

                            </span>

                        </div>

                        <div class="col-3 col-sm-4 text-right">

                            <div class="dropdown d-inline-flex">

                                <a class="header_action" id="userDropdown" data-toggle="dropdown" href="javascript:;" aria-expanded="false" aria-haspopup="true"><i class="fa fa-user-circle"></i></a>

                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="userDropdown">

                                    <a class="dropdown-item disabled ">Hi, <span class="text-capitalize"><?php if(Session::has('userLoginInfo')): ?><?php echo Session::has('userLoginInfo')->name;?> <?php else: ?> User <?php endif; ?></span></a>

                                    <a class="dropdown-item" href="<?php echo e(url('/')); ?>/myaccount">My Account</a>

                                    <a class="dropdown-item" href="<?php echo e(url('/')); ?>/faq">FAQ</a> 

                                    <a href="<?php echo e(url('/')); ?>/logOut" class="dropdown-item dropdown-item-signout">Sign Out</a>
                                    
                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <nav class="navbar  navbar-expand-md navbar-new-bottom MT75 pt-4">

                <div class="container">

                    <div class="navbar-collapse collapse pt-2 pt-md-0" id="navbar2">

                        <ul class="navbar-nav w-100 justify-content-center menu_center">

                            <li class="nav-item active">

                                <a class="nav-link " href="<?php echo e(url('/')); ?>"><i class="fa fa-home"></i><span>Home</span></a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link " href="<?php echo e(url('/')); ?>/credit"><i class="fa fa-credit-card"></i><span>Credit Items</span></a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link " href="<?php echo e(url('/')); ?>/dispute"><i class="fa fa-envelope"></i><span>Dispute Letters</span></a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link " href="<?php echo e(url('/')); ?>/summary"><i class="fa fa-history"></i><span>My History</span></a>

                            </li>

                            <li class="nav-item">

                                <a class="nav-link " href="<?php echo e(url('/')); ?>/resources"><i class="fa fa-lightbulb-o"></i><span>Resources</span></a>

                            </li>  

                        </ul>  

                    </div>

                </div>

            </nav>

        </section>

        <section class="mobile-menu ">

            <div class="mob_nav_rgt">

                <div id="mySidenav" class="sidenav ">

                    <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">×</a>

                    <ul class="navbar-nav w-100 justify-content-center pt-5">

                        <li class="nav-item">

                            <a class="nav-link  active" href="<?php echo e(url('/')); ?>"><i class="fa fa-home"></i><span>Home</span></a>

                        </li>

                        <li class="nav-item">

                            <a class="nav-link " href="<?php echo e(url('/')); ?>/credit"><i class="fa fa-credit-card"></i><span>Credit Items</span></a>

                        </li>

                        <li class="nav-item">

                            <a class="nav-link " href="<?php echo e(url('/')); ?>/dispute"><i class="fa fa-envelope"></i><span>Dispute Letters</span></a>

                        </li>

                        <li class="nav-item">

                            <a class="nav-link " href="<?php echo e(url('/')); ?>/summary"><i class="fa fa-history"></i><span>My History</span></a>

                        </li>

                        <li class="nav-item">

                            <a class="nav-link " href="<?php echo e(url('/')); ?>/resources"><i class="fa fa-lightbulb-o"></i><span>Resources</span></a>

                        </li>

                    </ul>

                </div>

            </div>

        </section>

    </header>

    <?php echo $__env->yieldContent('content'); ?>

    <footer>

    <div class="container">

        <div class="row">

            <div class="col-lg-4 col-md-4 col-sm-12 col-12">

                <a class="logo " href="<?php echo e(url('/')); ?>">

                    <img src="<?php echo e(url('/')); ?>/accets/frontend/img/logo.png">

                </a>

            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-6">

                <div class="footer-title">

                    <h5>SUPPORT</h5>

                </div>

                <ul class="ul-reset footer-links">

                    <li><a href="<?php echo e(url('/')); ?>/faq">FAQs</a></li>

                    <li><a href="<?php echo e(url('/')); ?>/educational">Educational</a></li>

                    <li><a href="<?php echo e(url('/')); ?>/tutorial">Tutorial</a></li>

                </ul>



            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-6">

                 <div class="footer-title">

                    <h5>COMPANY</h5>

                </div>

                <ul class="ul-reset footer-links">

                    <li>Mon-Fri 9am to 5pm PST</li>

                    <li><a href="mailto:support@fixyourcredityourself.com">support@fixyourcredityourself.com</a></li>

                    <li><a href="tel:(022) 111-111-11">(022) 111-111-11</a></li>

                </ul>

                

            </div>

        </div>

    </div>

    <section class="footer_bottom">

        <div class="container">

            <div class="row">

                <div class="col-md-12">

                    <ul class="ul-reset footer-social">

                        <li><a href="#" target="_blank"><i class="fa fa-facebook"></i></a></li>                        

                    </ul>

                    <ul class="ul-reset footer-copy">

                        <li><a href="<?php echo e(url('/')); ?>/terms">Terms Of Use</a></li>

                        <li><a href="<?php echo e(url('/')); ?>/privacy">Privacy Policy</a></li>

                        <li>© <?php echo e(date('Y')); ?> FixYourCreditYourself.com , All rights reserved.</li>

                    </ul>

                </div>

            </div>

        </div>

    </section>

</footer>

</div>  

    
<script type="text/javascript">
    $(document).ready(function(){
        $('.alert').fadeOut(5000);
    });
</script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>

    <script src="<?php echo e(url('/')); ?>/accets/frontend/js/bootstrap.min.js"></script>   

    <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.6.0/slick.js"></script>

    <script src="<?php echo e(url('/')); ?>/accets/frontend/js/custom_js.js"></script>



<script type="text/javascript" src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>

    </body>

</html>

       

