<?php

//Front end

Route::get('/', 'LoginController@index');
Route::get('/logOut',function(){Session::forget('userLoginInfo');return redirect('/');});
Route::get('/getCreditReport','ExtApiController@credit');
Route::get('/getSCreport','ExtApiController@credit');
Route::get('/refreshThreeBReport','ExtApiController@refreshThreeBReport');
Route::post('/myfreescore/getUserRegisterResponse','MyfreescoreController@getUserRegisterResponse');

// Route::get('/invo', function () { return view('frontend.invoice'); });

Route::get('/signIn','LoginController@loginClient');
Route::post('/checkLogin','LoginController@checkLogin');
Route::get('/signUp', 'LoginController@register');
Route::post('/saveUser','LoginController@postUser');

Route::get ('/redirect/{service}','SocialAuthController@redirectToProvider');
Route::get ('/{social}/callback','SocialAuthController@handleProviderCallback');
Route::get('/forgot_password','LoginController@sendPasswordLink');
// Route::get('/reset_password','LoginController@updatePassword');
Route::post('/setPassword','LoginController@changePassword');
Route::get('/reset_password/{id}','LoginController@updatePassword');
Route::post('/forgot_password','LoginController@forgotPassword');
Route::get('/terms_condition','LoginController@terms_condition');
Route::get('/activationLink/{id}','LoginController@coActivation');
Route::get('/card_offer','LoginController@offer');

Route::group(['middleware' => ['frontAuth']], function () {

Route::get('/pdf1', function () { return view('pdf/pdf1'); });

Route::get('/score_summary','SummaryController@index');
Route::get('/resources','ResourceController@index');
Route::get('/smartCredit','CreditController@smartCredit');

Route::get('/myaccount','LoginController@profile');
Route::get('/membership','LoginController@membership');
Route::get('/smartCreditSignUp','LoginController@dashboard');
Route::get('/faq','LoginController@faq');
Route::post('/updateUser','LoginController@updateUser');
Route::post('/updateUserProfile','LoginController@updateProfile');
Route::post('/saveCreditData','LoginController@creditSignup');
Route::post('/postAddName','LoginController@postAddName');
Route::post('/deleteName','LoginController@deleteName');
Route::post('/saveUserImage','LoginController@saveUserImage');
Route::post('/deleteUserImage','LoginController@deleteUserImage');

Route::get('/account_summary','CreditController@index');
Route::get('/create_dispute','CreditController@create_dispute');
Route::get('/setDisputeSession/{id}','CreditController@setDisputeSession');
Route::get('/getDisputeReasons/{id}','CreditController@getDisputeReasons');
Route::post('/saveDisputeReason','CreditController@saveDisputeReason');
Route::post('/getAccountSummary','CreditController@getAccountSummary');

Route::get('/dispute_summary','DisputeController@index');
Route::post('/getDispute','DisputeController@getDispute');
Route::get('/getInvoice/{id}/{type}','DisputeController@getInvoice');
Route::get('/sendDisputeMail/{id}','DisputeController@sendDisputeMail');
Route::get('/deleteDispute/{id}','DisputeController@deleteDispute');
Route::post('/markLetterSent','DisputeController@markLetterSent');
Route::get('/changeStatus/{id}','DisputeController@changeStatus');
Route::get('invoice','DisputeController@invoice');
// Route::post('/getTableData','DisputeController@getTableData');

Route::get('/{type}/profile','LoginController@profile');
Route::post('/changePassword','LoginController@resetPassword');
Route::post('/updateProfilePassword','LoginController@updateProfilePassword');

Route::get('downloadExcel/{type}', 'admin\ImportExcellController@downloadExcel');
Route::post('importExcel', 'admin\ImportExcellController@importExcel');
Route::get('importExcel','admin\ImportExcellController@importExcelGet');

});



// Authentication Routes...
$this->get('login', 'Auth\LoginController@showLoginForm')->name('auth.login');
$this->post('login', 'Auth\LoginController@login')->name('auth.login');
$this->post('logout', 'Auth\LoginController@logout')->name('auth.logout');

// Change Password Routes...
$this->get('change_password', 'Auth\ChangePasswordController@showChangePasswordForm')->name('auth.change_password');
$this->patch('change_password', 'Auth\ChangePasswordController@changePassword')->name('auth.change_password');

// Password Reset Routes...
$this->get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('auth.password.reset');
$this->post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('auth.password.reset');
$this->get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
$this->post('password/reset', 'Auth\ResetPasswordController@reset')->name('auth.password.reset');

Route::get('/getCity/{id}','HomeController@getCity');
Route::group(['middleware' => ['auth']], function () {

    Route::get('/home', 'HomeController@index');
    Route::get('/admin', 'HomeController@index');
    Route::get('/admin/home', 'HomeController@index');
    Route::get('/admin/dashboard', 'HomeController@index');

    
    Route::resource('/admin/permissions', 'Admin\PermissionsController');
    Route::post('permissions_mass_destroy', ['uses' => 'admin\PermissionsController@massDestroy', 'as' => 'permissions.mass_destroy']);
    Route::resource('roles', 'Admin\RolesController');
    Route::post('roles_mass_destroy', ['uses' => 'admin\RolesController@massDestroy', 'as' => 'roles.mass_destroy']);
    Route::resource('users', 'Admin\UsersController');
    Route::post('users_mass_destroy', ['uses' => 'admin\UsersController@massDestroy', 'as' => 'users.mass_destroy']);

   

   

    // BO : Country

    Route::post("/admin/country/deleteAll", [ 'as'=>'admin.country.deleteAll','uses'=>'admin\CountryController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/country", [ 'as'=>'admin.country.index','uses'=>'admin\CountryController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/country/add", [ 'as'=>'admin.country.add','uses'=>'admin\CountryController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/country/add", [ 'as'=>'admin.country.add','uses'=>'admin\CountryController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/country/edit/{id}", [ 'as'=>'admin.country.edit','uses'=>'admin\CountryController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/country/status/{field}/{id}", [ 'as'=>'admin.country.edit','uses'=>'admin\CountryController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/country/export/{type}", [ 'as'=>'admin.country.edit','uses'=>'admin\CountryController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/country/edit", [ 'as'=>'admin.country.edit','uses'=>'admin\CountryController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/country/delete", [ 'as'=>'admin.country.delete','uses'=>'admin\CountryController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/country/view/{id}", [ 'as'=>'admin.country.edit','uses'=>'admin\CountryController@view','middleware' => ['permission:item-list']]);

     // EO : Country

    // BO : City 

    Route::post("/admin/city/deleteAll", [ 'as'=>'admin.city.deleteAll','uses'=>'admin\CityController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/city", [ 'as'=>'admin.city.index','uses'=>'admin\CityController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/city/add", [ 'as'=>'admin.city.add','uses'=>'admin\CityController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/city/add", [ 'as'=>'admin.city.add','uses'=>'admin\CityController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/city/edit/{id}", [ 'as'=>'admin.city.edit','uses'=>'admin\CityController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/city/status/{field}/{id}", [ 'as'=>'admin.city.edit','uses'=>'admin\CityController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/city/export/{type}", [ 'as'=>'admin.city.edit','uses'=>'admin\CityController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/city/edit", [ 'as'=>'admin.city.edit','uses'=>'admin\CityController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/city/delete", [ 'as'=>'admin.city.delete','uses'=>'admin\CityController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/city/view/{id}", [ 'as'=>'admin.city.edit','uses'=>'admin\CityController@view','middleware' => ['permission:item-list']]);

     // EO : City

    

    // BO : States
    Route::post("/admin/states/deleteAll", [ 'as'=>'admin.states.deleteAll','uses'=>'admin\StatesController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/states", [ 'as'=>'admin.states.index','uses'=>'admin\StatesController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/states/add", [ 'as'=>'admin.states.add','uses'=>'admin\StatesController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/states/add", [ 'as'=>'admin.states.add','uses'=>'admin\StatesController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/states/edit/{id}", [ 'as'=>'admin.states.edit','uses'=>'admin\StatesController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/states/status/{field}/{id}", [ 'as'=>'admin.states.edit','uses'=>'admin\StatesController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/states/export/{type}", [ 'as'=>'admin.states.edit','uses'=>'admin\StatesController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/states/edit", [ 'as'=>'admin.states.edit','uses'=>'admin\StatesController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/states/delete", [ 'as'=>'admin.states.delete','uses'=>'admin\StatesController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/states/view/{id}", [ 'as'=>'admin.states.edit','uses'=>'admin\StatesController@view','middleware' => ['permission:item-list']]);
    // EO : States

	// BO : Credit_plan
    Route::post("/admin/credit_plan/deleteAll", [ 'as'=>'admin.credit_plan.deleteAll','uses'=>'admin\Credit_planController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/credit_plan", [ 'as'=>'admin.credit_plan.index','uses'=>'admin\Credit_planController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/credit_plan/add", [ 'as'=>'admin.credit_plan.add','uses'=>'admin\Credit_planController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/credit_plan/add", [ 'as'=>'admin.credit_plan.add','uses'=>'admin\Credit_planController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/credit_plan/edit/{id}", [ 'as'=>'admin.credit_plan.edit','uses'=>'admin\Credit_planController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/credit_plan/status/{field}/{id}", [ 'as'=>'admin.credit_plan.edit','uses'=>'admin\Credit_planController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/credit_plan/export/{type}", [ 'as'=>'admin.credit_plan.edit','uses'=>'admin\Credit_planController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/credit_plan/edit", [ 'as'=>'admin.credit_plan.edit','uses'=>'admin\Credit_planController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/credit_plan/delete", [ 'as'=>'admin.credit_plan.delete','uses'=>'admin\Credit_planController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/credit_plan/view/{id}", [ 'as'=>'admin.credit_plan.edit','uses'=>'admin\Credit_planController@view','middleware' => ['permission:item-list']]);
    // EO : Credit_plan    

    // BO : Security_questions
    Route::post("/admin/security_questions/deleteAll", [ 'as'=>'admin.security_questions.deleteAll','uses'=>'admin\Security_questionsController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/security_questions", [ 'as'=>'admin.security_questions.index','uses'=>'admin\Security_questionsController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/security_questions/add", [ 'as'=>'admin.security_questions.add','uses'=>'admin\Security_questionsController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/security_questions/add", [ 'as'=>'admin.security_questions.add','uses'=>'admin\Security_questionsController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/security_questions/edit/{id}", [ 'as'=>'admin.security_questions.edit','uses'=>'admin\Security_questionsController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/security_questions/status/{field}/{id}", [ 'as'=>'admin.security_questions.edit','uses'=>'admin\Security_questionsController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/security_questions/export/{type}", [ 'as'=>'admin.security_questions.edit','uses'=>'admin\Security_questionsController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/security_questions/edit", [ 'as'=>'admin.security_questions.edit','uses'=>'admin\Security_questionsController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/security_questions/delete", [ 'as'=>'admin.security_questions.delete','uses'=>'admin\Security_questionsController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/security_questions/view/{id}", [ 'as'=>'admin.security_questions.edit','uses'=>'admin\Security_questionsController@view','middleware' => ['permission:item-list']]);
    // EO : Security_questions


    // BO : Dispute_master_reasons
    Route::post("/admin/dispute_master_reasons/deleteAll", [ 'as'=>'admin.dispute_master_reasons.deleteAll','uses'=>'admin\Dispute_master_reasonsController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/dispute_master_reasons", [ 'as'=>'admin.dispute_master_reasons.index','uses'=>'admin\Dispute_master_reasonsController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/dispute_master_reasons/add", [ 'as'=>'admin.dispute_master_reasons.add','uses'=>'admin\Dispute_master_reasonsController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/dispute_master_reasons/add", [ 'as'=>'admin.dispute_master_reasons.add','uses'=>'admin\Dispute_master_reasonsController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/dispute_master_reasons/edit/{id}", [ 'as'=>'admin.dispute_master_reasons.edit','uses'=>'admin\Dispute_master_reasonsController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/dispute_master_reasons/status/{field}/{id}", [ 'as'=>'admin.dispute_master_reasons.edit','uses'=>'admin\Dispute_master_reasonsController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/dispute_master_reasons/export/{type}", [ 'as'=>'admin.dispute_master_reasons.edit','uses'=>'admin\Dispute_master_reasonsController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/dispute_master_reasons/edit", [ 'as'=>'admin.dispute_master_reasons.edit','uses'=>'admin\Dispute_master_reasonsController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/dispute_master_reasons/delete", [ 'as'=>'admin.dispute_master_reasons.delete','uses'=>'admin\Dispute_master_reasonsController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/dispute_master_reasons/view/{id}", [ 'as'=>'admin.dispute_master_reasons.edit','uses'=>'admin\Dispute_master_reasonsController@view','middleware' => ['permission:item-list']]);
    // EO : Dispute_master_reasons

        // BO : Dispute_letters
    Route::post("/admin/dispute_letters/deleteAll", [ 'as'=>'admin.dispute_letters.deleteAll','uses'=>'admin\Dispute_lettersController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/dispute_letters", [ 'as'=>'admin.dispute_letters.index','uses'=>'admin\Dispute_lettersController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/dispute_letters/add", [ 'as'=>'admin.dispute_letters.add','uses'=>'admin\Dispute_lettersController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/dispute_letters/add", [ 'as'=>'admin.dispute_letters.add','uses'=>'admin\Dispute_lettersController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/dispute_letters/edit/{id}", [ 'as'=>'admin.dispute_letters.edit','uses'=>'admin\Dispute_lettersController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/dispute_letters/status/{field}/{id}", [ 'as'=>'admin.dispute_letters.edit','uses'=>'admin\Dispute_lettersController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/dispute_letters/export/{type}", [ 'as'=>'admin.dispute_letters.edit','uses'=>'admin\Dispute_lettersController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/dispute_letters/edit", [ 'as'=>'admin.dispute_letters.edit','uses'=>'admin\Dispute_lettersController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/dispute_letters/delete", [ 'as'=>'admin.dispute_letters.delete','uses'=>'admin\Dispute_lettersController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/dispute_letters/view/{id}", [ 'as'=>'admin.dispute_letters.edit','uses'=>'admin\Dispute_lettersController@view','middleware' => ['permission:item-list']]);
    // EO : Dispute_letters

    // BO : Credit_offer
    Route::post("/admin/credit_offer/deleteAll", [ 'as'=>'admin.credit_offer.deleteAll','uses'=>'admin\CreditOfferController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/credit_offer", [ 'as'=>'admin.credit_offer.index','uses'=>'admin\CreditOfferController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/credit_offer/add", [ 'as'=>'admin.credit_offer.add','uses'=>'admin\CreditOfferController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/credit_offer/add", [ 'as'=>'admin.credit_offer.add','uses'=>'admin\CreditOfferController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/credit_offer/edit/{id}", [ 'as'=>'admin.credit_offer.edit','uses'=>'admin\CreditOfferController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/credit_offer/status/{field}/{id}", [ 'as'=>'admin.credit_offer.edit','uses'=>'admin\CreditOfferController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/credit_offer/export/{type}", [ 'as'=>'admin.credit_offer.edit','uses'=>'admin\CreditOfferController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/credit_offer/edit", [ 'as'=>'admin.credit_offer.edit','uses'=>'admin\CreditOfferController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/credit_offer/delete", [ 'as'=>'admin.credit_offer.delete','uses'=>'admin\CreditOfferController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/credit_offer/view/{id}", [ 'as'=>'admin.credit_offer.edit','uses'=>'admin\CreditOfferController@view','middleware' => ['permission:item-list']]);
    // EO : Credit_offer

    // @@@@@#####@@@@@





















	// BO : Register_user
    Route::post("/admin/register_user/deleteAll", [ 'as'=>'admin.register_user.deleteAll','uses'=>'admin\Register_userController@deleteAll','middleware' => ['permission:item-delete']]);
    Route::get("/admin/register_user", [ 'as'=>'admin.register_user.index','uses'=>'admin\Register_userController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);
    Route::get("/admin/register_user/add", [ 'as'=>'admin.register_user.add','uses'=>'admin\Register_userController@getAdd','middleware' => ['permission:item-create']]);
    Route::post("/admin/register_user/add", [ 'as'=>'admin.register_user.add','uses'=>'admin\Register_userController@postAdd','middleware' => ['permission:item-create']]);
    Route::get("/admin/register_user/edit/{id}", [ 'as'=>'admin.register_user.edit','uses'=>'admin\Register_userController@getEdit','middleware' => ['permission:item-edit']]);
    Route::get("/admin/register_user/status/{field}/{id}", [ 'as'=>'admin.register_user.edit','uses'=>'admin\Register_userController@status','middleware' => ['permission:item-edit']]);
    Route::get("/admin/register_user/export/{type}", [ 'as'=>'admin.register_user.edit','uses'=>'admin\Register_userController@getExport','middleware' => ['permission:item-list']]);
    Route::post("/admin/register_user/edit", [ 'as'=>'admin.register_user.edit','uses'=>'admin\Register_userController@postEdit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/register_user/delete", [ 'as'=>'admin.register_user.delete','uses'=>'admin\Register_userController@delete','middleware' => ['permission:item-delete']]);
    Route::get("/admin/register_user/view/{id}", [ 'as'=>'admin.register_user.edit','uses'=>'admin\Register_userController@view','middleware' => ['permission:item-list']]);
    // EO : Register_user


    //BO :permissions
     Route::post("/admin/permissions/mass_destroy", [ 'as'=>'admin.permissions.deleteAll','uses'=>'admin\PermissionsController@massDestroy','middleware' => ['permission:item-delete']]);

    Route::get("/admin/permissions", [ 'as'=>'admin.permissions.index','uses'=>'admin\PermissionsController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);

    Route::get("/admin/permissions/create", [ 'as'=>'admin.permissions.create','uses'=>'admin\PermissionsController@create','middleware' => ['permission:item-create']]);

    Route::post("/admin/permissions/store", [ 'as'=>'admin.permissions.store','uses'=>'admin\PermissionsController@store','middleware' => ['permission:item-create']]);

    Route::get("/admin/permissions/edit/{id}", [ 'as'=>'admin.permissions.edit','uses'=>'admin\PermissionsController@edit','middleware' => ['permission:item-edit']]);

    Route::post("/admin/permissions/update/{id}", [ 'as'=>'admin.permissions.update','uses'=>'admin\PermissionsController@update','middleware' => ['permission:item-edit']]);

    Route::delete("/admin/permissions/destroy/{id}", [ 'as'=>'admin.permissions.delete','uses'=>'admin\PermissionsController@destroy','middleware' => ['permission:item-delete']]);
// EO:permissions

  //BO :users

     Route::post("/admin/users/mass_destroy", [ 'as'=>'admin.users.deleteAll','uses'=>'admin\UsersController@massDestroy','middleware' => ['permission:item-delete']]);

    Route::get("/admin/users", [ 'as'=>'admin.users.index','uses'=>'admin\UsersController@index','middleware' => ['permission:item-list|item-create|item-edit|item-delete']]);

    Route::get("/admin/users/create", [ 'as'=>'admin.users.create','uses'=>'admin\UsersController@create','middleware' => ['permission:item-create']]);

    Route::post("/admin/users/store", [ 'as'=>'admin.users.store','uses'=>'admin\UsersController@store','middleware' => ['permission:item-create']]);

    Route::get("/admin/users/edit/{id}", [ 'as'=>'admin.users.edit','uses'=>'admin\UsersController@edit','middleware' => ['permission:item-edit']]);

    Route::post("/admin/users/update/{id}", [ 'as'=>'admin.users.update','uses'=>'admin\UsersController@update','middleware' => ['permission:item-edit']]);
    Route::delete("/admin/users/destroy/{id}", [ 'as'=>'admin.users.delete','uses'=>'admin\UsersController@destroy','middleware' => ['permission:item-delete']]);

// EO:users

//BO :roles
    Route::post("/admin/roles/mass_destroy", [ 'as'=>'admin.roles.deleteAll','uses'=>'admin\RolesController@massDestroy','middleware' => ['permission:item-delete']]);

    Route::get("/admin/roles", [ 'as'=>'admin.roles.index','uses'=>'admin\RolesController@index','middleware' => ['permission:users_master|item-list|item-create|item-edit|item-delete']]);

    Route::get("/admin/roles/create", [ 'as'=>'admin.roles.create','uses'=>'admin\RolesController@create','middleware' => ['permission:item-create']]);

    Route::post("/admin/roles/store", [ 'as'=>'admin.roles.store','uses'=>'admin\RolesController@store','middleware' => ['permission:item-create']]);

    Route::get("/admin/roles/edit/{id}", [ 'as'=>'admin.roles.edit','uses'=>'admin\RolesController@edit','middleware' => ['permission:item-edit']]);
    Route::post("/admin/roles/update/{id}", [ 'as'=>'admin.roles.update','uses'=>'admin\RolesController@update','middleware' => ['permission:item-edit']]);
    Route::delete("/admin/roles/destroy/{id}", [ 'as'=>'admin.roles.delete','uses'=>'admin\RolesController@destroy','middleware' => ['permission:item-delete']]);
    Route::get('/admin/roles/{id}',['as'=>'admin.roles.show','uses'=>'admin\RolesController@show']);
// EO:roles

});
