@extends('frontend.frontMaster')

@section('content')

<section class="histroy_scores">
	<div class="container">
		<div class="row">
			<div class="col-lg-8 col-md-8 col-sm-12 col-12">
				<div class="row">
					<div class="col-lg-6 co-md-6 col-sm-12 col-6">
						<p class="score_heading">Scores</p>
					</div>
					<div class="col-lg-6 co-md-6 col-sm-12 col-6 text-right"></div>
				</div>
				<div class="sec1">
		     		<div class="container">    
		               <div class="row slide1">
		               	@foreach($score as $value)
		                    <div class="col-md-4 PLR5">
			                    <div class="score_slider_item">
									<div class="card">
										<div class="card_body">
											<div class="card_title"><?php if($value->source_type=='1'){echo 'TRANSUNION';}else if($value->source_type=='2'){echo 'EXPERIAN';}else{echo 'EQUIFAX';}?></div>
											<div class="card_chart">
												<img class="score_img" src="{{url('/')}}/accets/frontend/img/score-range-blue-6.png">
												<div class="card_score card-score-blue">{{$value->riskScore}}</div>
											</div>
											<small class="text-muted">as of <em>{{date('m/d/y',strtotime($value->created))}}</em></small>
										</div>
										<div class="card_footer">
											<span class="card_arrow card_arrow-up">
							                    <i class="fa fa-long-arrow-up"></i>
							                </span>
								            <b class="card_change">{{$value->rise}}</b>
								            <small class="text-muted"><em style="">since  {{date('m/d/y',strtotime($value->since))}}</em></small>
										</div>
									</div>
								</div>
							</div>
						@endforeach
		               </div>
		            </div>
		   		</div>`
			</div>
			<div class="col-lg-4 col-md-4 col-sm-12 col-12">
				<div class="row">
					<div class="col-lg-6 co-md-6 col-sm-12 col-12">
						<p class="score_heading">Personal Offers</p>
					</div>
					<div class="col-lg-6 co-md-6 col-sm-12 col-12 text-right">
						<a class="arrow" href="{{url('/')}}/card_offer"><i class="fa fa-arrow-right"></i></a>
					</div>
					<div class="col-lg-12 col-md-12 col-sm-12 col-12 ">	
						<div class="card">
							<div class="card-body">
						        <div class="card-image text-center"> 
						        	<img src="{{url('/')}}/accets/frontend/img/master_card.png">
						        </div>
						        <div class="card_link">
							        <a class="card-title" href="javascript:" target="_blank"> Capital One® Secured MasterCard® </a>
							    </div>
						    </div>
						    <div class="card-footer">
						    	<span class="float-left">Approval Odds</span>
						    	<span class="float-right"><a href="#" class="approval-odds--excellent">Excellent</a></span>
						    </div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<section class="history_graph">
	<div class="container">
		<div class="row">
			<div class="col-lg-8 col-md-8 col-sm-12 col-12">
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12 col-12">
						<h5 class="section__title">History</h5>
					</div>
					<div class="col-lg-12 col-md-12 col-sm-12 col-12 chart_bg">	
						<ul class="nav nav-tabs" role="tablist">
						    <li class="nav-item">
						      	<a class="nav-link active" data-toggle="tab" href="#Transunion">Transunion</a>
						    </li>
						    <li class="nav-item">
						      	<a class="nav-link" data-toggle="tab" href="#Experian">Experian</a>
						    </li>
						    <li class="nav-item">
						      	<a class="nav-link" data-toggle="tab" href="#Equifax">Equifax</a>
						    </li>
						</ul>
					    <div class="tab-content">
						    <div id="Transunion" class="container tab-pane active"><br>  	
								<div class="wrapper">
									<canvas id="myChart" width="800" height="500"></canvas>
								</div>
						    </div>
						    <div id="Experian" class="container tab-pane fade"><br>
						      	<div class="wrapper">
									<canvas id="myChart1" width="800" height="500"></canvas>
								</div>
						    </div>
						    <div id="Equifax" class="container tab-pane fade"><br>
						      	<div class="wrapper">
									<canvas id="myChart2" width="800" height="500"></canvas>
								</div>
						    </div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-lg-4 col-md-4 col-sm-12 col-12"></div>
		</div>
	</div>
</section>
<section class="report_details">
	<div class="container">
		<div class="row">
			<div class="col-lg-8 col-md-8 col-sm-12 col-12 P0 table_smm">
				<table class="table table-bordered text-center border-style-hidden">
		            <thead>
		                <tr>
		                    <th scope="column">
		                        <span class="d-none d-sm-block">Date</span>
		                        <label class="d-block d-sm-none">Date</label>
		                    </th>
		                    <th scope="column">
		                        <span class="d-none d-sm-block">Transunion</span>
		                        <label class="d-block d-sm-none">TRU</label>
		                    </th>
		                    <th scope="column">
		                        <span class="d-none d-sm-block">Experian</span>
		                        <label class="d-block d-sm-none">EXP</label>
		                    </th>
		                    <th scope="column">
		                        <span class="d-none d-sm-block">Equifax</span>
		                        <label class="d-block d-sm-none">EQ</label>
		                    </th>
		                    <th scope="column"></th>
		                </tr>
		            </thead>
		            <tbody>
		            	<?php foreach($table as $value){?>
	                    <tr>
	                    	<?php foreach($value as $key=>$val){?>
	                        @if($key==0)<th>{{date('m/d/Y',strtotime($val->created))}}</th>@endif
	                        <td>{{$val->riskScore}}</td>
	                    	<?php }?>
	                        <td><a href="#" target="_blank">View</a></td>
	                    </tr>
	                    <?php }?>
		            </tbody>
		        </table>
			</div>
			<div class="col-lg-4 col-md-4 col-sm-12 col-12"></div>
		</div>
</section>


<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"></script>
<script type="text/javascript">
    var ctx = document.getElementById('myChart').getContext("2d");
	var gradientStroke = ctx.createLinearGradient(500, 0, 100, 0);
	gradientStroke.addColorStop(0, '#80b6f4');
	gradientStroke.addColorStop(1, '#8080f4');
	var gradientFill = ctx.createLinearGradient(500, 0, 100, 0);
	gradientFill.addColorStop(0, "rgba(128, 182, 244, 0.6)");
	gradientFill.addColorStop(1, "rgba(106, 90, 205, 0.6)");
	var myChart = new Chart(ctx, {
	    type: 'line',
	    data: {
	        labels: [ "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV"],
	        datasets: [{
	            label: "Data",
	            borderColor: gradientStroke,
	            pointBorderColor: gradientStroke,
	            pointBackgroundColor: gradientStroke,
	           	pointHoverBackgroundColor: gradientStroke,
	            pointHoverBorderColor: gradientStroke,
	            pointBorderWidth: 6,
	            pointHoverRadius: 6,
	            pointHoverBorderWidth: 1,
	            pointRadius: 3,
	            fill: true,
	            backgroundColor: gradientFill,
	            borderWidth: 4,
	            data: [100, 120, 150, 170, 180, 170, 160]
	        }]
	    },
	    options: {
	        legend: {
	            position: "bottom"
	        },
	        scales: {
	            yAxes: [{
	                ticks: {
	                    fontColor: "rgba(0,0,0,0.5)",
	                    fontStyle: "bold",
	                    beginAtZero: false,
	                    maxTicksLimit: 5,
	                    padding: 20
	                },
	                gridLines: {
	                    drawTicks: false,
	                    display: false
	                }
	            }],
	            xAxes: [{
	                gridLines: {
	                    zeroLineColor: "transparent"
	                },
	                ticks: {
	                    padding: 20,
	                    fontColor: "rgba(0,0,0,0.5)",
	                    fontStyle: "bold"
	                }
	            }]
	        }
	    }
	});
    

    var ctx = document.getElementById('myChart1').getContext("2d");
	var gradientStroke = ctx.createLinearGradient(500, 0, 100, 0);
	gradientStroke.addColorStop(0, '#80b6f4');
	gradientStroke.addColorStop(1, '#8080f4');
	var gradientFill = ctx.createLinearGradient(500, 0, 100, 0);
	gradientFill.addColorStop(0, "rgba(128, 182, 244, 0.6)");
	gradientFill.addColorStop(1, "rgba(106, 90, 205, 0.6)");
	var myChart = new Chart(ctx, {
	    type: 'line',
	    data: {
	        labels: [ "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV"],
	        datasets: [{
	            label: "Data",
	            borderColor: gradientStroke,
	            pointBorderColor: gradientStroke,
	            pointBackgroundColor: gradientStroke,
	           	pointHoverBackgroundColor: gradientStroke,
	            pointHoverBorderColor: gradientStroke,
	            pointBorderWidth: 6,
	            pointHoverRadius: 6,
	            pointHoverBorderWidth: 1,
	            pointRadius: 3,
	            fill: true,
	            backgroundColor: gradientFill,
	            borderWidth: 4,
	            data: [100, 120, 150, 170, 180, 170, 160]
	        }]
	    },
	    options: {
	        legend: {
	            position: "bottom"
	        },
	        scales: {
	            yAxes: [{
	                ticks: {
	                    fontColor: "rgba(0,0,0,0.5)",
	                    fontStyle: "bold",
	                    beginAtZero: false,
	                    maxTicksLimit: 5,
	                    padding: 20
	                },
	                gridLines: {
	                    drawTicks: false,
	                    display: false
	                }
	            }],
	            xAxes: [{
	                gridLines: {
	                    zeroLineColor: "transparent"
	                },
	                ticks: {
	                    padding: 20,
	                    fontColor: "rgba(0,0,0,0.5)",
	                    fontStyle: "bold"
	                }
	            }]
	        }
	    }
	});
    

    var ctx = document.getElementById('myChart2').getContext("2d");
	var gradientStroke = ctx.createLinearGradient(500, 0, 100, 0);
	gradientStroke.addColorStop(0, '#80b6f4');
	gradientStroke.addColorStop(1, '#8080f4');
	var gradientFill = ctx.createLinearGradient(500, 0, 100, 0);
	gradientFill.addColorStop(0, "rgba(128, 182, 244, 0.6)");
	gradientFill.addColorStop(1, "rgba(106, 90, 205, 0.6)");
	var myChart = new Chart(ctx, {
	    type: 'line',
	    data: {
	        labels: [ "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV"],
	        datasets: [{
	            label: "Data",
	            borderColor: gradientStroke,
	            pointBorderColor: gradientStroke,
	            pointBackgroundColor: gradientStroke,
	           	pointHoverBackgroundColor: gradientStroke,
	            pointHoverBorderColor: gradientStroke,
	            pointBorderWidth: 6,
	            pointHoverRadius: 6,
	            pointHoverBorderWidth: 1,
	            pointRadius: 3,
	            fill: true,
	            backgroundColor: gradientFill,
	            borderWidth: 4,
	            data: [100, 120, 150, 170, 180, 170, 160]
	        }]
	    },
	    options: {
	        legend: {
	            position: "bottom"
	        },
	        scales: {
	            yAxes: [{
	                ticks: {
	                    fontColor: "rgba(0,0,0,0.5)",
	                    fontStyle: "bold",
	                    beginAtZero: false,
	                    maxTicksLimit: 5,
	                    padding: 20
	                },
	                gridLines: {
	                    drawTicks: false,
	                    display: false
	                }
	            }],
	            xAxes: [{
	                gridLines: {
	                    zeroLineColor: "transparent"
	                },
	                ticks: {
	                    padding: 20,
	                    fontColor: "rgba(0,0,0,0.5)",
	                    fontStyle: "bold"
	                }
	            }]
	        }
	    }
	});
    	
</script>

@endsection