@extends('frontend.frontMaster')
@section('content')
<section>
	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 col-12 P0">
				<div class="alert alert-success alert-message">
				    <p><span class="badge badge-primary">11</span> days until next report update. <a href="#" class="Dismiss_alert">Dismiss</a></p>
				</div>
			</div>
		</div>
	</div>
</section>
<section class="score_slider">
	<div class="container">
		<div class="row">
			<div class="col-lg-8 col-md-8 col-sm-12 col-12">
				<div class="row">
					<div class="col-lg-6 co-md-6 col-sm-12 col-6">
						<p class="score_heading">Scores</p>
					</div>
					<div class="col-lg-6 co-md-6 col-sm-12 col-6 text-right">
						<a href="{{url('/')}}/summary" class="arrow"><i class="fa fa-arrow-right"></i></a>
					</div>
				</div>
				<div class="sec1">
		     		<div class="container">    
		               <div class="row slide1">
		               		@foreach($score as $value)
		                    <div class="col-md-4">
			                    <div class="score_slider_item">
									<div class="card">
										<div class="card_body">
											<div class="card_title"><?php if($value->source_type=='1'){echo 'TRANSUNION';}else if($value->source_type=='2'){echo 'EXPERIAN';}else{echo 'EQUIFAX';}?></div>
											<div class="card_chart">
												<div id="container" style="height: 150px;"></div>
												<!-- <img class="score_img" src="{{url('/')}}/accets/frontend/img/score-range-blue-6.png">
 -->
												<div class="card_score card_green">{{$value->riskScore}}</div>
											</div>
											<small class="text-muted">as of <em>{{date('m/d/y',strtotime($value->created))}}</em></small>
										</div>
										<div class="card_footer">
											<span class="card_arrow card_arrow-up">
							                    <i class="fa fa-long-arrow-up"></i>
							                </span>
								            <b class="card_change">{{$value->rise}}</b>
								            <small class="text-muted"><em style="">since  {{date('m/d/y',strtotime($value->since))}}</em></small>
										</div>
									</div>
								</div>
							</div>
							@endforeach
		                    <!-- <div class="col-md-4">

			                    <div class="score_slider_item">

									<div class="card">

										<div class="card_body">

											<div class="card_title">Experian</div>

											<div class="card_chart">

												<img class="score_img" src="{{url('/')}}/accets/frontend/img/score-range-green-7.png">

												<div class="card_score card_green">681</div>

											</div>

											<small class="text-muted">as of <em>06/23/20</em></small>

										</div>

										<div class="card_footer">

											<span class="card_arrow card_arrow-up">

							                    <i class="fa fa-long-arrow-up"></i>

							                </span>

								            <b class="card_change">33</b>

								            <small class="text-muted"><em style="">since  05/16/20</em></small>

										</div>

									</div>

								</div>

							</div>

		                    <div class="col-md-4">

			                    <div class="score_slider_item">

									<div class="card">

										<div class="card_body">

											<div class="card_title">EQUIFAX</div>

											<div class="card_chart">

												<img class="score_img" src="{{url('/')}}/accets/frontend/img/score-range-blue-6.png">

												<div class="card_score card_blue">597</div>

											</div>

											<small class="text-muted">as of <em>06/23/20</em></small>

										</div>

										<div class="card_footer">

											<span class="card_arrow card_arrow-up">

							                    <i class="fa fa-long-arrow-up"></i>

							                </span>

								            <b class="card_change">124</b>

								            <small class="text-muted"><em style="">since  05/16/20</em></small>

										</div>

									</div>

								</div>

							</div> -->

		               </div>
		            </div>
		   		</div>
			</div>
			<div class="col-lg-4 col-md-4 col-sm-12 col-12">
				<div class="row">
					<div class="col-lg-6 co-md-6 col-sm-12 col-12">
						<p class="score_heading">Tutorials</p>
					</div>
					<div class="col-lg-6 co-md-6 col-sm-12 col-12 text-right">
						<a class="arrow" href="{{url('/')}}/resources"><i class="fa fa-arrow-right"></i></a>
					</div>
					<div class="col-lg-12 col-md-12 col-sm-12 col-12 ">	
						<div class="card">
							<div class="card-body">
						        <div class="card-image"> 
						        	<div class="card-title">Tutorial 1</div>
						        	<div class="customer-logos slider">
										<div class="slide">
											<iframe  src="https://www.youtube.com/embed/cWNEZLbP9Lk" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
										</div>
									</div>
						        </div>
						        <h6 class="card-description m-0">Your Account Profile</h6>
						    </div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<section id="tabs" class="project-tab">
    <div class="container">
        <div class="row">
            <div class="col-md-8 col-lg-8 col-sm-12 col-12">
            	<div class="row">
					<div class="col-lg-4 co-md-3 col-sm-3 col-3">
						<p class="score_heading">Scores</p>
					</div>
					<div class="col-lg-7 col-md-7 col-sm-8 col-8 P0">
		                <nav>
		                    <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
		                        <a class="nav-item nav-link active text-right" id="nav-home-tab" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true">Accounts </a>
		                        <a class="nav-item nav-link text-right" id="nav-profile-tab" data-toggle="tab" href="#nav-profile" role="tab" aria-controls="nav-profile" aria-selected="false"> Public Records</a>
		                        <a class="nav-item nav-link text-right" id="nav-contact-tab" data-toggle="tab" href="#nav-contact" role="tab" aria-controls="nav-contact" aria-selected="false"> Inquiries</a>

		                    </div>

		                </nav>

		            </div>

		            <div class="col-lg-1 co-md-2 col-sm-1 col-1 text-right">

						<a href="{{url('/')}}/account_summary" class="arrow"><i class="fa fa-arrow-right"></i></a>

					</div>

		            <div class="col-lg-12 col-md-12 col-sm-12 col-12">

		                <div class="tab-content" id="nav-tabContent">

		                    <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">

		                        <table class="table table-bordered table_bg table-status" cellspacing="0">

		                            <thead>

		                                <tr>

		                                    <th scope="col"></th>

								            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Transunion</span><span class="d-block d-sm-none">TRU</span></th>

								            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Experian</span><span class="d-block d-sm-none">EXP</span></th>

								            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Equifax</span><span class="d-block d-sm-none">EQ</span></th>

								            <th scope="col"> </th>

		                                </tr>

		                            </thead>

		                            <tbody>

		                                <tr class="tr-success1">

		                                    <th class="scre_clr">Positive</th>

		                                    <td class="score_qty">{{$transPos}}</td>

		                                    <td class="score_qty">{{$expPos}}</td>

		                                    <td class="score_qty">{{$equPos}}</td>
		                                    <td class="score_qty">
							                    <a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Open &amp; closed accounts in good standing. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Positive"><i class="fa  fa-info-circle"></i></a>
							                </td>
		                                   
		                                </tr>

		                                <tr class="tr-success1">

		                                    <th class="scre_clr">Repaired</th>

		                                    <td class="score_qty">0</td>

		                                    <td class="score_qty">0</td>

		                                    <td class="score_qty">0</td>

		                                    <td class="score_qty">
		                                    	<a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Positive accounts that previously contained negative information. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Repaired"><i class="fa  fa-info-circle"></i></a>
		                                    </td>

		                                </tr>

		                                <tr class="tr-success1">

		                                    <th class="scre_clr">Deleted</th>

		                                    <td class="score_qty">0</td>

		                                    <td class="score_qty">0</td>

		                                    <td class="score_qty">0</td>

		                                    <td class="score_qty"><a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Accounts that were removed from your credit report. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Deleted" aria-describedby="popover395943"><i class="fa  fa-info-circle"></i></a></td>

		                                </tr>

		                                <tr class="tr-warning1">

		                                    <th class="scre_clr">Disputing</th>

		                                    <td class="score_qty">0</td>

		                                    <td class="score_qty">0</td>

		                                    <td class="score_qty">0</td>

		                                    <td class="score_qty"><a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Accounts currently being disputed and are awaiting results. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Disputing" aria-describedby="popover482554"><i class="fa  fa-info-circle"></i></a></td>

		                                </tr>

		                                <tr class="tr-danger1">

		                                    <th class="scre_clr">Negative</th>

		                                    <td class="score_qty">{{$transNig}}</td>

		                                    <td class="score_qty">{{$expNig}}</td>

		                                    <td class="score_qty">{{$equNig}}</td>

		                                    <td class="score_qty">
		                                    	<a data-class="dynamic-class" data-content="Accounts containing negative information and lowering your credit score. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Negative" aria-describedby="popover837384"><i class="fa  fa-bolt"></i></a>
		                                    	<!-- <a href="javascript:;" title="Negative" data-toggle="popover" data-placement="top" data-content="Accounts containing negative information and lowering your credit score." ><i class="fa fa-bolt"></i></a>
 -->
		                                    </td>

		                                </tr>

		                            </tbody>

		                        </table>

		                    </div>

		                    <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">

		                        <table class="table table-bordered table_bg table-status" cellspacing="0">

		                            <thead>

		                                <tr>

		                                    <th scope="col"></th>

								            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Transunion</span><span class="d-block d-sm-none">TRU</span></th>

								            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Experian</span><span class="d-block d-sm-none">EXP</span></th>

								            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Equifax</span><span class="d-block d-sm-none">EQ</span></th>

								            <th scope="col"> </th>

		                                </tr>

		                            </thead>

		                            <tbody>

		                                <tr class="tr-success1">

		                                    <td class="scre_clr">Positive</td>

		                                    <td class="score_qty">8</td>

		                                    <td class="score_qty">9</td>

		                                    <td class="score_qty">2</td>

		                                    <td class="score_qty">
		                                    	<a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Open &amp; closed accounts in good standing. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Positive"><i class="fa  fa-info-circle"></i></a>
		                                    </td>

		                                </tr>

		                                <tr class="tr-success">

		                                    <td class="scre_clr">Repaired</td>

		                                    <td class="score_qty">8</td>

		                                    <td class="score_qty">9</td>

		                                    <td class="score_qty">2</td>

		                                    <td class="score_qty"><a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Positive accounts that previously contained negative information. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Repaired"><i class="fa  fa-info-circle"></i></a></td>

		                                </tr>

		                                <tr class="tr-success">

		                                    <td class="scre_clr">Deleted</td>

		                                    <td class="score_qty">8</td>

		                                    <td class="score_qty">9</td>

		                                    <td class="score_qty">2</td>

		                                    <td class="score_qty"><a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Accounts that were removed from your credit report. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Deleted" aria-describedby="popover395943"><i class="fa  fa-info-circle"></i></a></td>

		                                </tr>

		                                <tr class="tr-warning">

		                                    <td class="scre_clr">Disputing</td>

		                                    <td class="score_qty">8</td>

		                                    <td class="score_qty">9</td>

		                                    <td class="score_qty">2</td>

		                                    <td class="score_qty"><a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Accounts currently being disputed and are awaiting results. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Disputing" aria-describedby="popover482554"><i class="fa  fa-info-circle"></i></a></td>

		                                </tr>

		                                <tr class="tr-danger">

		                                    <td class="scre_clr">Negative</td>

		                                    <td class="score_qty">8</td>

		                                    <td class="score_qty">9</td>

		                                    <td class="score_qty">2</td>

		                                    <td class="score_qty"><a data-class="dynamic-class" data-content="Accounts containing negative information and lowering your credit score. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Negative" aria-describedby="popover837384"><i class="fa  fa-bolt"></i></a></td>

		                                </tr>

		                            </tbody>

		                        </table>

		                    </div>

		                    <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab">

		                        <table class="table table-bordered table_bg table-status" cellspacing="0">

		                            <thead>

		                                <tr>

		                                    <th scope="col"></th>

								            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Transunion</span><span class="d-block d-sm-none">TRU</span></th>

								            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Experian</span><span class="d-block d-sm-none">EXP</span></th>

								            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Equifax</span><span class="d-block d-sm-none">EQ</span></th>

								            <th scope="col"> </th>

		                                </tr>

		                            </thead>

		                            <tbody>

		                                <tr class="tr-success1">

		                                    <td class="scre_clr">Positive</td>

		                                    <td class="score_qty">8</td>

		                                    <td class="score_qty">9</td>

		                                    <td class="score_qty">2</td>

		                                    <td class="score_qty"><a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Open &amp; closed accounts in good standing. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Positive"><i class="fa  fa-info-circle"></i></a></td>

		                                </tr>

		                                <tr class="tr-success">

		                                    <td class="scre_clr">Repaired</td>

		                                    <td class="score_qty">8</td>

		                                    <td class="score_qty">9</td>

		                                    <td class="score_qty">2</td>

		                                    <td class="score_qty"><a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Positive accounts that previously contained negative information. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Repaired"><i class="fa  fa-info-circle"></i></a></td>

		                                </tr>

		                                <tr class="tr-success">

		                                    <td class="scre_clr">Deleted</td>

		                                    <td class="score_qty">8</td>

		                                    <td class="score_qty">9</td>

		                                    <td class="score_qty">2</td>

		                                    <td class="score_qty"><a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Accounts that were removed from your credit report. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Deleted" aria-describedby="popover395943"><i class="fa  fa-info-circle"></i></a></td>

		                                </tr>

		                                <tr class="tr-warning">

		                                    <td class="scre_clr">Disputing</td>

		                                    <td class="score_qty">8</td>

		                                    <td class="score_qty">9</td>

		                                    <td class="score_qty">2</td>

		                                    <td class="score_qty"><a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Accounts currently being disputed and are awaiting results. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Disputing" aria-describedby="popover482554"><i class="fa  fa-info-circle"></i></a></td>

		                                </tr>
		                                <tr class="tr-danger">
		                                    <td class="scre_clr">Negative</td>
		                                    <td class="score_qty">8</td>
		                                    <td class="score_qty">9</td>
		                                    <td class="score_qty">2</td>
		                                    <td class="score_qty"><a data-class="dynamic-class" data-content="Accounts containing negative information and lowering your credit score. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Negative" aria-describedby="popover837384"><i class="fa  fa-bolt"></i></a></td>
		                                </tr>

		                            </tbody>

		                        </table>

		                    </div>

		                </div>

		            </div>

		            <div class="col-lg-12 col-md-12 col-sm-12 col-12 text-right">

            			<a href="#" class="create_btn" data-toggle="modal" data-target="#myModal">Create Dispute Letter <i class="fa fa-bolt" aria-hidden="true"></i></a>

            		</div>

	            </div>

            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 col-12">

            	<div class="row">

	            	<div class="col-lg-8 co-md-6 col-sm-12 col-12">

						<p class="score_heading">Personal Offers</p>

					</div>

					<div class="col-lg-4 co-md-6 col-sm-12 col-12 text-right">

						<a class="arrow"><i class="fa fa-arrow-right"></i></a>

					</div>  

					<div class="col-lg-12 col-md-12 col-sm-12 col-12">

						<div class="card">

							<div class="card-body">

						        <div class="card-image"> 

						        	<img src="{{url('/')}}/accets/frontend/img/master_card.png">

						        </div>

						        <a class="card-title" href="javascript:;" target="_blank"> Capital One® Secured MasterCard® </a>

						    </div>

						    <div class="card-footer">

						    	<span class="float-left">Approval Odds</span>

						    	<span class="float-right"><a href="javascript:;">Excellent</a></span>

						    </div>

						</div>

					</div>

				</div>

            </div>

        </div>

    </div>

</section>

<section class="Dispute">

	<div class="container">

		<div class="row">

			<div class="col-lg-8 col-md-8 col-sm-12 col-12">

				<div class="row">

					<div class="col-lg-6 co-md-6 col-sm-12 col-12">

						<p class="score_heading">Dispute Letters</p>

					</div>

					<div class="col-lg-6 co-md-6 col-sm-12 col-12 text-right">

						<a href="{{url('/')}}/dispute_summary" class="arrow"><i class="fa fa-arrow-right"></i></a>

					</div>

					<div class="col-sm-12 col-lg-12 col-md-12 col-12">

						<table class="table table-bordered text-center table-status credit-overview-table">

						    <thead>

						        <tr>

						            <th scope="col"></th>

						            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Transunion</span><span class="d-block d-sm-none">TRU</span></th>

						            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Experian</span><span class="d-block d-sm-none">EXP</span></th>

						            <th scope="col"> <span class="d-none d-sm-block text-uppercase">Equifax</span><span class="d-block d-sm-none">EQ</span></th>

						            <th scope="col"> </th>

						        </tr>

						    </thead>

						    <tbody>

					            <tr class="">

					                <th class="text-left" scope="row"> Completed</th>

					                <td>{{$truCmp}}</td>

					                <td>{{$expCmp}}</td>

					                <td>{{$equCmp}}</td>

					                <td>

					                    <a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Dispute letters sent to credit bureaus and results have been received. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Completed"><i class="fa  fa-info-circle"></i></a>

					                </td>

					            </tr>

					            <tr class="">

					                <th class="text-left" scope="row"> Sent</th>

					                <td>{{$truSnt}}</td>

					                <td>{{$expSnt}}</td>

					                <td>{{$equSnt}}</td>

					                <td>

					                    <a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Dispute letters sent to credit bureaus but still awaiting results. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Sent"><i class="fa  fa-info-circle"></i></a>

					                </td>

					            </tr>

					            <tr class="">

					                <th class="text-left" scope="row"> Pending</th>

					                <td>{{$truPnd}}</td>

					                <td>{{$expPnd}}</td>

					                <td>{{$equPnd}}</td>

					                <td>

					                    <a class="btn btn-xs btn-icon btn-light  btn-round" data-class="dynamic-class" data-content="Disputes letters created but not marked as sent yet. " data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="Pending"><i class="fa  fa-info-circle"></i></a>

					                </td>

					            </tr>

							</tbody>

						</table>

					</div>

					<div class="col-lg-12 col-md-12 col-sm-12 col-12 text-right">

            			<a href="{{url('/')}}/dispute_summary" class="create_btn">Send Dispute Letter <i class="fa fa-envelope" aria-hidden="true"></i></a>

            		</div>

				</div>

			</div>

			<div class="col-lg-4 col-md-4 col-sm-12 col-12">

				<div class="row">

					<div class="col-lg-6 co-md-6 col-sm-12 col-12">

						<p class="score_heading">My Account</p>

					</div>

					<div class="col-lg-6 co-md-6 col-sm-12 col-12 text-right">

						<a class="arrow" href="{{url('/')}}/myaccount"><i class="fa fa-arrow-right"></i></a>

					</div>

					<div class="col-lg-12 col-md-12 col-sm-12 col-12 ">	

				        <div class="section_content card">

		                    <ul class="me_list">

		                        <li>

		                            <h5>{{$user->first_name}} {{$user->last_name}}</h5>

		                        </li>

		                        <li>{{$user->email}}</li>

		                        <li>

		                            <p>

		                                {{$user->address}}

		                                <br>

		                                {{$user->state}} {{$user->pincode}}

		                            </p>

		                        </li>

		                    </ul>

		                </div>

				    </div>	

				</div>

			</div>

		</div>

	</div>

</section>


<script src="{{url('/')}}/accets/frontend/js/highcharts.js"></script>
<script src="{{url('/')}}/accets/frontend/js/highcharts-more.js"></script>
<script src="{{url('/')}}/accets/frontend/js//solid-gauge.js"></script>
<div class="modal" id="myModal">
    <div class="modal-dialog">
      	<div class="modal-content">
        <!-- Modal Header -->
	        <div class="modal-header">
	          	<h4 class="modal-title">Create Dispute Letter</h4>
	          	<button type="button" class="close" data-dismiss="modal">&times;</button>
	        </div>
	        <!-- Modal body -->
	        <div class="modal-body text-center">
	         	<p class=" pb-2">
	            	Create a dispute letter for each bureau.
	            	<br>Select a credit bureau to begin:
	        	</p>
	        	<a class=" btn MT10 btn-primary w-100" href="javascript:;" onclick="createLetter('1')">Transunion</a>
	        	<a class=" btn MT10 btn-primary w-100" href="javascript:;" onclick="createLetter('2')">Experian</a>
	        	<a class=" btn MT10 btn-primary w-100" href="javascript:;" onclick="createLetter('3')">Equifax</a>
	        </div>
	        <!-- Modal footer -->
	        <div class="modal-footer"></div>
      	</div>
    </div>
</div>



<div class="modal" id="Negative">
    <div class="modal-dialog">
      	<div class="modal-content">
	        <!-- Modal Header -->
	        <!-- Modal body -->
	        <div class="modal-body text-center">
	        	<div class="col-lg-12 col-md-12 col-sm-12 col-12 bodx">
	        		<div class="row">
	        			<div class="col-6 col-lg-6 col-md-6 col-sm-6">
	        				<h4 class="modal-title text-left">Negative</h4>
	        			</div>
	        			<div class="col-6 col-lg-6 col-md-6 col-sm-6">
	          				<button type="button" class="close" data-dismiss="modal">&times;</button>
	          			</div>
	          		</div>
	        	</div>
	         	<p class=" pb-2">
	            	Accounts containing negative information and lowering your credit score. 
	        	</p>
	        </div>
	        <!-- Modal footer -->
      	</div>
    </div>
</div>
<!-- <script type="text/javascript">
	$(function () {
    var seriesOptions = [],
        seriesCounter = 0, counter_legend = 0;
    
    names = ['M1', 'M2', 'M3'],
    Highcharts.setOptions({
        lang: {
            rangeSelectorZoom: ' '
        }
    });
       
        createChart = function () {

            $('.container_box').highcharts('StockChart', {
                rangeSelector: {
                    selected: 1,
                    buttons: [],
                    inputEnabled: true,
                },


                chart: {
                    backgroundColor: '#f5f5f5',
                    
                    alignTicks: false,
                    
                    
                },
                legend: {
                    enabled: true
                },


                yAxis: {
                    minorTickInterval: 'auto',
                    labels: {
                        format: '{value}°C',

                        style: {
                            color: Highcharts.getOptions().colors[1]
                        }
                    },
                   
                   

                    plotLines: [{
                        value: 0,
                        width: 2,
                        color: 'silver'
                    }]
                },
                
                plotOptions: {
                    series: {
                        compare: 'C',
                        lineWidth: 2
                    }
                },

                title: {
                    text: 'AAAAA '
                },

                subtitle: {
                    text: 'AAAAA'
                },


                tooltip: {
                    pointFormat: '<span style="color:{series.color}">{series.name}</span>: <b>{point.y}</b><br/>',

                    valueDecimals: 2
                },

                series: seriesOptions
            });
        };

    
});</script> -->
<script type="text/javascript">
	function createLetter(newBureau)
	{
		$.ajax({
        	type:'get',
        	url:'{{url("/")}}/setDisputeSession/'+ newBureau,
        	success:function()
        	{
        		window.location.href = '{{url("/")}}/create_dispute'; 
        	}
        });
	}

	$(function() {

  var rawData = 631,
    data = getData(rawData);

  function getData(rawData) {
    var data = [],
      start = Math.round(Math.floor(rawData / 100) * 100);
    data.push(rawData);
    for (i = start; i > 0; i -= 10) {
      data.push({
        y: i
      });
    }
    return data;
  }

  Highcharts.chart('container', {
    chart: {
      type: 'solidgauge',
      marginTop: 10
    },
    
    title: {
      text: ''
    },
    
    subtitle: {
      text: rawData,
      style: {
        'font-size': '30px'
      },
      y: 200,
      zIndex: 7
    },

    tooltip: {
      enabled: false
    },

    pane: [{
      startAngle: -120,
      endAngle: 120,
      background: [{ // Track for Move
        outerRadius: '100%',
        innerRadius: '80%',
        backgroundColor: Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0.3).get(),
        borderWidth: 0,
        shape: 'arc'
      }],
      size: '100%',
      center: ['50%', '65%']
    }, {
      startAngle: -120,
      endAngle: 120,
      size: '95%',
      center: ['50%', '65%'],
      background: []
    }],

    yAxis: [{
      min: 0,
      max: 100,
      lineWidth: 2,
      lineColor: 'white',
      tickInterval: 10,
      labels: {
        enabled: false
      },
      minorTickWidth: 0,
      tickLength: 50,
      tickWidth: 5,
      tickColor: 'white',
      zIndex: 6,
      stops: [
        [0, '#e1e1e1'],
        [0.101, '#e1e1e1'],
        [0.201, '#e1e1e1'],
        [0.301, '#e1e1e1'],
        [0.401, '#e1e1e1'],
        [0.501, '#2db3f3'],
        [0.601, '#0668a5'],
        [0.701, '#2db3f3'],
        [0.801, '#e1e1e1'],
        [0.901, '#e1e1e1'],
        [1, '#e1e1e1']
      ]
    }, {
      linkedTo: 0,
      pane: 1,
      lineWidth: 5,
      lineColor: 'white',
      tickPositions: [],
      zIndex: 6
    }],
    
    series: [{
      animation: false,
      dataLabels: {
        enabled: false
      },
      borderWidth: 0,
      color: Highcharts.getOptions().colors[0],
      radius: '100%',
      innerRadius: '80%',
      data: data
    }]
  });
});

</script>

@endsection