@extends('frontend.frontMaster')

@section('content')

<div class="wrap pt-3">

	<form action="/Account/Summary" id="AccountForm" method="get" novalidate="novalidate">  

	  	<div class="wrap">

	        <div class="container">

	            <div class="page-header">

	                <div class="page-header__tabs">

	                    <ul class="nav nav-bar bureauTabs" role="tablist">

	                        <li class="nav-item">

	                        	<a class="nav-link active" href="javascript:;" id="ctTransunion" aria-selected="false" onclick="BureauChange('1',this); refreshAccounts();">Transunion</a>

	                        </li>

	                        <li class="nav-item">

	                        	<a class="nav-link" href="javascript:;" id="ctExperian" aria-selected="false" onclick="BureauChange('2',this); refreshAccounts();">Experian</a>

	                        </li>

	                        <li class="nav-item">

	                        	<a class="nav-link" href="javascript:;" id="ctEquifax" aria-selected="false" onclick="BureauChange('3',this); refreshAccounts();">Equifax</a>

	                        </li>

	                    </ul>

	                </div>

	                <div class="page-header__cta">

	                    <a href="{{url('/')}}/create_dispute"><button class="btn btn-primary" type="button" id="btnDispute" onclick="createDispute();">Create Transunion Dispute</button></a>

	                </div>

	            </div>

	        </div>

	        <div class="container">

	            <div class="row">

	                <div class="col-lg-2  filters-state filter-state--mobile-pills">

						<div class="filters">

						    <div class="d-none d-lg-inline-block filter-label">Filters

						     	<i class="fas fa-sliders-h"></i>

						 	</div>

						    <div class="filters__options">

						        <input data-val="true" data-val-required="The Bureau field is required." id="Search_Bureau" name="Search.Bureau" type="hidden" value="1"> 

						        <div class="filters__group">

						            <h6 class="filters__title">Account Status 

						            	<span class=" d-lg-none">Filter</span>
						            	
						            </h6>

						            <div class="filters__list">

										<div class="custom-control custom-checkbox ">

										    <input id="PositiveStatus_ID" name="PositiveStatus.ID" type="hidden" value="Positive">

										    <input labelvalue="Positive" class="custom-control-input AccountStatus" data-val="true" data-val-required="The IsChecked field is required." id="PositiveStatus_IsChecked" name="PositiveStatus.IsChecked" onclick=" FilterUpdateSelected('AccountStatus','Positive' ); refreshAccounts();" type="checkbox" value="Positive">

										    <input name="PositiveStatus.IsChecked" type="hidden" value="false"> 

										    <label id="checkbox-label-AccountStatus-Positive" class="custom-control-label " for="PositiveStatus_IsChecked">Positive</label>

										</div>

										<div class="custom-control custom-checkbox ">

										    <input id="NegativeStatus_ID" name="NegativeStatus.ID" type="hidden" value="Negative">

										    <input labelvalue="Negative" class="custom-control-input AccountStatus" data-val="true" data-val-required="The IsChecked field is required." id="NegativeStatus_IsChecked" name="NegativeStatus.IsChecked" onclick="FilterUpdateSelected('AccountStatus','Negative' ); refreshAccounts();" type="checkbox" value="Negative">

										    <input name="NegativeStatus.IsChecked" type="hidden" value="false"> 

										    <label id="checkbox-label-AccountStatus-Negative" class="custom-control-label " for="NegativeStatus_IsChecked">Negative</label>

										</div>

										<div class="custom-control custom-checkbox ">

										    <input id="DeletedStatus_ID" name="DeletedStatus.ID" type="hidden" value="Deleted">

										    <input labelvalue="Deleted" class="custom-control-input AccountStatus" data-val="true" data-val-required="The IsChecked field is required." id="DeletedStatus_IsChecked" name="DeletedStatus.IsChecked" onclick="FilterUpdateSelected('AccountStatus','Deleted' ); refreshAccounts();" type="checkbox" value="Deleted">

										    <input name="DeletedStatus.IsChecked" type="hidden" value="false"> 

										    <label id="checkbox-label-AccountStatus-Deleted" class="custom-control-label " for="DeletedStatus_IsChecked">Deleted</label>

										</div>

										<div class="custom-control custom-checkbox ">

										    <input id="RepairedStatus_ID" name="RepairedStatus.ID" type="hidden" value="Repaired">

										    <input labelvalue="Repaired" class="custom-control-input AccountStatus" data-val="true" data-val-required="The IsChecked field is required." id="RepairedStatus_IsChecked" name="RepairedStatus.IsChecked" onclick="FilterUpdateSelected('AccountStatus','Repaired' ); refreshAccounts();" type="checkbox" value="Repaired">

										    <input name="RepairedStatus.IsChecked" type="hidden" value="false"> 

										    <label id="checkbox-label-AccountStatus-Repaired" class="custom-control-label " for="RepairedStatus_IsChecked">Repaired</label>

										</div>

                						<div class="d-none d-lg-block"> 

											<div class="custom-control custom-checkbox ">

											    <input id="AllAccounts_ID" name="AllAccounts.ID" type="hidden" value="All">

											    <input labelvalue="All" checked="checked" class="custom-control-input AccountStatus" data-val="true" data-val-required="The IsChecked field is required." id="AllAccounts_IsChecked" name="AllAccounts.IsChecked" onclick="FilterUpdateSelected('AccountStatus','All' ); refreshAccounts();" type="checkbox" value="All"><input name="AllAccounts.IsChecked" type="hidden" value="false"> 

											    <label id="checkbox-label-AccountStatus-All" class="custom-control-label " for="AllAccounts_IsChecked">All</label>

											</div>

										</div>

            						</div>

        						</div>

						        <div class="filters__group">

						            <h6 class="filters__title">Dispute Status 

						            	<span class=" d-lg-none">Filter</span>

						            </h6>

						            <div class="filters__list">

                						<div class="custom-control custom-checkbox ">

										    <input id="NADispute_ID" name="NADispute.ID" type="hidden" value="N/A">

										    <input labelvalue="N/A" class="custom-control-input DisputeStatus" data-val="true" data-val-required="The IsChecked field is required." id="NADispute_IsChecked" name="NADispute.IsChecked" onclick="FilterUpdateSelected('DisputeStatus','N/A' ); refreshAccounts();" type="checkbox" value="true">

										    <input name="NADispute.IsChecked" type="hidden" value="false">

										    <label id="checkbox-label-DisputeStatus-N/A" class="custom-control-label " for="NADispute_IsChecked">N/A</label>

										</div>

										<div class="custom-control custom-checkbox ">

										    <input id="PendingDispute_ID" name="PendingDispute.ID" type="hidden" value="Pending">

										    <input labelvalue="Pending" class="custom-control-input DisputeStatus" data-val="true" data-val-required="The IsChecked field is required." id="PendingDispute_IsChecked" name="PendingDispute.IsChecked" onclick="FilterUpdateSelected('DisputeStatus','Pending' ); refreshAccounts();" type="checkbox" value="1">

										    <input name="PendingDispute.IsChecked" type="hidden" value="false"> 

										    <label id="checkbox-label-DisputeStatus-Pending" class="custom-control-label " for="PendingDispute_IsChecked">Pending</label>
										</div>
										<div class="custom-control custom-checkbox ">
										    <input id="SentDispute_ID" name="SentDispute.ID" type="hidden" value="Sent">
										    <input labelvalue="Sent" class="custom-control-input DisputeStatus" data-val="true" data-val-required="The IsChecked field is required." id="SentDispute_IsChecked" name="SentDispute.IsChecked" onclick="FilterUpdateSelected('DisputeStatus','Sent' ); refreshAccounts();" type="checkbox" value="2">
										    <input name="SentDispute.IsChecked" type="hidden" value="false"> 
										    <label id="checkbox-label-DisputeStatus-Sent" class="custom-control-label " for="SentDispute_IsChecked">Sent</label>
										</div>
										<div class="custom-control custom-checkbox ">
										    <input id="CompletedDispute_ID" name="CompletedDispute.ID" type="hidden" value="Completed">
										    <input labelvalue="Completed" class="custom-control-input DisputeStatus" data-val="true" data-val-required="The IsChecked field is required." id="CompletedDispute_IsChecked" name="CompletedDispute.IsChecked" onclick="FilterUpdateSelected('DisputeStatus','Completed' ); refreshAccounts();" type="checkbox" value="3">
										    <input name="CompletedDispute.IsChecked" type="hidden" value="false"> 
										    <label id="checkbox-label-DisputeStatus-Completed" class="custom-control-label " for="CompletedDispute_IsChecked">Completed</label>
										</div>
                						<div class="d-none d-lg-block">
											<div class="custom-control custom-checkbox ">
											    <input id="AllDisputes_ID" name="AllDisputes.ID" type="hidden" value="All">
											    <input labelvalue="All" checked="checked" class="custom-control-input DisputeStatus" data-val="true" data-val-required="The IsChecked field is required." id="AllDisputes_IsChecked" name="AllDisputes.IsChecked" onclick="FilterUpdateSelected('DisputeStatus','All' ); refreshAccounts();" type="checkbox" value="true"><input name="AllDisputes.IsChecked" type="hidden" value="false"> 
											    <label id="checkbox-label-DisputeStatus-All" class="custom-control-label " for="AllDisputes_IsChecked">All</label>
											</div>
										</div>
						            </div>
						        </div>
						    </div>
						</div>
                	</div>
                	<div id="divAccounts" class="col-lg-10 credit-item--table">
						<div id="accordion" class="accordion">    
							<div class="accordion__item"> 
							    <header class="accordion__header collapsed" data-target="#collapse-Accounts" data-toggle="collapse" role="button" aria-controls="collapse-Accounts" aria-expanded="true">
							        <span class="accordion__title" id="Accounts-title">Accounts</span>
							        <span class="accordion__badge tranCount">{{count($data)}}</span>
							    </header>
							    <div class="accordion__body collapse show" id="collapse-Accounts" data-parent="#accordion" aria-labelledby="Accounts-title">
							        <table class="table table-accordion table-status table-modify-border " cellspacing="0">
							            <tbody id="actb">
							            	@foreach($data as $key=>$value)
							            	<?php $accunt_status = '';$class = '';
							            		if($value->AccountCondition_abbreviation=='Open' && $value->AccountCondition_symbol=='O'){$accunt_status = 'Positive';$class='success';}else if($value->AccountCondition_abbreviation=='Derog' && $value->AccountCondition_symbol=='F'){$accunt_status = 'Negative';$class='danger';}?>
											<tr class="table-accordion__header tr--{{$class}} ">
												<td data-label="Credit Card " class="text-uppercase label--">{{$value->creditorName}}</td>
												<td data-label="BALANCE">${{$value->currentBalance}}</td>
												<td data-label="ACCOUNT STATUS" class="text-uppercase">{{$accunt_status}}</td>
				                            	<td class="d-none  btnDisputeReason">
				                                    <button type="button" class="btn btn-link p-0 btn-font--wider" onclick="openDisputeReasonPopUp('{{$value->trans_id}}','{{$value->bureau}}', '', 0,'edit'); ">
				                                        Add Dispute Reason
				                                        <i class="btn-warning fa fa-exclamation-circle" aria-hidden="true"></i>
				                                    </button>
				                            	</td>
					                            <td class="d-none  btnRemoveFromDispute">
					                                <button class="btn btn-link btn-gray btn-icon" onclick="RemoveAccountFromDispute('{{$value->bureau}}', '{{$value->trans_id}}', '')" type="button"><i class="fa fa-trash" aria-hidden="true"></i></button>
					                            </td>
					                            <td data-label="DISPUTE STATUS" class="">
					                                @if($value->dispute_letter!=null) Round {{$value->dispute_letter->round}}  
					                                	<?php if($value->dispute_letter->status=='1'){echo 'Pending';}else if($value->dispute_letter->status=='2'){echo 'Sent';}else if($value->dispute_letter->status=='3'){echo 'Completed';}?>
					                                @else 
					                                	N/A 
					                                @endif
					                            </td>
					                            <td>
				                                    <div class="table-accordion__icon collapsed" data-toggle="collapse" href="#collapse-Accounts-{{$key}}" aria-controls="#collapse-Accounts-{{$key}}">
				                                        <i class="fa fa-plus"></i>
				                                        <i class="fa fa-minus"></i>
				                                    </div>
				                            	</td>
					                        </tr>
					                        <tr class="table-accordion__content">
					                            <td colspan="7">
					                                <label class="checkbox-on" for="check-Accounts-0"> </label>
					                                <div name="DIV_{{$value->trans_id}}" class="collapse table-accordion__card table-accordion__card--{{$class}}" id="collapse-Accounts-{{$key}}">
					                                	@if($value->AccountCondition_abbreviation=='Open' && $value->AccountCondition_symbol=='O')
														<div class="row table-data">
													    	<div class="col-md-6">
													        	<table class="table-sm table-striped table-data__content">
													            	<tbody>
														            	<tr>
														                	<th>Account #</th>
														                	<td>{{str_pad(substr($value->accountNumber, 0, -4), strlen($value->accountNumber), '*', STR_PAD_RIGHT)}}</td>
														            	</tr>
														            	<tr>
														                	<th>Status</th>
														                	<td>{{$value->OpenClosed_description}}</td>
														            	</tr>
														            	<tr>
														                	<th>Credit Limit</th>
														                	<td> ${{$value->GrantedTrade_CreditLimit}}  </td>
														            	</tr>
														            	<tr>
														                	<th>High Balance</th>
														                	<td>${{$value->highBalance}}</td>
														            	</tr>
														            	<tr>
														                	<th>Payment Amount</th>
														                	<td> ${{$value->GrantedTrade_monthlyPayment}}</td> 
														            	</tr>
														            	<tr>
														                	<th>Last Payment</th>
														                	<td>6/26/2020  </td>
														            	</tr>
														              	<tr>
														                	<th>Term</th>
														                	<td>{{$value->GrantedTrade_termMonths}}</td>
														            	</tr>
														            	<tr>
												                			<th>Description</th>
										                					<td>{{$value->AccountDesignator_description}}</td>
										            					</tr>  
										        					</tbody>
										        				</table>
										    				</div>
														    <div class="col-md-6 table-data__table">
														        <table class="table-sm table-striped table-data__content">
														           <tbody>
															           	<tr>
															                <th> Open Date</th>
															                <td>{{date('d/m/Y',strtotime($value->dateOpened))}}</td>
															            </tr>
															            <tr>
															                <th> Closed Date</th>
															                <td>   </td>
															            </tr>
															            <tr>
															                <th>Last Reported</th>
															                <td>7/2/2020   </td>
															            </tr> 
															            <tr>
															                <th>Days Late</th>
															                <td> 30: <span class=""> {{$value->GrantedTrade_late90Count}} </span>
															                	| 60: <span class=" "> {{$value->GrantedTrade_late60Count}} </span> 
															                	| 90: <span class=" "> {{$value->GrantedTrade_late30Count}} </span> 
															                </td>
															            </tr>
															            <tr>
															                <th>Payment Status</th>
															                <td class=" ">{{$value->PayStatus_abbreviation}}</td>
															            </tr>
															            <tr>
															                <th>Past Due</th>
															                <td class=" "> ${{$value->GrantedTrade_amountPastDue}}</td>
															            </tr>
															          	<tr>
															                <th>Worst Rating</th>
															                <td class=" "> </td>
															            </tr>
															            <tr>
															                <th>Remarks</th>
															                <td class=" ">{{$value->remark_description}}</td>
															           	</tr>           
									        						</tbody>
									        					</table>
									    					</div>
														</div>
														@elseif($value->AccountCondition_abbreviation=='Derog' && $value->AccountCondition_symbol=='F')
														<div class="row table-data">
														    <div class="col-md-6">
														        <table class="table-sm table-striped table-data__content">
														            <tbody>
														            	<tr> 
														            		<th>Account #</th>
														            		<td>{{str_pad(substr($value->accountNumber, 0, -4), strlen($value->accountNumber), '*', STR_PAD_RIGHT)}}</td> 
														            	</tr>
														            	<tr> 
														            		<th>Status</th>
														            		<td>{{$value->OpenClosed_description}}</td> 
														            	</tr>
														            	<tr> 
														            		<th>Original Creditor</th>
														            		<td>CONWAY HOSPITAL</td> 
														            	</tr>
														            	<tr>  
														            		<th>Creditor Type</th>
														            		<td>Collection Services</td> 
														            	</tr>
														        	</tbody>
														    	</table>
														    </div>
														    <div class="col-md-6 table-data__table">
														        <table class="table-sm table-striped table-data__content">
														            <tbody>
														            	<tr> 
														            		<th>High Balance</th>
														            		<td>${{$value->highBalance}}</td> 
														            	</tr>
														            	<tr> 
														            		<th>Open Date</th>
														            		<td>{{date('d/m/Y',strtotime($value->dateOpened))}}</td> 
														            	</tr>
														            	<tr> 
														            		<th>Last Reported</th>
														            		<td>6/24/2018  </td> 
														            	</tr>
														            	<tr> 
														            		<th>Remarks</th>
														            		<td>{{$value->remark_description}}</td> 
														            	</tr>
															        </tbody>
															    </table>
														    </div>
														</div>
														<table class="table-accordion__footer">
												            <tbody>
												            	@if(count($value->disputeData)>0)
												            	@foreach($value->disputeData as $data)
												            	<tr>
												                	<td data-label="Dispute" style="width:10%;"> Round {{$data->round}}</td>
												                	<?php if($data->status=='1'){$status='Pending';$content='Disputes letters created but not marked as sent yet.';}else if($data->status=='2'){$status='Sent';$content='Dispute letters sent to credit bureaus but still awaiting results.';}else if($data->status=='3'){$status='Completed';$content='Dispute letters sent to credit bureaus and results have been received.';}?>
												                	<td data-label="{{$status}}" style="width:20%;">
													                    <div class="d-flex align-items-center">
													                        <span>
																				{{date('m/d/Y',strtotime($data->created))}}
													                        </span>
													                        <a class="btn-border btn btn-icon btn-xs ml-2" data-class="dynamic-class" data-content="{{$content}}" data-placement="top" data-toggle="popover" data-trigger="hover" href="javascript:;" title="" rel="popover" data-original-title="{{$status}}"><i class="fa fa-info"></i></a>
													                    </div>
													                </td>
												                	<td data-label="Reason" style="width:20%;"><span>{{$data->subject}}</span></td>
												                	<td class="font-weight-normal"> 
												                		<span>{{$data->reason}}</span>
												                	</td>
												            	</tr>
												            	@endforeach
												            	@endif
												        	</tbody>
												        </table>
														@endif
					                                </div>
					                            </td>
					                        </tr>
					                        @endforeach
           								</tbody>
        							</table>
    							</div>
							</div>   
							<div class="accordion__item">
		    					<header class="accordion__header collapsed" data-target="#collapse-PublicRecords" data-toggle="collapse" role="button" aria-controls="collapse-PublicRecords" aria-expanded="true">
		        					<span class="accordion__title" id="PublicRecords-title">Public Records</span>
		        					<span class="accordion__badge">0</span>
		    					</header>
		    					<div class="accordion__body collapse " id="collapse-PublicRecords" data-parent="#accordion" aria-labelledby="PublicRecords-title">
        							<table class="table table-accordion table-status table-modify-border " cellspacing="0">
					            		<tbody>
											<form action="/Account/summary" id="AddDisputeReasonForm" method="post"></form>     
										</tbody>
        							</table>
    							</div>
							</div>   
							<div class="accordion__item">
		    					<header class="accordion__header collapsed" data-target="#collapse-Inquiries" data-toggle="collapse" role="button" aria-controls="collapse-Inquiries" aria-expanded="true">
		        					<span class="accordion__title" id="Inquiries-title">Inquiries</span>
		        					<span class="accordion__badge">0</span>
		    					</header>
		    					<div class="accordion__body collapse " id="collapse-Inquiries" data-parent="#accordion" aria-labelledby="Inquiries-title">
		        					<table class="table table-accordion table-status table-modify-border " cellspacing="0">
		            					<tbody>
											<form action="/Account/summary" id="AddDisputeReasonForm" method="post"></form>
											<!-- <tr class="table-accordion__header tr--danger">
												<td data-label="Name" class="text-uppercase">SYNCB/AMAZON</td>
												<td data-label="Date">12/16/2019</td>
												<td data-label="ACCOUNT STATUS" class="text-uppercase">Negative</td>
					                            <td class="d-none  btnDisputeReason">
				                                    <button type="button" class="btn btn-link p-0 btn-font--wider" onclick="openDisputeReasonPopUp('171653','TRU', '', 0,'edit'); ">
			                                        Add Dispute Reason
			                                        <i class="btn-warning fas fa-exclamation-circle" aria-hidden="true"></i>
				                                    </button>
					                            </td>
					                            <td class="d-none  btnRemoveFromDispute">
					                                <button class="btn btn-link btn-gray btn-icon" onclick="RemoveAccountFromDispute('TRU', 171653, '')" type="button"><i class="fas fa-trash" aria-hidden="true"></i></button>
					                            </td>
					                            <td data-label="DISPUTE STATUS" class="">
					                                N/A
					                            </td>
					                            <td>
					                            </td>
					                        </tr> -->     
		            					</tbody>
		        					</table>
		    					</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</form>
</div>
<script src="{{url('/')}}/accets/frontend/js/credit.js"></script>

@endsection