@extends('frontend.frontMaster')
@section('content')
<section>
	<div class="wrap pt-3">
		<div class="credit-message">
		    <h3 class="credit-message__title">Congratulations <span class="text-capitalize">{{Session::get('userLoginInfo')['first_name']}}</span>! Based on your credit report, we found these great offers for you!</h3>
		    <p class="credit-message__text">Revolving credit is a big part of your credit score. Improve your credit by having at least 3 to 5 open credit cards in good standing.</p>
		</div>
		<br>
		<div class="container">
		    <div class="credit-offer py-5">
		        <div class="credit-offer__title">Your Credit Card Offers</div>
		        <div class="credit-offer__text mt-4">
		            <div class="row">
		            	@foreach($data as $value)
						<div class="col-md-4 credit-offer__card">
		                    <div class="credit-card">
		                        <div class="credit-card__title">
		                            <h6>{{$value->title}}</h6>
		                        </div>
		                        <div class="credit-card__img">
		                            <img src="{{url('/')}}/uploads/{{$value->card_image}}">
		                        </div>
		                        <ul class="credit-list">
		                            <li>
		                                <h5>APPROVAL ODDS</h5>
		                                <p class="text-capitalize">{{$value->odds}}</p>
		                            </li>
		                            <li>
		                                <h5>ANNUAL FEE</h5>
		                                <p>${{$value->annual_fee}}</p>
		                            </li>
		                            <li>
		                                <h5>SECURITY DEPOSIT</h5>
		                                <p>{{$value->security_deposit}}</p>
		                            </li>
		                        </ul>
		                        <a class="btn btn-primary rounded-2 btn-block mt-2" href="{{$value->url}}" target="_blank">APPLY NOW</a>
		                    </div>
		                </div>
		                @endforeach
					</div>
		            <div class="legal-disclaimer pt-5">Advertiser Disclosure: The offers that appear on this page are from third party advertisers from which Credit Versio receives compensation. This compensation may impact how and where products appear on this site (including, for example, the order in which they appear). It is this compensation that enables Credit Versio to provide you with a free credit repair software. Credit Versio strives to provide a wide array of offers for our members, but our offers do not represent all financial services, companies or products.</div>
		        </div>
		    </div>
		</div>
    </div>
</section>
@endsection