<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Security_questions extends Model
{
    protected $table = 'security_questions';
    protected $primaryKey = 'id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getSecurity_questions($id){
      $data =  Security_questions::where('id', $id)->get();
      if(count($data)){
        return $data[0];
      } else{
        return array();
      }
    }

    public function getSecurity_questionsView($id){
      $security_questions = Security_questions::select(array('security_questions.*'));
      $security_questions->where('security_questions.id', $id);
      
      return $security_questions->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $security_questions = $this->getSecurity_questions($id);
      if(count($security_questions)){
        
                    if($field=="status"){
                        $status = $security_questions->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $security_questions->status=$status;
                        $security_questions->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $security_questions = $this->getSecurity_questions($id);
      if(count($security_questions)){
        $img = public_path().'/uploads/'.$security_questions->featured_img;
            if($security_questions->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $security_questions->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getSecurity_questionsData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $security_questions = Security_questions::select(array('security_questions.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $security_questions->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $security_questions->orderBy($sortBy, $order);
        } else{
          $security_questions->orderBy('security_questions.id', 'desc');
        }        

        return $security_questions->paginate($per_page);
    }

    public function getSecurity_questionsExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $security_questions = Security_questions::select(array('security_questions.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $security_questions->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $security_questions->orderBy($sortBy, $order);
        } else{
          $security_questions->orderBy('security_questions.id', 'desc');
        }
        return $security_questions->get();
    }

    public function updateSecurity_questions($request){
      $id = $request->input('id');
      $security_questions = Security_questions::getSecurity_questions($id);
      if(count($security_questions)){

          $security_questions->question = $request->input('question')!="" ? $request->input('question') : "";
	$security_questions->status = $request->input('status')!="" ? $request->input('status') : "";

          $security_questions->save();
          return true;
      } else{
        return false;
      }
    }

    public function addSecurity_questions($request){
      $security_questions = new Security_questions;

        $security_questions->question = $request->input('question')!="" ? $request->input('question') : "";
	$security_questions->status = $request->input('status')!="" ? $request->input('status') : "";

        $security_questions->save();
        return $security_questions->id;
    }
}
