<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Dispute_letters extends Model
{
    protected $table = 'dispute_letters';
    protected $primaryKey = 'id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getDispute_letters($id){
      $data =  Dispute_letters::where('id', $id)->get();
      if(count($data)){
        return $data[0];
      } else{
        return array();
      }
    }

    public function getDispute_lettersView($id){
      $dispute_letters = Dispute_letters::select(array('dispute_letters.*'));
      $dispute_letters->where('dispute_letters.id', $id);
      
      return $dispute_letters->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $dispute_letters = $this->getDispute_letters($id);
      if(count($dispute_letters)){
        
                    if($field=="status"){
                        $status = $dispute_letters->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $dispute_letters->status=$status;
                        $dispute_letters->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $dispute_letters = $this->getDispute_letters($id);
      if(count($dispute_letters)){
        $img = public_path().'/uploads/'.$dispute_letters->featured_img;
            if($dispute_letters->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $dispute_letters->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getDispute_lettersData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $dispute_letters = Dispute_letters::select(array('dispute_letters.*','register_user.first_name'));
      
      //join
        $dispute_letters->leftjoin('register_user','dispute_letters.user_id','=','register_user.id');         

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $dispute_letters->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $dispute_letters->orderBy($sortBy, $order);
        } else{
          $dispute_letters->orderBy('dispute_letters.id', 'desc');
        }        

        return $dispute_letters->paginate($per_page);
    }

    public function getDispute_lettersExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $dispute_letters = Dispute_letters::select(array('dispute_letters.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $dispute_letters->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $dispute_letters->orderBy($sortBy, $order);
        } else{
          $dispute_letters->orderBy('dispute_letters.id', 'desc');
        }
        return $dispute_letters->get();
    }

    public function updateDispute_letters($request){
      $id = $request->input('id');
      $dispute_letters = Dispute_letters::getDispute_letters($id);
      if(count($dispute_letters)){

          $dispute_letters->user_id = $request->input('user_id')!="" ? $request->input('user_id') : "";
	$dispute_letters->transaction_id = $request->input('transaction_id')!="" ? $request->input('transaction_id') : "";
	$dispute_letters->acc_no = $request->input('acc_no')!="" ? $request->input('acc_no') : "";
	$dispute_letters->status = $request->input('status')!="" ? $request->input('status') : "";

          $dispute_letters->save();
          return true;
      } else{
        return false;
      }
    }

    public function addDispute_letters($request){
      $dispute_letters = new Dispute_letters;

        $dispute_letters->user_id = $request->input('user_id')!="" ? $request->input('user_id') : "";
	$dispute_letters->transaction_id = $request->input('transaction_id')!="" ? $request->input('transaction_id') : "";
	$dispute_letters->acc_no = $request->input('acc_no')!="" ? $request->input('acc_no') : "";
	$dispute_letters->status = $request->input('status')!="" ? $request->input('status') : "";

        $dispute_letters->save();
        return $dispute_letters->id;
    }
}
