<?php
namespace App;
use DB;
use DateTime;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Mail;
use Session;
class Master extends Model
{
    public $getDateTime;
    public function __construct()
    {
        $this->getDateTime = date('Y-m-d H:i:s');
    }
    public function successResponse($data)
    {
        $return['response'] = true;
        $return['code'] = 200;
        $return['msg'] = 'Success';
        $return['data'] = $data;
        return $return;
    }
    public function failureResponse($data)
    {
        $return['response'] = false;
        $return['code'] = 404;
        $return['msg'] = 'No Result Found';
        $return['data'] = $data;
        return $return;
    }
    public function html_email($toEmail, $toName, $subject, $msg, $attach = '')
    {
        // dd($toEmail,$toName,$subject,$msg);
        $this->toEmail = $toEmail;
        $this->toName = $toName;
        $this->subject = $subject;
        $this->attach = $attach;
        $data['msg'] = $msg;
        return Mail::send('mail', $data, function ($message)
        {
            $message->to($this->toEmail, $this->toName)
                ->subject($this->subject);
            if ($this->attach != '')
            {
                $message->attach($this->attach);
            }
            $message->from('devs.togglebytes@gmail.com', 'Fix Your Credit');
        });
    }
    public function getUserInfo(){
        // dd('sd');
        if(Session::has('userLoginInfo')){

        }else{
            redirect('/signIn');
        }
    }
    public function getCount($table,$where=''){
        return DB::table($table)->where($where)->count();
    }
    public function getAll($table)
    {
        return DB::table($table)->get();
    }

    public function getSingleDataFirst($table, $where, $sortBy = '', $orderBy = '')
    {
        $q = DB::table($table)->where($where);
        if ($sortBy != '' && $orderBy != '')
        {
            $q->orderBy($sortBy, $orderBy);
        }
        $ss = $q->get()
            ->first();
        return $ss;
    }
    public function getJointData($table, $tid, $join_table, $jid, $where = '', $whereInField = '', $whereInValue = '', $sortBy = '', $order = '', $select = '', $offset = '', $limit = '')
    {
        // dd($skip,$take);
        $query = DB::table($table);
        if ($select != '')
        {
            $query->select($select);
        }
        $query->join($join_table, $join_table . '.' . $jid, '=', $table . '.' . $tid);
        if ($where != '')
        {
            $query->where($where);
        }
        // whereIn condition
        if ($whereInField != '' && $whereInValue != '')
        {
            $query->whereIn($whereInField, $whereInValue);
        }
        // sort option
        if ($sortBy != '' && $order != '')
        {
            $query->orderBy($sortBy, $order);
        }

        //limit
        if ($limit != '')
        {
            $query->limit($limit);
        }
        //offset
        if ($offset != '')
        {
            $query->offset($offset);
        }
        return $query->get();
    }
    public function getLeftJointData($table, $tid, $join_table, $jid, $where = '', $whereInField = '', $whereInValue = '', $sortBy = '', $order = '', $select = '', $offset = '', $limit = '')
    {
        // dd($whereInField,$whereInValue,$select);
        $query = DB::table($table);
        if ($select != '')
        {
            $query->select($select);
        }
        $query->leftJoin($join_table, $join_table . '.' . $jid, '=', $table . '.' . $tid);
        if ($where != '')
        {
            $query->where($where);
        }
        // whereIn condition
        if ($whereInField != '' && $whereInValue != '')
        {
            $query->whereIn($whereInField, $whereInValue);
        }
        // sort option
        if ($sortBy != '' && $order != '')
        {
            $query->orderBy($sortBy, $order);
        }
        //limit
        if ($limit != '')
        {
            $query->limit($limit);
        }
        //offset
        if ($offset != '')
        {
            $query->offset($offset);
        }
        return $query->get();
    }
    public function getSingleCol($table, $col_name, $where = '')
    {
        // dd($table,$col_name,$where);
        $query = DB::table($table);

        if ($where != '')
        {
            $query->where($where);
        }

        return $query->pluck($col_name)->first();
    }

    public function checkDataExist($table, $where)
    {
        $data = DB::table($table)->where($where)->exists();
        return $data;
    }
    public function checkExist($table, $where, $request)
    {
        $data = DB::table($table)->where($where)->exists();

        if ($data != true)
        {
           return $this->addData($table, $request);
        }
        else
        {
           return $this->updateData($table, $where, $request);
        }
    }

    public function getSingleData($table, $where, $col_name = [])
    {
        $query = DB::table($table)->where($where);
        if ($col_name != [])
        {
            return $query->get($col_name)->first();
        }
        return $query->get()
            ->first();
    }

    public function addData($table, $data)
    {
        // dd($table);
        return DB::table($table)->insert($data);
    }
    public function addDataGetID($table, $data)
    {
        return DB::table($table)->insertGetId($data);
    }

    public function updateData($table, $where, $data)
    {
        return DB::table($table)->where($where)->update($data);
    }

    public function deleteData($table, $where)
    {
        return DB::table($table)->where($where)->delete();
    }

    public function uploadFile($file){
        $avatar_name='';
        $avatar_file = $file;
        if(!is_null($avatar_file)){
            $avatar_name = time().'_'.$avatar_file->getClientOriginalName();
            $avatar_file->move('uploads',$avatar_name);
        }
        return $avatar_name;
    }

    public function getAllData($table, $where, $sortBy = '', $order = '', $limit = '', $offset = '', $fields = ['*'])
    {
        // dd($fields);
        $master = DB::table($table)->select($fields);

        // join
        // where condition
        if ($where != '')
        {
            $master->where($where);
        }

        // sort option
        if ($sortBy != '' && $order != '')
        {
            $master->orderBy($sortBy, $order);
        }
        else
        {
            // $master->orderBy('id', 'desc');
            
        }
        //limit
        if ($limit != '')
        {
            $master->limit($limit);
        }
        //offset
        if ($offset != '')
        {
            $master->offset($offset);
        }
        if ($fields != [])
        {
            return $master->get($fields);
        }
        return $master->get();
    }
    public function getWhereIn($table, $whereInField, $whereInValue)
    {
        //dd($whereInField,$whereInValue);
        return DB::table($table)->whereIn($whereInField, $whereInValue)->get();
    }
    public function getAllDataWhereIn($table, $where, $whereInField, $whereInValue, $sortBy = '', $order = '', $limit = '', $offset = '', $fields = [])
    {
        $master = DB::table($table);
        if ($fields != [])
        {
            $master->select($fields);
        }

        // $master->select(array('*'));
        // join
        // whereIn condition
        if ($whereInField != '' && $whereInValue != '')
        {
            $master->whereIn($whereInField, $whereInValue);
        }
        // where condition
        if ($where != '')
        {
            $master->where($where);
        }
        // sort option
        if ($sortBy != '' && $order != '')
        {
            $master->orderBy($sortBy, $order);
        }
        else
        {
            // $master->orderBy('id', 'desc');
            
        }
        //limit
        if ($limit != '')
        {
            $master->limit($limit);
        }
        //offset
        if ($offset != '')
        {
            $master->offset($offset);
        }

        return $master->get();
    }

    public function getdashboardJointData($table, $tid, $join_table, $jid, $field, $whereInField = '', $whereInValue = '', $where = '')
    {
        $master = DB::table($table);
        $master->select($field);
        $master->join($join_table, $join_table . '.' . $jid, '=', $table . '.' . $tid);

        if ($whereInField != '' && $whereInValue != '')
        {
            $master->whereIn($whereInField, $whereInValue);
        }
        // dd($where);
        if ($where != '')
        {
            $master->where($where);
        }
        return $master->get();
        // return DB::table($table)->join($join_table,$join_table.'.'.$jid ,'=',$table.'.'.$tid)->get();
        // DB::table($table)->join($join_table,$join_table.'.'.$jid ,'=',$table.'.'.$tid)->where($where)->get($field);
        
    }
    public function customequery($query)
    {

        $master = DB::select($query);

        return $master;

    }
    public function customequeryNoarray($query)
    {
        //dd($query);
        $master = DB::select($query);
        if (count($master) > 0)
        {

            return $master[0];
        }
        else
        {
            return [];
        }
        // dd($master);
        
    }

    public function getGWData($table, $where, $col)
    {
        return DB::table($table)->where($where)->pluck($col);
    }

    public function singleArray($table, $col)
    {
        return DB::table($table)->pluck($col);
    }

    ///////////////////slug generation/////////////////////
    public function getSlug($table, $col_name, $name)
    {
        $lower = strtolower($name);
        $replace = str_replace(' ', '-', $lower);
        $main = $this->check_name($table, $col_name, $name);
        // dd($main,$replace);
        if ($main > 0)
        {
            $slug = $this->addslug($table, $col_name, $replace);
            $mar = str_replace("-", " ", $slug[0]->c);

            if (!is_numeric($mar))
            {
                $name_slug = $replace . "-" . $main;
            }
            else
            {
                $var = $mar + 1;
                $name_slug = $replace . "-" . $var;
            }
        }
        else
        {
            $name_slug = $replace;
        }
        return $name_slug;
    }

    public function check_name($table, $col_name, $name)
    {
        return DB::table($table)->where($col_name, '=', $name)->count();
    }

    public function addslug($table, $col_name, $slug)
    {
        return DB::table($table)->select(DB::raw('RIGHT(' . $col_name . ' ,2) as c'))->where($col_name, $slug)->orwhere($col_name, 'like', '%' . $slug . '%')->orderBy($col_name, 'desc')->limit(1)
            ->get();
    }

    public function edit_slug($table, $col_name, $slug, $col, $id)
    {
        $data = DB::table($table)->where($col, $id)->where($col_name, $slug)->count();
        if ($data > 0)
        {
            return strtolower($slug);
        }
        else
        {
            return $this->Slug($table, $col_name, $slug);
        }
    }
    ///////////////////slug generation/////////////////////
    
}

