<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\CreditOffer;
use DB;
use Illuminate\Support\Facades\Input;

class CreditOfferController extends Controller
{
    public $v_fields=array('credit_offer.title', 'credit_offer.card_image', 'credit_offer.odds', 'credit_offer.annual_fee', 'credit_offer.security_deposit', 'credit_offer.url', 'credit_offer.status');
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function index(Request $request){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';
        $_GET['searchValue']=$_GET['searchValue']??"";
        // order
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
            if(isset($_GET['order']) && $_GET['order']!=''){
                $_GET['order']=$_GET['order']=='asc'?'desc':'asc';
            } else{
                $_GET['order']='desc';
            }
        }

        // create links for field
        $get_q = $_GET;
        foreach ($this->v_fields as $key => $value) {
          $get_q['sortBy'] = $value;
          $get_q['page']=1;
          $query_result = http_build_query($get_q);
          $links[$value.'_link'] =url('/').'/admin/credit_offer?'.$query_result;
        }
        $links['csvlink'] = url('/').'/admin/credit_offer/export/csv?'.$_SERVER['QUERY_STRING'];
        $links['pdflink'] = url('/').'/admin/credit_offer/export/pdf?'.$_SERVER['QUERY_STRING'];

        // pagination per page
        $per_page = isset($_GET['per_page'])?$_GET['per_page']:10;

        // search value
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy=$_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // get by modal
        $credit_offer = new \App\admin\CreditOffer;
        $data = $credit_offer->getCredit_offerData($per_page, $searchBy, $searchValue, $sortBy, $order);

        return view('admin/credit_offer/index', ['data'=>$data->appends(Input::except('page')), 'per_page'=>$per_page, 'links'=>$links]);
    }



    public function getAdd(Request $request){
        $credit_offer = new \App\admin\CreditOffer;
        $data = array();
        
        return view('admin/credit_offer/add', $data);
    }

    public function postEdit(Request $request){

        $this->validate($request, [
            
        ]);

        $credit_offer = new \App\admin\CreditOffer;
        if($credit_offer->updateCredit_offer($request)){
            
            $request->session()->flash('message', 'Credit_offer Updated successfully!');
            return redirect()->action('admin\CreditOfferController@index');
        } else{
            $request->session()->flash('message', 'Error: Invalid record!');
            return redirect()->action('admin\CreditOfferController@index');
        }
    }

    public function postAdd(Request $request){

        $this->validate($request, [
            
        ]);

        $credit_offer = new \App\admin\CreditOffer;

        $insert_id = $credit_offer->addCredit_offer($request);

        
             
       

        $request->session()->flash('message', 'Credit_offer added successfully!');
        return redirect()->action('admin\CreditOfferController@index');
    }

    public function getEdit($id=''){
        
        $credit_offer = new \App\admin\CreditOffer;
        $data = array();

        
        
        $data['data'] = $credit_offer->getCredit_offer($id);
        if(count($data)){
            return view('admin/credit_offer/edit', $data);
        } else{
            return view('admin/credit_offer/edit');
        }
    }

    public function view($id){
        $credit_offer = new \App\admin\CreditOffer;
        $data['data'] = $credit_offer->getCredit_offerView($id);
        
        
        if(count($data)){
            return view('admin/credit_offer/view', $data);
        } else{
            return view('admin/credit_offer/view');
        }
    }

    public function status(Request $request, $field, $id){
        $credit_offer = new \App\admin\CreditOffer;
        $flag = $credit_offer->changeStatus($field, $id);
        // $redirect = $_GET["redirect"];
        if($flag){
            $request->session()->flash('message', 'Status changed successfully!');
            // return redirect($redirect);
            return redirect()->action('admin\CreditOfferController@index');
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\CreditOfferController@index');
        }
    }

    public function delete(Request $request){
        $id = $request->input('id');
        $credit_offer = new \App\admin\CreditOffer;
        $flag = $credit_offer->deleteOne($id);
        if($flag){
            $request->session()->flash('message', 'Credit Offer deleted successfully!');
            if($request->input('redirect')!=''){
                return redirect(urldecode($request->input('redirect')));
            } else{
                return redirect()->action('admin\CreditOfferController@index');
            }
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\CreditOfferController@index');
        }
    }

    public function deleteAll(Request $request)
    {
        $allIds = $request->input('allIds');
        $flag = false;
        $credit_offer = new \App\admin\CreditOffer;
        for($i=0; $i<count($allIds); $i++)
        {
            if($allIds[$i]!="")
            {
                $id = $allIds[$i];
                $flag = $credit_offer->deleteOne($id);                
            }
        }

        if($flag){
            $request->session()->flash('message', 'Demo deleted successfully!');
        }
    }

    public function getExport($type){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';

        // search query
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy = $_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // sort by
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
        }

        $credit_offer = new \App\admin\CreditOffer;
        $data = $credit_offer->getCredit_offerExport($searchBy, $searchValue, $sortBy, $order);

        if($type=='csv'){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=credit_offer.csv');
            header('Pragma: no-cache');
            $csv='Sr. No,'.implode(',', $this->v_fields)."\n";
            foreach ($data as $key => $value) {
                $line=($key+1).',';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $line.='"'.$value->$field.'"'.',';
                }
                $csv.=ltrim($line,',')."\n";
            }
            echo $csv; exit;
        } elseif($type=='pdf'){
            require_once(app_path().'/libraries/mpdf60/mpdf.php');
            $table='
            <html>
            <head><title></title>
            <style>
            table{
                border:1px solid;
            }
            tr:nth-child(even)
            {
                background-color: rgba(158, 158, 158, 0.82);
            }
            </style>
            </head>
            <body>
            <h1 align="center">credit_offer</h1>
            <table><tr>';
            $table.='<th>Sr. No</th>';
            foreach ($this->v_fields as $value) {
                $table.='<th>'.$value.'</th>';
            }
            $table.='</tr>';
            foreach ($data as $key => $value) {
                $table.='<tr><td>'.($key+1).'</td>';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $table.='<td>'.$value->$field.'</td>';
                }
                $table.='</tr>';
            }
            $table.='</table></body></html>';
            $pdf = new \mPDF();
            $pdf->WriteHTML($table);
            $pdf->Output('credit_offer.pdf', "D");
            exit;
        } else{
            echo 'Invalid option!';
        }
    }
}
