<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Redirect;

use App\Http\Requests;

use Illuminate\Http\Request;

use App\Jobs\ProcessEmail;

use App\Jobs\ProcessTime;

use DB;

use Carbon\Carbon;

use Session;

use Hash;

use Auth;





class LoginController extends Controller
{

    /**

     * Create a new controller instance.

     *

     * @return void

     */
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');
    public function __construct()
    {

        parent::__construct($this->masterModel);

    }

    public function index()
    {
      if(!Session::has('userLoginInfo'))
      {
          return redirect('/signIn');
      }

      $data['score'] = $this->masterModel->customequery('select *, (select created from creditscore as t2 where user_id = '.Session::get('userLoginInfo')['user_id'].' and t2.source_type = t1.source_type order by created asc limit 1) as since, (select (t1.riskScore - t3.riskScore) from creditscore as t3 where user_id = '.Session::get('userLoginInfo')['user_id'].' and t3.source_type = t1.source_type order by created asc limit 1) as rise from creditscore as t1 where user_id = '.Session::get('userLoginInfo')['user_id'].' order by created desc limit 3');
      // $data['score'] = rsort($data['score']);
      $data['user'] = $this->masterModel->getSingleData('register_user',['id'=>Session::get('userLoginInfo')['user_id'],'status'=>1]);
      $data['transPos'] = $this->masterModel->getCount('transactions',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>1,'AccountCondition_abbreviation'=>'Open','AccountCondition_symbol'=>'O']);
      $data['expPos'] = $this->masterModel->getCount('transactions',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>2,'AccountCondition_abbreviation'=>'Open','AccountCondition_symbol'=>'O']);
      $data['equPos'] = $this->masterModel->getCount('transactions',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>3,'AccountCondition_abbreviation'=>'Open','AccountCondition_symbol'=>'O']);
      $data['transNig'] = $this->masterModel->getCount('transactions',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>1,'AccountCondition_abbreviation'=>'Derog','AccountCondition_symbol'=>'F']);
      $data['expNig'] = $this->masterModel->getCount('transactions',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>2,'AccountCondition_abbreviation'=>'Derog','AccountCondition_symbol'=>'F']);
      $data['equNig'] = $this->masterModel->getCount('transactions',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>3,'AccountCondition_abbreviation'=>'Derog','AccountCondition_symbol'=>'F']);

      $data['truCmp'] = $this->masterModel->getCount('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>1,'status'=>3]);
      $data['truSnt'] = $this->masterModel->getCount('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>1,'status'=>2]);
      $data['truPnd'] = $this->masterModel->getCount('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>1,'status'=>1]);
      $data['expCmp'] = $this->masterModel->getCount('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>2,'status'=>3]);
      $data['expSnt'] = $this->masterModel->getCount('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>2,'status'=>2]);
      $data['expPnd'] = $this->masterModel->getCount('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>2,'status'=>1]);
      $data['equCmp'] = $this->masterModel->getCount('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>3,'status'=>3]);
      $data['equSnt'] = $this->masterModel->getCount('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>3,'status'=>2]);
      $data['equPnd'] = $this->masterModel->getCount('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>3,'status'=>1]);

      // dd($data['score']);
      return view('frontend.index',$data);
    }

    public function loginClient()
    {
      if(Session::has('userLoginInfo'))
      {
          return back();
      }

      return view('frontend.login');            
    }

    public function terms_condition()
    {
      return view('frontend.terms_condition');            
    }

    public function profile()
    {
      // dd(Session::get('userLoginInfo'));
      $data['state'] = $this->masterModel->getAllData('states',['status'=>1]);
      $data['plan'] = $this->masterModel->getAllData('credit_plan',['status'=>1]);
      $data['user'] = $this->masterModel->getSingleData('register_user',['id'=>Session::get('userLoginInfo')['user_id'],'status'=>1]);

      return view('frontend.myaccount',$data);
    }

    public function checkLogin(Request $request)
    { 
       $this->validate($request, [
            'email'=> 'email|required',
            'password'=> 'required',
        ]);

      $remember = ($request['remember']) ? true : false;

      $exist=$this->masterModel->getSingleDataFirst('register_user',['email'=>$request['email'],'status'=>1]);
      if($exist)
        {
          if(Hash::check($request['password'],$exist->password))
          {
            $userData['user_id']=$exist->id ?? "";
            $userData['first_name']=$exist->first_name ?? "";
            $userData['last_name']=$exist->last_name ?? "";
            $userData['email']=$exist->email ?? "";

            if($remember==true)
            {
              setcookie("email",$request['email'],time()+60*60);      
              setcookie("password",$request['password'],time()+60*60);
            }

            Session::put('userLoginInfo',$userData);

            if($exist->plan_id==0)
            {
              return Redirect('/membership');
            }
            else
            {
              return Redirect('/');
            }
        }
        else
        {
          Session::flash('message', 'YOU ENTER WRONG PASSWORD!.');
          return Redirect::back();
        }
      }
      else
      {
        Session::flash('message', 'WE CANT FIND A USER WITH THAT E-MAIL ADDRESS.');
        return Redirect::back();

      }
    }

    public function register(Request $request)
    {
        if(Session::has('userLoginInfo'))
        {
            return back();
        }
        
        $data['state'] = $this->masterModel->getAll('states');

        return view('frontend.register',$data);
    }

    public function postUser(Request $request)
    {
        $this->validate($request,[
          'email'=>'required|email|unique:register_user',
        ]);

        $data = [
          'first_name' => $request['first_name'],
          'last_name' => $request['last_name'],
          'email' => $request['email'],
          'password' => Hash::make($request['password']),
          'address' => $request['address'],
          'state' => $request['state'], 
          'city' => $request['city'],
          'mobile' => $request['phone'],
          'pincode' => $request['zip'],
          'status' => 1,
          'created' => date('Y-m-d H:i:s') 
        ];

        $id = $this->masterModel->addDataGetID('register_user',$data);
        $userData['user_id']=$id ?? "";
        $userData['first_name']=$request['first_name'] ?? "";
        $userData['last_name']=$request['last_name'] ?? "";
        $userData['email']=$request['email'] ?? "";

        Session::put('userLoginInfo',$userData);
        return json_encode($id);
    }

    public function dashboard()
    {
      $id = decrypt($_GET['member']);
      $data['id'] = $id;
      $data['questions'] = $this->masterModel->getAllData('security_questions',['status'=>1]); 
      $data['plan'] = $this->masterModel->getSingleData('credit_plan',['id'=>$id,'status'=>1]);
      $data['user'] = $this->masterModel->getSingleData('register_user',['id'=>Session::get('userLoginInfo')['user_id']]);

      return view('frontend.dashboard',$data);
    }

    public function membership()
    {
      $data['plan'] = $this->masterModel->getAllData('credit_plan',['status'=>1]);

      return view('frontend.membership',$data);
    }

    public function cityData(Request $request)
    {
        $city = $this->masterModel->getAllData('cities',['state_id'=>$request['state_id']]);
        echo json_encode($city);
    }

    public function updateUser(Request $request)
    {
      $data = [
        'first_name'=>$request['first_name'],
        'last_name'=>$request['last_name'],
        'email'=>$request['email'],
        'mobile'=>$request['mobile'],
        'address'=>$request['address'],
        'pincode'=>$request['pincode'],
      ];

      $data = $this->masterModel->updateData('register_user',['id'=>Session::get('userLoginInfo')['user_id']],$data);
      return json_encode($data);
    }

    public function updateProfile(Request $request)
    { 
      $data = [
        'first_name'=>$request['first_name'],
        'last_name'=>$request['last_name'],
        'email'=>$request['email'],
        'mobile'=>$request['mobile'],
        'address'=>$request['address'],
        'pincode'=>$request['pincode'],
        'state'=>$request['state'],
        'city'=>$request['city'],
      ];
      
      $data = $this->masterModel->updateData('register_user',['id'=>Session::get('userLoginInfo')['user_id']],$data);
      return json_encode($data);
     }

    public function updateProfilePassword(Request $request)
    {
      $pass = $this->masterModel->getSingleData('register_user',['id'=>Session::get('userLoginInfo')['user_id']]);
      if(Hash::check($request['password'],$pass->password))
      {
        $data = $this->masterModel->updateData('register_user',['id'=>Session::get('userLoginInfo')['user_id']],['password'=>Hash::make($request['new_pass'])]);
        if($data)
        {
          return json_encode(true);
        }
      }else
      {
        return json_encode('wrong');
      }
    }

    public function creditSignup(Request $request)
    {
      $this->validate($request,[]);

      $data = [
        'plan_id'=>$request['plan'],
        'security_question'=>$request['security_question'],
        'security_answer'=>$request['security_answer'],
        'social_security'=>$request['social_security'],
        'dob'=>date('Y-m-d',strtotime($request['dob']))
      ];
      $data = $this->masterModel->updateData('register_user',['id'=>Session::get('userLoginInfo')['user_id']],$data);
      return json_encode($data);
    }

    public function postAddName(Request $request)
    {
      if(isset($request['firstname']))
      {
        $name = $this->masterModel->getSingleCol('register_user','additional_first_name',['id'=>Session::get('userLoginInfo')['user_id']]);
        if($name!=''){$first_name = $name.','.$request['firstname'];}else{$first_name = $request['firstname'];}
        $data = ['additional_first_name'=>$first_name];
      }

      if(isset($request['lastname']))
      {
        $name = $this->masterModel->getSingleCol('register_user','additional_last_name',['id'=>Session::get('userLoginInfo')['user_id']]);
        if($name!=''){$first_name = $name.','.$request['lastname'];}else{$last_name = $request['lastname'];}
        $data = ['additional_last_name'=>$last_name];
      }
      $data = $this->masterModel->updateData('register_user',['id'=>Session::get('userLoginInfo')['user_id']],$data);
      return json_encode($data);
    }

    public function deleteName(Request $request)
    {
      if($request['col']=='firstname'){$col = 'additional_first_name';}else{$col = 'additional_last_name';}
      $name = $this->masterModel->getSingleCol('register_user',$col,['id'=>Session::get('userLoginInfo')['user_id']]);
      if($name!='')
      {
        $fName = [];
        $f = explode(',', $name);
        foreach($f as $val)
        {
          if($val!=$request['name'])
          {
            $fName[] = $val;
          }
        }
        $data = $this->masterModel->updateData('register_user',['id'=>Session::get('userLoginInfo')['user_id']],[$col=>implode(',', $fName)]);
        return json_encode($data);
      }
    }    

    public function faq()
    {
      return view('frontend.faq');
    }

    public function offer()
    {
      $data['data'] = $this->masterModel->getAllData('credit_offer',['status'=>1]);

      return view('frontend.card_offer',$data);
    }

    public function saveUserImage(Request $request)
    {
      // image upload code
      $image_name='';
      $image_file = $request->file('file');
      if(!is_null($image_file) && in_array($image_file->getClientOriginalExtension(), $this->allow_image)){
          $image_name = uniqid().'_'.$image_file->getClientOriginalName();
          $image_file->move('uploads/user_file/',$image_name);
          $image_name = $image_name;
      }
      
      $up=$this->masterModel->updateData('register_user',['id'=>Session::get('userLoginInfo')['user_id']],[$request['file_name']=>$image_name]);
      if($up){
        return 'success';
      }else{
        return 'fail';
      }
    }

    public function deleteUserImage(Request $request)
    {
      $user = $this->masterModel->getSingleCol('register_user',$request['col'],['id'=>Session::get('userLoginInfo')['user_id']]);
      if($user!='')
      {
        $img = url('/').'/uploads/user_file/'.$user;
        if($user!='' && file_exists($img)){
            unlink($img);
        }
        $data = $this->masterModel->updateData('register_user',['id'=>Session::get('userLoginInfo')['user_id']],[$request['col']=>'']);
        return json_encode($data);
      }
    }

    public function sendPasswordLink()
    {       
        return view('frontend.forgot_password');
    }

    public function updatePassword()
    {
        $email = request()->segment(count(request()->segments()));
        $data['email'] =  decrypt($email);
        
        return view('frontend.reset_password',$data);
    }

    public function forgotPassword(Request $request)
    {
    	$email=$request->email;

    	$this->validate($request, [
    		'email'=>'email|required'
    	]);

    	$exist=$this->masterModel->getSingleDataFirst('register_user',['email'=>$email]);
    	if($exist)
      {

    		$toEmail=$request->email;

    		$toName=$exist->first_name;

    		$subject='Fix Your Credit : Password Reset Link';

    		$link=url('/')."/reset_password/".encrypt($request->email);

    		$msg='To reset your password for Fix Your Credit <a href="'.$link.'">Click here</a>';

    		$mail = $this->masterModel->html_email($toEmail,$toName,$subject,$msg);

        Session::flash('message', 'PLEASE CHECK YOUR EMAIL TO RESET YOUR PASSWORD.');
        return Redirect::back();
    	}else
      {
    		Session::flash('message', 'THE GIVEN EMAIL ADDRESS NOT EXISTS!.');
        return Redirect::back();
    	}
    }

    public function changePassword(Request $request)
    {
    	$this->validate($request, [
        'email'=>'required|email',
    		'password'=> 'required|min:8',
        'confirm_password'=>'required|min:8|same:password'
      ]);

      $saveData['password']=Hash::make($request->password);

      $where['email']=$request->email; 

      $exist = $this->masterModel->checkDataExist('register_user',$where);
      
      if($exist)
      {
      	  $save=$this->masterModel->updateData('register_user',$where,$saveData);
        	if($save)
          {
        		return Redirect('/');
        	}
      }
      else
      {
          Session::flash('message', 'PLEASE ENTER REGISTER EMAIL ADDRESS.');   
          return Redirect::back();
      }

    }

    public function resetPassword(Request $request)
    { 

    	$table=$request->table;

    	$initl=substr($table, 0, 3);

    	if($table=='companies'){$initl=substr($table, 0, 4);}

    	$this->validate($request, [

    		'old_password'=> 'min:6|required',

    		'password'=> 'min:6|required_with:confirm_password|same:confirm_password',

        'confirm_password'=>'min:6'

    	]);

    	$exist=$this->masterModel->getSingleDataFirst($table,[$initl.'_email'=>Session::get('userLoginInfo')->email]);

    	if(Hash::check($request->password,$request->old_password))
      {

    		$saveData[$initl.'_password']=Hash::make($request->password);

    		$where[$initl.'_id']=Session::get('userLoginInfo')->user_id;

    		$save=$this->masterModel->updateData($table,$saveData,$where);

	    	if($save)
        {
	    		return json_encode('success');
	    	}
        else
        {
	    		return json_encode('fail');
	    	}
    	}
      else
      {
    		return json_encode('old_pass_miss_match');
    	}
    }


    public function thankYou()
    {
        return view('frontend.thank_you');
    }

    public function logOut()
    {
        Session::forget('userLoginInfo');
        return redirect('/');
    }

}